/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CompoundRendererProvider;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.LabelRenderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Value;
import java.nio.charset.StandardCharsets;

final class ByteArrayAsStringRenderer
extends CompoundRendererProvider {
    ByteArrayAsStringRenderer() {
    }

    @Override
    protected String getName() {
        return "String";
    }

    @Override
    protected String getClassName() {
        return "byte[]";
    }

    @Override
    protected ValueLabelRenderer getValueLabelRenderer() {
        LabelRenderer labelRenderer = new LabelRenderer(){

            @Override
            public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener labelListener) throws EvaluateException {
                byte[] bytes;
                Value value2;
                if (evaluationContext instanceof EvaluationContextImpl && !((EvaluationContextImpl)evaluationContext).isEvaluationPossible() && (value2 = descriptor.getValue()) instanceof ArrayReference && (bytes = DebuggerUtilsImpl.readBytesArray(value2)) != null) {
                    return new String(bytes, StandardCharsets.UTF_8);
                }
                return super.calcLabel(descriptor, evaluationContext, labelListener);
            }
        };
        labelRenderer.setLabelExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "new String(this)"));
        return labelRenderer;
    }
}

