/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.ui.XBreakpointClassGroup;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.icons.AllIcons;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XBreakpointGroupingByClassRule<B>
extends XBreakpointGroupingRule<B, XBreakpointClassGroup> {
    XBreakpointGroupingByClassRule() {
        super("XBreakpointGroupingByClassRule", JavaDebuggerBundle.message((String)"rule.name.group.by.class", (Object[])new Object[0]));
    }

    public int getPriority() {
        return 400;
    }

    public XBreakpointClassGroup getGroup(@NotNull B b, @NotNull Collection<? extends XBreakpointClassGroup> groups) {
        if (b instanceof XBreakpoint) {
            Breakpoint javaBreakpoint = BreakpointManager.getJavaBreakpoint((XBreakpoint)b);
            if (javaBreakpoint == null) {
                return null;
            }
            String className2 = javaBreakpoint.getShortClassName();
            String packageName = javaBreakpoint.getPackageName();
            if (className2 == null) {
                return null;
            }
            for (XBreakpointClassGroup xBreakpointClassGroup : groups) {
                if (!xBreakpointClassGroup.getClassName().equals(className2) || !xBreakpointClassGroup.getPackageName().equals(packageName)) continue;
                return xBreakpointClassGroup;
            }
            return new XBreakpointClassGroup(packageName, className2);
        }
        return null;
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Actions.GroupByClass;
    }
}

