/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.settings.FieldDataBinding;
import java.lang.reflect.Field;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;

public class TextComponentBinding
extends FieldDataBinding {
    private final JTextComponent myTextComponent;

    public TextComponentBinding(@NonNls String dataFieldName, JTextComponent textComponent) {
        super(dataFieldName);
        this.myTextComponent = textComponent;
    }

    @Override
    public void doLoadData(Object from, Field field) throws IllegalAccessException {
        String value2 = (String)field.get(from);
        this.myTextComponent.setText(value2);
    }

    @Override
    public void doSaveData(Object to, Field field) throws IllegalAccessException {
        field.set(to, this.myTextComponent.getText().trim());
    }

    @Override
    protected boolean isModified(Object obj, Field field) throws IllegalAccessException {
        String value2 = (String)field.get(obj);
        return this.myTextComponent.getText().trim().equals(value2);
    }
}

