/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.utils;

import com.intellij.openapi.util.text.StringUtil;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

class NamesUtils {
    NamesUtils() {
    }

    @NotNull
    static String getUniqueName(@NotNull ObjectReference ref) {
        String shortName = StringUtil.getShortName((String)ref.referenceType().name());
        String name2 = shortName.replace("[]", "Array");
        return String.format("%s@%d", name2, ref.uniqueID());
    }

    @NotNull
    static String getArrayUniqueName(@NotNull ArrayReference ref) {
        String shortName = StringUtil.getShortName((String)ref.referenceType().name());
        int length = ref.length();
        String name2 = shortName.replaceFirst(Pattern.quote("[]"), String.format("[%d]", length));
        return String.format("%s@%d", name2, ref.uniqueID());
    }
}

