/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionEditor;
import java.awt.Component;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExpressionEditorWithHistory
extends XDebuggerExpressionEditor {
    private static final String HISTORY_ID_PREFIX = "filtering";

    ExpressionEditorWithHistory(@NotNull Project project, @NotNull String className2, @NotNull XDebuggerEditorsProvider debuggerEditorsProvider, @Nullable Disposable parentDisposable) {
        super(project, debuggerEditorsProvider, HISTORY_ID_PREFIX + className2, null, XExpressionImpl.EMPTY_EXPRESSION, false, true, true);
        new AnAction(JavaDebuggerBundle.message((String)"instances.window.show.history", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ExpressionEditorWithHistory.this.showHistory();
            }

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabled(LookupManager.getActiveLookup((Editor)ExpressionEditorWithHistory.this.getEditor()) == null);
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"DOWN"}), this.getComponent(), parentDisposable);
        ApplicationManager.getApplication().executeOnPooledThread(() -> ApplicationManager.getApplication().runReadAction(() -> {
            if (!project.isDisposed()) {
                PsiClass psiClass = DebuggerUtils.findClass((String)className2, (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
                ApplicationManager.getApplication().invokeLater(() -> this.setContext((PsiElement)psiClass), project.getDisposed());
            }
        }));
    }

    private void showHistory() {
        List expressions2 = this.getRecentExpressions();
        if (!expressions2.isEmpty()) {
            ListPopupImpl historyPopup = new ListPopupImpl(this.getProject(), (ListPopupStep)new BaseListPopupStep<XExpression>(null, expressions2){

                public PopupStep onChosen(XExpression selectedValue, boolean finalChoice) {
                    ExpressionEditorWithHistory.this.setExpression(selectedValue);
                    ExpressionEditorWithHistory.this.requestFocusInEditor();
                    return FINAL_CHOICE;
                }
            }){

                protected ListCellRenderer getListElementRenderer() {
                    return SimpleListCellRenderer.create((String)"", XExpression::getExpression);
                }
            };
            historyPopup.getList().setFont(EditorUtil.getEditorFont());
            historyPopup.showUnderneathOf((Component)this.getEditorComponent());
        }
    }
}

