/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.events;

import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ObjectCollectedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerContextCommandImpl
extends SuspendContextCommandImpl {
    private static final Logger LOG = Logger.getInstance(DebuggerContextCommandImpl.class);
    private final DebuggerContextImpl myDebuggerContext;
    private final ThreadReferenceProxyImpl myCustomThread;
    private SuspendContextImpl myCustomSuspendContext;

    protected DebuggerContextCommandImpl(@NotNull DebuggerContextImpl debuggerContext) {
        this(debuggerContext, null);
    }

    protected DebuggerContextCommandImpl(@NotNull DebuggerContextImpl debuggerContext, @Nullable ThreadReferenceProxyImpl customThread) {
        super(debuggerContext.getSuspendContext());
        this.myDebuggerContext = debuggerContext;
        this.myCustomThread = customThread;
    }

    @Override
    @Nullable
    public SuspendContextImpl getSuspendContext() {
        if (this.myCustomSuspendContext == null) {
            this.myCustomSuspendContext = super.getSuspendContext();
            ThreadReferenceProxyImpl thread = this.getThread();
            if (this.myCustomThread != null && (this.myCustomSuspendContext == null || this.myCustomSuspendContext.isResumed() || !this.myCustomSuspendContext.suspends(thread))) {
                this.myCustomSuspendContext = SuspendManagerUtil.findContextByThread(this.myDebuggerContext.getDebugProcess().getSuspendManager(), thread);
            }
        }
        return this.myCustomSuspendContext;
    }

    private ThreadReferenceProxyImpl getThread() {
        return this.myCustomThread != null ? this.myCustomThread : this.myDebuggerContext.getThreadProxy();
    }

    public final DebuggerContextImpl getDebuggerContext() {
        return this.myDebuggerContext;
    }

    @Override
    public final void contextAction(@NotNull SuspendContextImpl suspendContext) {
        boolean isSuspendedByContext;
        SuspendManager suspendManager = this.myDebuggerContext.getDebugProcess().getSuspendManager();
        ThreadReferenceProxyImpl thread = this.getThread();
        try {
            isSuspendedByContext = suspendManager.isSuspended(thread);
        }
        catch (ObjectCollectedException ignored) {
            this.notifyCancelled();
            return;
        }
        if (isSuspendedByContext) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Context thread " + suspendContext.getThread());
                LOG.debug("Debug thread" + thread);
            }
            this.threadAction(suspendContext);
        } else {
            SuspendContextImpl suspendContextForThread;
            SuspendContextImpl suspendContextImpl = suspendContextForThread = this.myCustomThread != null ? suspendContext : SuspendManagerUtil.findContextByThread(suspendManager, thread);
            if (suspendContextForThread != null && thread.status() != 0) {
                suspendContextForThread.postponeCommand(this);
            } else {
                this.notifyCancelled();
            }
        }
    }

    @Deprecated
    public void threadAction() {
        throw new AbstractMethodError();
    }

    public void threadAction(@NotNull SuspendContextImpl suspendContext) {
        this.threadAction();
    }
}

