/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CaptureTraverser {
    private static final CaptureTraverser INVALID = new CaptureTraverser(-1);
    private static final CaptureTraverser DIRECT = new CaptureTraverser(0);
    private final int myIterationCount;

    private CaptureTraverser(int iterationCount) {
        this.myIterationCount = iterationCount;
    }

    public CaptureTraverser oneLevelLess() {
        return this.myIterationCount == -1 ? this : new CaptureTraverser(this.myIterationCount - 1);
    }

    public boolean isValid() {
        return this.myIterationCount > -1;
    }

    @Contract(value="null -> null")
    @Nullable
    public ObjectReference traverse(@Nullable ObjectReference objRef) {
        if (objRef == null || !this.isValid()) {
            return null;
        }
        if (this.myIterationCount <= 0) {
            return objRef;
        }
        ObjectReference thisRef = objRef;
        for (int idx = 0; idx < this.myIterationCount && thisRef != null; ++idx) {
            thisRef = CaptureTraverser.getOuterObject(thisRef);
        }
        return thisRef;
    }

    @NotNull
    public static CaptureTraverser direct() {
        return DIRECT;
    }

    @NotNull
    public static CaptureTraverser create(@Nullable PsiClass targetClass, @Nullable PsiClass fromClass, boolean checkInheritance) {
        if (targetClass == null || fromClass == null) {
            return INVALID;
        }
        int iterationCount = 0;
        while (!(fromClass == null || fromClass.equals(targetClass) || checkInheritance && fromClass.isInheritor(targetClass, true))) {
            ++iterationCount;
            fromClass = CaptureTraverser.getOuterClass(fromClass);
        }
        return fromClass == null ? INVALID : new CaptureTraverser(iterationCount);
    }

    @Nullable
    private static PsiClass getOuterClass(PsiClass aClass) {
        return aClass == null ? null : (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)aClass, PsiClass.class, (boolean)true);
    }

    @Nullable
    private static ObjectReference getOuterObject(ObjectReference objRef) {
        if (objRef == null) {
            return null;
        }
        List<Field> list = objRef.referenceType().fields();
        for (Field field : list) {
            ObjectReference rv;
            String name2 = field.name();
            if (name2 == null || !name2.startsWith("this$") || !field.isFinal() || !field.isSynthetic() || field.isStatic() || (rv = (ObjectReference)objRef.getValue(field)) == null) continue;
            return rv;
        }
        return null;
    }
}

