/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.concurrency.JobScheduler;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.BitUtil;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreadBlockedMonitor {
    private static final Logger LOG = Logger.getInstance(ThreadBlockedMonitor.class);
    private final Collection<ThreadReferenceProxy> myWatchedThreads = new HashSet<ThreadReferenceProxy>();
    private ScheduledFuture<?> myTask;
    private final DebugProcessImpl myProcess;

    public ThreadBlockedMonitor(DebugProcessImpl process2, Disposable disposable) {
        this.myProcess = process2;
        Disposer.register((Disposable)disposable, this::cancelTask);
    }

    static int getSingleThreadedEvaluationThreshold() {
        return Registry.intValue((String)"debugger.evaluate.single.threaded.timeout", (int)1000);
    }

    @Nullable
    public InvocationWatcher startInvokeWatching(int invokePolicy, @Nullable ThreadReferenceProxyImpl thread, @NotNull SuspendContextImpl context) {
        if (thread != null && ThreadBlockedMonitor.getSingleThreadedEvaluationThreshold() > 0 && context.getSuspendPolicy() == 2 && BitUtil.isSet((int)invokePolicy, (int)1)) {
            return new InvocationWatcher(this.myProcess, thread);
        }
        return null;
    }

    public void startWatching(@Nullable ThreadReferenceProxy thread) {
        if (!Registry.is((String)"debugger.monitor.blocked.threads")) {
            return;
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (thread != null) {
            this.myWatchedThreads.add(thread);
            if (this.myTask == null) {
                this.myTask = JobScheduler.getScheduler().scheduleWithFixedDelay(this::checkBlockingThread, 5L, 5L, TimeUnit.SECONDS);
            }
        }
    }

    public void stopWatching(@Nullable ThreadReferenceProxy thread) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (thread != null) {
            this.myWatchedThreads.remove(thread);
        } else {
            this.myWatchedThreads.clear();
        }
        if (this.myWatchedThreads.isEmpty()) {
            this.cancelTask();
        }
    }

    private void cancelTask() {
        if (this.myTask != null) {
            this.myTask.cancel(true);
            this.myTask = null;
        }
    }

    private static void onThreadBlocked(@NotNull ThreadReference blockedThread, final @NotNull ThreadReference blockingThread, final DebugProcessImpl process2) {
        XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(JavaDebuggerBundle.message((String)"status.thread.blocked.by", (Object[])new Object[]{blockedThread.name(), blockingThread.name()}), JavaDebuggerBundle.message((String)"status.thread.blocked.by.resume", (Object[])new Object[]{blockingThread.name()}), NotificationType.INFORMATION, (notification, event) -> {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                notification.expire();
                process2.getManagerThread().schedule(new DebuggerCommandImpl(){

                    @Override
                    protected void action() {
                        ThreadReferenceProxyImpl threadProxy = process2.getVirtualMachineProxy().getThreadReferenceProxy(blockingThread);
                        SuspendContextImpl suspendingContext = SuspendManagerUtil.getSuspendingContext(process2.getSuspendManager(), threadProxy);
                        process2.getManagerThread().invoke(process2.createResumeThreadCommand(suspendingContext, threadProxy));
                    }
                });
            }
        }).notify(process2.getProject());
    }

    private ThreadReference getCurrentThread() {
        ThreadReferenceProxyImpl threadProxy = this.myProcess.getDebuggerContext().getThreadProxy();
        return threadProxy != null ? threadProxy.getThreadReference() : null;
    }

    private void checkBlockingThread() {
        this.myProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void action() {
                if (ThreadBlockedMonitor.this.myWatchedThreads.isEmpty()) {
                    return;
                }
                VirtualMachineProxyImpl vmProxy = ThreadBlockedMonitor.this.myProcess.getVirtualMachineProxy();
                vmProxy.getVirtualMachine().suspend();
                try {
                    for (ThreadReferenceProxy thread : ThreadBlockedMonitor.this.myWatchedThreads) {
                        try {
                            ThreadReference blockingThread;
                            ObjectReference waitedMonitor = vmProxy.canGetCurrentContendedMonitor() ? thread.getThreadReference().currentContendedMonitor() : null;
                            if (waitedMonitor == null || !vmProxy.canGetMonitorInfo() || (blockingThread = waitedMonitor.owningThread()) == null || blockingThread.suspendCount() <= 1 || ThreadBlockedMonitor.this.getCurrentThread() == blockingThread) continue;
                            ThreadBlockedMonitor.onThreadBlocked(thread.getThreadReference(), blockingThread, ThreadBlockedMonitor.this.myProcess);
                        }
                        catch (ObjectCollectedException objectCollectedException) {}
                    }
                }
                catch (IncompatibleThreadStateException e) {
                    LOG.info((Throwable)e);
                }
                finally {
                    vmProxy.getVirtualMachine().resume();
                }
            }
        });
    }

    public static class InvocationWatcher {
        private final AtomicBoolean myObsolete = new AtomicBoolean();
        private final AtomicBoolean myAllResumed = new AtomicBoolean();
        private final Future myTask;
        private final ThreadReferenceProxyImpl myThread;
        private final DebugProcessImpl myProcess;

        private InvocationWatcher(DebugProcessImpl process2, @NotNull ThreadReferenceProxyImpl thread) {
            this.myProcess = process2;
            this.myThread = thread;
            this.myTask = JobScheduler.getScheduler().schedule(this::checkInvocation, (long)ThreadBlockedMonitor.getSingleThreadedEvaluationThreshold(), TimeUnit.MILLISECONDS);
        }

        void invocationFinished() {
            this.myObsolete.set(true);
            if (this.myTask.isDone() && this.myAllResumed.get()) {
                this.myThread.getVirtualMachine().getVirtualMachine().suspend();
                this.myThread.getThreadReference().resume();
            } else {
                this.myTask.cancel(true);
            }
        }

        private void checkInvocation() {
            this.myProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() {
                    if (myObsolete.get()) {
                        return;
                    }
                    VirtualMachine virtualMachine = myThread.getVirtualMachine().getVirtualMachine();
                    virtualMachine.suspend();
                    try {
                        ThreadReference threadReference = myThread.getThreadReference();
                        if (!myObsolete.get() && threadReference.suspendCount() == 1) {
                            myAllResumed.set(true);
                            threadReference.suspend();
                            virtualMachine.resume();
                        }
                    }
                    finally {
                        virtualMachine.resume();
                    }
                }
            });
        }
    }
}

