/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.Patches;
import com.intellij.ProjectTopics;
import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugEnvironment;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.ThreadBlockedMonitor;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationListener;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.intellij.debugger.engine.requests.MethodReturnValueWatcher;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.impl.attach.PidRemoteConnection;
import com.intellij.debugger.jdi.EmptyConnectorArgument;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint;
import com.intellij.debugger.ui.breakpoints.SteppingBreakpoint;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.CompoundRendererProvider;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.PrimitiveRenderer;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.ui.classFilter.DebuggerClassFilterProvider;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.jetbrains.jdi.ClassLoaderReferenceImpl;
import com.jetbrains.jdi.VirtualMachineManagerImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebugProcessImpl
extends UserDataHolderBase
implements DebugProcess {
    private static final Logger LOG = Logger.getInstance(DebugProcessImpl.class);
    private final Project myProject;
    private final RequestManagerImpl myRequestManager;
    private volatile VirtualMachineProxyImpl myVirtualMachineProxy = null;
    protected final EventDispatcher<DebugProcessListener> myDebugProcessDispatcher = EventDispatcher.create(DebugProcessListener.class);
    protected final EventDispatcher<EvaluationListener> myEvaluationDispatcher = EventDispatcher.create(EvaluationListener.class);
    private final List<ProcessListener> myProcessListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final StringBuilder myTextBeforeStart = new StringBuilder();
    protected final AtomicReference<State> myState = new AtomicReference<State>(State.INITIAL);
    private volatile ExecutionResult myExecutionResult;
    private RemoteConnection myConnection;
    private JavaDebugProcess myXDebugProcess;
    private volatile Map<String, Connector.Argument> myArguments;
    private final List<NodeRenderer> myRenderers = new ArrayList<NodeRenderer>();
    private final Map<Type, Object> myNodeRenderersMap = new HashMap<Type, Object>();
    private final SuspendManagerImpl mySuspendManager = new SuspendManagerImpl(this);
    protected CompoundPositionManager myPositionManager = CompoundPositionManager.EMPTY;
    private final DebuggerManagerThreadImpl myDebuggerManagerThread;
    private final Semaphore myWaitFor = new Semaphore();
    private final AtomicBoolean myIsFailed = new AtomicBoolean(false);
    private final AtomicBoolean myIsStopped = new AtomicBoolean(false);
    protected DebuggerSession mySession;
    @Nullable
    protected MethodReturnValueWatcher myReturnValueWatcher;
    protected final Disposable myDisposable = Disposer.newDisposable();
    private final Alarm myStatusUpdateAlarm = new Alarm();
    private final ThreadBlockedMonitor myThreadBlockedMonitor = new ThreadBlockedMonitor(this, this.myDisposable);
    private static final int ourTraceMask;
    private volatile SteppingBreakpoint mySteppingBreakpoint;

    protected DebugProcessImpl(Project project) {
        this.myProject = project;
        this.myDebuggerManagerThread = new DebuggerManagerThreadImpl(this.myDisposable, this.myProject);
        this.myRequestManager = new RequestManagerImpl(this);
        NodeRendererSettings.getInstance().addListener(this::reloadRenderers, this.myDisposable);
        NodeRenderer.EP_NAME.addChangeListener(this::reloadRenderers, this.myDisposable);
        CompoundRendererProvider.EP_NAME.addChangeListener(this::reloadRenderers, this.myDisposable);
        this.reloadRenderers();
        this.myDebugProcessDispatcher.addListener((EventListener)new DebugProcessListener(){

            public void paused(@NotNull SuspendContext suspendContext) {
                DebugProcessImpl.this.myThreadBlockedMonitor.stopWatching(suspendContext.getSuspendPolicy() != 2 ? suspendContext.getThread() : null);
            }
        });
    }

    private void reloadRenderers() {
        this.getManagerThread().invoke(new DebuggerCommandImpl(PrioritizedTask.Priority.HIGH){

            @Override
            protected void action() {
                DebugProcessImpl.this.myNodeRenderersMap.clear();
                DebugProcessImpl.this.myRenderers.clear();
                try {
                    NodeRendererSettings.getInstance().getAllRenderers(DebugProcessImpl.this.myProject).stream().filter(NodeRenderer::isEnabled).forEachOrdered(DebugProcessImpl.this.myRenderers::add);
                }
                finally {
                    DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.myProject, () -> {
                        DebuggerSession session = DebugProcessImpl.this.mySession;
                        if (session != null && session.isAttached()) {
                            DebuggerAction.refreshViews(DebugProcessImpl.this.mySession.getXDebugSession());
                        }
                    });
                }
            }
        });
    }

    @Nullable
    public Pair<Method, Value> getLastExecutedMethod() {
        MethodReturnValueWatcher watcher = this.myReturnValueWatcher;
        if (watcher == null) {
            return null;
        }
        Method method = watcher.getLastExecutedMethod();
        if (method == null) {
            return null;
        }
        return Pair.create((Object)method, (Object)watcher.getLastMethodReturnValue());
    }

    public void setWatchMethodReturnValuesEnabled(boolean enabled) {
        MethodReturnValueWatcher watcher = this.myReturnValueWatcher;
        if (watcher != null) {
            watcher.setEnabled(enabled);
        }
    }

    public boolean canGetMethodReturnValue() {
        return this.myReturnValueWatcher != null;
    }

    @Deprecated
    public NodeRenderer getAutoRenderer(ValueDescriptor descriptor) {
        Type type2 = descriptor.getType();
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.isEvaluationPossible()) {
            return DebugProcessImpl.getDefaultRenderer(type2);
        }
        try {
            Object res = this.myNodeRenderersMap.get(type2);
            if (res instanceof NodeRenderer) {
                return (NodeRenderer)res;
            }
            NodeRenderer renderer = this.myRenderers.stream().filter(r -> DebuggerUtilsImpl.suppressExceptions(() -> r.isApplicable(type2), false, true, ClassNotPreparedException.class)).findFirst().orElseGet(() -> DebugProcessImpl.getDefaultRenderer(type2));
            this.myNodeRenderersMap.put(type2, renderer);
            return renderer;
        }
        catch (ClassNotPreparedException e) {
            LOG.info((Throwable)e);
            return DebugProcessImpl.getDefaultRenderer(type2);
        }
    }

    @NotNull
    public CompletableFuture<NodeRenderer> getAutoRendererAsync(@Nullable Type type2) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.isEvaluationPossible()) {
            return CompletableFuture.completedFuture(DebugProcessImpl.getDefaultRenderer(type2));
        }
        try {
            Object renderer = this.myNodeRenderersMap.get(type2);
            if (renderer instanceof NodeRenderer) {
                return CompletableFuture.completedFuture((NodeRenderer)renderer);
            }
            if (renderer instanceof CompletableFuture) {
                return (CompletableFuture)renderer;
            }
            CompletionStage res = DebuggerUtilsImpl.getApplicableRenderers(this.myRenderers, type2).handle((renderers, throwable) -> {
                DebuggerManagerThreadImpl.assertIsManagerThread();
                NodeRenderer r = (NodeRenderer)ContainerUtil.getFirstItem((List)renderers);
                if (r == null || throwable != null) {
                    r = DebugProcessImpl.getDefaultRenderer(type2);
                    this.myNodeRenderersMap.remove(type2);
                } else {
                    this.myNodeRenderersMap.put(type2, r);
                }
                return r;
            });
            this.myNodeRenderersMap.putIfAbsent(type2, res);
            return res;
        }
        catch (ClassNotPreparedException e) {
            LOG.info((Throwable)e);
            return CompletableFuture.completedFuture(DebugProcessImpl.getDefaultRenderer(type2));
        }
    }

    @NotNull
    public static NodeRenderer getDefaultRenderer(Value value2) {
        return DebugProcessImpl.getDefaultRenderer(value2 != null ? value2.type() : null);
    }

    @NotNull
    public static NodeRenderer getDefaultRenderer(Type type2) {
        NodeRendererSettings settings = NodeRendererSettings.getInstance();
        PrimitiveRenderer primitiveRenderer = settings.getPrimitiveRenderer();
        if (primitiveRenderer.isApplicable(type2)) {
            return primitiveRenderer;
        }
        ArrayRenderer arrayRenderer = settings.getArrayRenderer();
        if (arrayRenderer.isApplicable(type2)) {
            return arrayRenderer;
        }
        ClassRenderer classRenderer = settings.getClassRenderer();
        LOG.assertTrue(classRenderer.isApplicable(type2), (Object)type2.name());
        return classRenderer;
    }

    private int getTraceMask() {
        int mask = ourTraceMask;
        DebugEnvironment environment = this.mySession.getDebugEnvironment();
        if (environment instanceof DefaultDebugEnvironment) {
            mask |= ((DefaultDebugEnvironment)environment).getTraceMode();
        }
        return mask;
    }

    protected void commitVM(VirtualMachine vm) {
        if (!this.isInInitialState()) {
            LOG.error("State is invalid " + (Object)((Object)this.myState.get()));
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myPositionManager = new CompoundPositionManager(new PositionManagerImpl(this));
        this.myProject.getMessageBus().connect(this.myDisposable).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                DumbService.getInstance((Project)DebugProcessImpl.this.myProject).runWhenSmart(() -> DebugProcessImpl.this.getManagerThread().schedule(PrioritizedTask.Priority.HIGH, () -> {
                    DebugProcessImpl.this.myPositionManager.clearCache();
                    DebuggerUIUtil.invokeLater(() -> DebugProcessImpl.this.mySession.refresh(true));
                }));
            }
        });
        LOG.debug("*******************VM attached******************");
        vm.setDebugTraceMode(this.getTraceMask());
        this.checkVirtualMachineVersion(vm);
        this.myVirtualMachineProxy = new VirtualMachineProxyImpl(this, vm);
    }

    private void stopConnecting() {
        Map<String, Connector.Argument> arguments = this.myArguments;
        try {
            Connector connector;
            if (arguments == null) {
                return;
            }
            if (this.myConnection.isServerMode() && (connector = this.getConnector()) instanceof ListeningConnector) {
                ((ListeningConnector)connector).stopListening(arguments);
            }
        }
        catch (IllegalConnectorArgumentsException | IOException | IllegalArgumentException e) {
            LOG.debug((Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printToConsole(String text2) {
        List<ProcessListener> list = this.myProcessListeners;
        synchronized (list) {
            if (this.myExecutionResult == null) {
                this.myTextBeforeStart.append(text2);
            } else {
                this.printToConsoleImpl(text2);
            }
        }
    }

    private void printToConsoleImpl(String text2) {
        this.myExecutionResult.getProcessHandler().notifyTextAvailable(text2, ProcessOutputTypes.SYSTEM);
    }

    public ProcessHandler getProcessHandler() {
        return this.myExecutionResult != null ? this.myExecutionResult.getProcessHandler() : null;
    }

    protected void doStep(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread, int size, int depth, RequestHint hint) {
        if (stepThread == null) {
            return;
        }
        try {
            ThreadReference stepThreadReference = stepThread.getThreadReference();
            if (LOG.isDebugEnabled()) {
                LOG.debug("DO_STEP: creating step request for " + stepThreadReference);
            }
            this.deleteStepRequests(stepThreadReference);
            EventRequestManager requestManager = this.getVirtualMachineProxy().eventRequestManager();
            StepRequest stepRequest = requestManager.createStepRequest(stepThreadReference, size, depth);
            if (!(hint != null && hint.isIgnoreFilters() || DebugProcessImpl.isPositionFiltered(DebugProcessImpl.getLocation(stepThread, suspendContext)))) {
                DebugProcessImpl.getActiveFilters().forEach(f -> stepRequest.addClassExclusionFilter(f.getPattern()));
            }
            stepRequest.setSuspendPolicy(suspendContext.getSuspendPolicy() == 1 ? 1 : 2);
            stepRequest.addCountFilter(1);
            if (hint != null) {
                stepRequest.putProperty("hint", hint);
            }
            try {
                stepRequest.enable();
            }
            catch (IllegalThreadStateException e) {
                requestManager.deleteEventRequest(stepRequest);
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
    }

    static boolean isPositionFiltered(Location location) {
        List<ClassFilter> activeFilters = DebugProcessImpl.getActiveFilters();
        if (!activeFilters.isEmpty()) {
            ReferenceType referenceType;
            ReferenceType referenceType2 = referenceType = location != null ? location.declaringType() : null;
            if (referenceType != null) {
                String currentClassName = referenceType.name();
                return currentClassName != null && DebuggerUtilsEx.isFiltered(currentClassName, activeFilters);
            }
        }
        return false;
    }

    @NotNull
    private static List<ClassFilter> getActiveFilters() {
        DebuggerSettings settings = DebuggerSettings.getInstance();
        StreamEx stream = StreamEx.of((Collection)DebuggerClassFilterProvider.EP_NAME.getExtensionList()).flatCollection(DebuggerClassFilterProvider::getFilters);
        if (settings.TRACING_FILTERS_ENABLED) {
            stream = stream.prepend((Object[])settings.getSteppingFilters());
        }
        return ((StreamEx)stream.filter(ClassFilter::isEnabled)).toList();
    }

    void deleteStepRequests(@Nullable ThreadReference stepThread) {
        EventRequestManager requestManager = this.getVirtualMachineProxy().eventRequestManager();
        for (StepRequest request : new ArrayList<StepRequest>(requestManager.stepRequests())) {
            if (stepThread != null && !stepThread.equals(request.thread())) continue;
            try {
                requestManager.deleteEventRequest(request);
            }
            catch (ObjectCollectedException objectCollectedException) {
            }
            catch (VMDisconnectedException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    static int getFrameCount(@Nullable ThreadReferenceProxyImpl thread, @NotNull SuspendContextImpl suspendContext) {
        if (thread != null) {
            if (thread.equals(suspendContext.getThread())) {
                return suspendContext.frameCount();
            }
            try {
                return thread.frameCount();
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        return 0;
    }

    @Nullable
    static Location getLocation(@Nullable ThreadReferenceProxyImpl thread, @NotNull SuspendContextImpl suspendContext) {
        if (thread != null) {
            if (thread.equals(suspendContext.getThread())) {
                return suspendContext.getLocation();
            }
            try {
                StackFrameProxyImpl stackFrame;
                if (thread.frameCount() > 0 && (stackFrame = thread.frame(0)) != null) {
                    return stackFrame.location();
                }
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        return null;
    }

    private VirtualMachine createVirtualMachineInt() throws ExecutionException {
        try {
            if (this.myArguments != null) {
                throw new IOException(JavaDebuggerBundle.message((String)"error.debugger.already.listening", (Object[])new Object[0]));
            }
            String port = this.myConnection.getDebuggerAddress();
            Connector connector = this.getConnector();
            this.myArguments = connector.defaultArguments();
            if (this.myConnection instanceof PidRemoteConnection && !((PidRemoteConnection)this.myConnection).isFixedAddress()) {
                String pid = ((PidRemoteConnection)this.myConnection).getPid();
                if (StringUtil.isEmpty((String)pid)) {
                    throw new CantRunException(JavaDebuggerBundle.message((String)"error.no.pid", (Object[])new Object[0]));
                }
                this.setConnectorArgument("pid", pid);
            } else if (this.myConnection.isServerMode()) {
                if (this.myArguments == null) {
                    throw new CantRunException(JavaDebuggerBundle.message((String)"error.no.debug.listen.port", (Object[])new Object[0]));
                }
            } else {
                if (this.myConnection.isUseSockets()) {
                    String debuggerHostName = this.myConnection.getDebuggerHostName();
                    if (debuggerHostName != null) {
                        this.setConnectorArgument("hostname", debuggerHostName);
                    }
                    if (port == null) {
                        throw new CantRunException(JavaDebuggerBundle.message((String)"error.no.debug.attach.port", (Object[])new Object[0]));
                    }
                    this.setConnectorArgument("port", port);
                } else {
                    if (port == null) {
                        throw new CantRunException(JavaDebuggerBundle.message((String)"error.no.shmem.address", (Object[])new Object[0]));
                    }
                    this.setConnectorArgument("name", port);
                }
                this.setConnectorArgument("timeout", "0");
            }
            VirtualMachine virtualMachine = connector instanceof AttachingConnector ? this.attachConnector((AttachingConnector)connector) : this.connectorListen(port, (ListeningConnector)connector);
            return virtualMachine;
        }
        catch (IOException e) {
            throw new ExecutionException(DebugProcessImpl.processIOException(e, JavaDebuggerBundle.getAddressDisplayName((RemoteConnection)this.myConnection)), (Throwable)e);
        }
        catch (IllegalConnectorArgumentsException e) {
            throw new ExecutionException(DebugProcessImpl.processError(e), (Throwable)e);
        }
        finally {
            this.myArguments = null;
        }
    }

    private void setConnectorArgument(String name2, String value2) {
        Connector.Argument argument = this.myArguments.get(name2);
        if (argument != null) {
            argument.setValue(value2);
        }
    }

    private VirtualMachine connectorListen(String address, ListeningConnector connector) throws CantRunException, IOException, IllegalConnectorArgumentsException {
        Connector.Argument portArg;
        if (address == null) {
            throw new CantRunException(JavaDebuggerBundle.message((String)"error.no.debug.listen.port", (Object[])new Object[0]));
        }
        Connector.Argument argument = portArg = this.myConnection.isUseSockets() ? this.myArguments.get("port") : this.myArguments.get("name");
        if (portArg != null) {
            portArg.setValue(address);
            if (address.length() == 0 || address.equals("0")) {
                EmptyConnectorArgument uniqueArg = new EmptyConnectorArgument("argForUniqueness");
                this.myArguments.put(uniqueArg.name(), uniqueArg);
            }
        }
        if (Registry.is((String)"debugger.jb.jdi") || SystemInfo.isJavaVersionAtLeast((int)13)) {
            this.setConnectorArgument("localAddress", "*");
        }
        this.setConnectorArgument("timeout", "0");
        try {
            String listeningAddress = connector.startListening(this.myArguments);
            String port = StringUtil.substringAfterLast((String)listeningAddress, (String)":");
            if (port != null) {
                listeningAddress = port;
            }
            this.myConnection.setDebuggerAddress(listeningAddress);
            this.myConnection.setApplicationAddress(listeningAddress);
            ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).connectorIsReady();
            VirtualMachine virtualMachine = connector.accept(this.myArguments);
            return virtualMachine;
        }
        catch (IllegalArgumentException e) {
            throw new CantRunException(e.getLocalizedMessage());
        }
        finally {
            if (this.myArguments != null) {
                try {
                    connector.stopListening(this.myArguments);
                }
                catch (IllegalConnectorArgumentsException | IllegalArgumentException exception) {}
            }
        }
    }

    private VirtualMachine attachConnector(AttachingConnector connector) throws IOException, IllegalConnectorArgumentsException, CantRunException {
        ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).connectorIsReady();
        try {
            return connector.attach(this.myArguments);
        }
        catch (IllegalArgumentException e) {
            throw new CantRunException(e.getLocalizedMessage());
        }
    }

    public void showStatusText(String text2) {
        this.myStatusUpdateAlarm.cancelAllRequests();
        this.myStatusUpdateAlarm.addRequest(() -> {
            if (!this.myProject.isDisposed()) {
                StatusBarUtil.setStatusBarInfo((Project)this.myProject, (String)text2);
            }
        }, 50);
    }

    private Connector getConnector() throws ExecutionException {
        if (this.myConnection instanceof PidRemoteConnection && !((PidRemoteConnection)this.myConnection).isFixedAddress()) {
            return ((PidRemoteConnection)this.myConnection).getConnector(this);
        }
        return DebugProcessImpl.findConnector(this.myConnection.isUseSockets(), this.myConnection.isServerMode());
    }

    @NotNull
    public static Connector findConnector(boolean useSockets, boolean listen) throws ExecutionException {
        String connectorName = (Registry.is((String)"debugger.jb.jdi") ? "com.jetbrains.jdi." : "com.sun.jdi.") + (useSockets ? "Socket" : "SharedMemory") + (listen ? "Listen" : "Attach");
        return DebugProcessImpl.findConnector(connectorName);
    }

    @NotNull
    public static Connector findConnector(String connectorName) throws ExecutionException {
        Object virtualMachineManager;
        if (connectorName.startsWith("com.jetbrains")) {
            virtualMachineManager = VirtualMachineManagerImpl.virtualMachineManager();
        } else {
            try {
                virtualMachineManager = Bootstrap.virtualMachineManager();
            }
            catch (Error e) {
                throw new ExecutionException(JavaDebuggerBundle.message((String)"debugger.jdi.bootstrap.error", (Object[])new Object[]{e.getClass().getName() + " : " + e.getLocalizedMessage()}));
            }
        }
        return (Connector)StreamEx.of(virtualMachineManager.allConnectors()).findFirst(c -> connectorName.equals(c.name())).orElseThrow(() -> new CantRunException(JavaDebuggerBundle.message((String)"error.debug.connector.not.found", (Object[])new Object[]{connectorName})));
    }

    private void checkVirtualMachineVersion(VirtualMachine vm) {
        String versionString = vm.version();
        if ("1.4.0".equals(versionString)) {
            DebuggerInvocationUtil.swingInvokeLater(this.myProject, () -> Messages.showMessageDialog((Project)this.myProject, (String)JavaDebuggerBundle.message((String)"warning.jdk140.unstable", (Object[])new Object[0]), (String)JavaDebuggerBundle.message((String)"title.jdk140.unstable", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()));
        }
        if (this.getSession().getAlternativeJre() == null) {
            Sdk runjre = this.getSession().getRunJre();
            JavaVersion version = JavaVersion.tryParse((String)versionString);
            if (version != null && (runjre == null || runjre.getSdkType() instanceof JavaSdkType) && !DebugProcessImpl.versionMatch(runjre, version)) {
                Arrays.stream(ProjectJdkTable.getInstance().getAllJdks()).filter(sdk -> DebugProcessImpl.versionMatch(sdk, version)).findFirst().ifPresent(sdk -> {
                    XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(JavaDebuggerBundle.message((String)"message.remote.jre.version.mismatch", (Object[])new Object[]{versionString, runjre != null ? runjre.getVersionString() : "unknown", sdk.getName()}), MessageType.INFO).notify(this.myProject);
                    this.getSession().setAlternativeJre((Sdk)sdk);
                });
            }
        }
    }

    private static boolean versionMatch(@Nullable Sdk sdk, @NotNull JavaVersion version) {
        JavaVersion v;
        if (sdk != null && sdk.getSdkType() instanceof JavaSdkType && (v = JavaVersion.tryParse((String)sdk.getVersionString())) != null) {
            return version.feature == v.feature && version.minor == v.minor && version.update == v.update;
        }
        return false;
    }

    public void addEvaluationListener(EvaluationListener evaluationListener) {
        this.myEvaluationDispatcher.addListener((EventListener)evaluationListener);
    }

    public void removeEvaluationListener(EvaluationListener evaluationListener) {
        this.myEvaluationDispatcher.removeListener((EventListener)evaluationListener);
    }

    public void addDebugProcessListener(DebugProcessListener listener) {
        this.myDebugProcessDispatcher.addListener((EventListener)listener);
    }

    public void removeDebugProcessListener(DebugProcessListener listener) {
        this.myDebugProcessDispatcher.removeListener((EventListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcessListener(ProcessListener processListener) {
        List<ProcessListener> list = this.myProcessListeners;
        synchronized (list) {
            if (this.getProcessHandler() != null) {
                this.getProcessHandler().addProcessListener(processListener);
            } else {
                this.myProcessListeners.add(processListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcessListener(ProcessListener processListener) {
        List<ProcessListener> list = this.myProcessListeners;
        synchronized (list) {
            if (this.getProcessHandler() != null) {
                this.getProcessHandler().removeProcessListener(processListener);
            } else {
                this.myProcessListeners.remove(processListener);
            }
        }
    }

    public RemoteConnection getConnection() {
        return this.myConnection;
    }

    public ExecutionResult getExecutionResult() {
        return this.myExecutionResult;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public boolean canRedefineClasses() {
        VirtualMachineProxyImpl vm = this.myVirtualMachineProxy;
        return vm != null && vm.canRedefineClasses();
    }

    public boolean canWatchFieldModification() {
        VirtualMachineProxyImpl vm = this.myVirtualMachineProxy;
        return vm != null && vm.canWatchFieldModification();
    }

    public boolean isInInitialState() {
        return this.myState.get() == State.INITIAL;
    }

    public boolean isAttached() {
        return this.myState.get() == State.ATTACHED;
    }

    public boolean isDetached() {
        return this.myState.get() == State.DETACHED;
    }

    public boolean isDetaching() {
        return this.myState.get() == State.DETACHING;
    }

    public RequestManagerImpl getRequestsManager() {
        return this.myRequestManager;
    }

    @NotNull
    public VirtualMachineProxyImpl getVirtualMachineProxy() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        VirtualMachineProxyImpl vm = this.myVirtualMachineProxy;
        if (vm == null) {
            if (this.isInInitialState()) {
                throw new IllegalStateException("Virtual machine is not initialized yet");
            }
            throw new VMDisconnectedException();
        }
        return vm;
    }

    public void appendPositionManager(PositionManager positionManager) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myPositionManager.appendPositionManager(positionManager);
    }

    public void setSteppingBreakpoint(@Nullable SteppingBreakpoint breakpoint) {
        this.mySteppingBreakpoint = breakpoint;
    }

    @Deprecated
    public void setRunToCursorBreakpoint(@Nullable RunToCursorBreakpoint breakpoint) {
        this.mySteppingBreakpoint = breakpoint;
    }

    public void cancelRunToCursorBreakpoint() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        SteppingBreakpoint runToCursorBreakpoint = this.mySteppingBreakpoint;
        if (runToCursorBreakpoint != null) {
            this.setSteppingBreakpoint(null);
            this.getRequestsManager().deleteRequest(runToCursorBreakpoint);
            if (runToCursorBreakpoint.isRestoreBreakpoints()) {
                DebuggerManagerEx.getInstanceEx(this.getProject()).getBreakpointManager().enableBreakpoints(this);
            }
        }
    }

    static void prepareAndSetSteppingBreakpoint(SuspendContextImpl context, @NotNull SteppingBreakpoint breakpoint, RequestHint hint, boolean resetThreadFilter) {
        DebugProcessImpl debugProcess = context.getDebugProcess();
        if (resetThreadFilter) {
            BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(debugProcess.getProject()).getBreakpointManager();
            breakpointManager.applyThreadFilter(debugProcess, null);
        }
        breakpoint.setSuspendPolicy(context.getSuspendPolicy() == 1 ? "SuspendThread" : "SuspendAll");
        breakpoint.createRequest(debugProcess);
        breakpoint.setRequestHint(hint);
        debugProcess.setSteppingBreakpoint(breakpoint);
    }

    public void resetIgnoreSteppingFilters(@Nullable Location location, @Nullable RequestHint hint) {
        if (hint != null && hint.isResetIgnoreFilters() && location != null && !DebugProcessImpl.isPositionFiltered(location)) {
            this.getSession().resetIgnoreStepFiltersFlag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeProcess(boolean closedByUser) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.myState.compareAndSet(State.INITIAL, State.DETACHING) || this.myState.compareAndSet(State.ATTACHED, State.DETACHING)) {
            try {
                this.getManagerThread().close();
            }
            finally {
                VirtualMachineProxyImpl vm = this.myVirtualMachineProxy;
                this.myVirtualMachineProxy = null;
                this.myPositionManager = CompoundPositionManager.EMPTY;
                this.myReturnValueWatcher = null;
                this.myNodeRenderersMap.clear();
                this.myRenderers.clear();
                DebuggerUtils.cleanupAfterProcessFinish((DebugProcess)this);
                this.myState.compareAndSet(State.DETACHING, State.DETACHED);
                try {
                    ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).processDetached((DebugProcess)this, closedByUser);
                }
                finally {
                    if (vm != null) {
                        try {
                            vm.dispose();
                        }
                        catch (Throwable throwable) {}
                    }
                    this.myWaitFor.up();
                }
            }
        }
    }

    private static String formatMessage(String message2) {
        int lineLength = 90;
        StringBuilder buf = new StringBuilder(message2.length());
        for (int index = 0; index < message2.length(); index += 90) {
            buf.append(message2, index, Math.min(index + 90, message2.length())).append('\n');
        }
        return buf.toString();
    }

    public static String processError(Exception e) {
        String message2;
        if (e instanceof VMStartException) {
            VMStartException e1 = (VMStartException)e;
            message2 = e1.getLocalizedMessage();
        } else if (e instanceof IllegalConnectorArgumentsException) {
            IllegalConnectorArgumentsException e1 = (IllegalConnectorArgumentsException)e;
            List<String> invalidArgumentNames = e1.argumentNames();
            message2 = DebugProcessImpl.formatMessage(JavaDebuggerBundle.message((String)"error.invalid.argument", (Object[])new Object[]{invalidArgumentNames.size()}) + ": " + e1.getLocalizedMessage()) + invalidArgumentNames;
            LOG.debug((Throwable)e1);
        } else if (e instanceof CantRunException) {
            message2 = e.getLocalizedMessage();
        } else if (e instanceof VMDisconnectedException) {
            message2 = JavaDebuggerBundle.message((String)"error.vm.disconnected", (Object[])new Object[0]);
        } else if (e instanceof IOException) {
            message2 = DebugProcessImpl.processIOException((IOException)e, null);
        } else if (e instanceof ExecutionException) {
            message2 = e.getLocalizedMessage();
        } else {
            message2 = JavaDebuggerBundle.message((String)"error.exception.while.connecting", (Object[])new Object[]{e.getClass().getName(), e.getLocalizedMessage()});
            LOG.debug((Throwable)e);
        }
        return message2;
    }

    @NotNull
    public static String processIOException(@NotNull IOException e, @Nullable String address) {
        if (e instanceof UnknownHostException) {
            return JavaDebuggerBundle.message((String)"error.unknown.host", (Object[])new Object[0]) + (address != null ? " (" + address + ")" : "") + ":\n" + e.getLocalizedMessage();
        }
        Throwable cause = e.getCause();
        if (cause instanceof InvocationTargetException && cause.getCause() != null) {
            return cause.getCause().getLocalizedMessage();
        }
        StringBuilder buf = new StringBuilder();
        if (address != null) {
            buf.append(JavaDebuggerBundle.message((String)"error.cannot.open.debugger.port", (Object[])new Object[0]));
            buf.append(" (").append(address).append("): ");
        }
        buf.append(e.getClass().getName()).append(" ");
        if (!StringUtil.isEmpty((String)e.getLocalizedMessage())) {
            buf.append('\"').append(e.getLocalizedMessage()).append('\"');
        }
        if (cause != null && !StringUtil.isEmpty((String)cause.getLocalizedMessage())) {
            buf.append(" (").append(cause.getLocalizedMessage()).append(')');
        }
        LOG.debug((Throwable)e);
        return buf.toString();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDisposable);
        this.myRequestManager.setFilterThread(null);
    }

    public DebuggerManagerThreadImpl getManagerThread() {
        return this.myDebuggerManagerThread;
    }

    private static int getInvokePolicy(SuspendContext suspendContext) {
        if (suspendContext.getSuspendPolicy() == 1 || DebugProcessImpl.isResumeOnlyCurrentThread() || ThreadBlockedMonitor.getSingleThreadedEvaluationThreshold() > 0) {
            return 1;
        }
        return 0;
    }

    public void waitFor() {
        LOG.assertTrue(!DebuggerManagerThreadImpl.isManagerThread());
        this.myWaitFor.waitFor();
    }

    public void waitFor(long timeout) {
        LOG.assertTrue(!DebuggerManagerThreadImpl.isManagerThread());
        this.myWaitFor.waitFor(timeout);
    }

    public Value invokeMethod(@NotNull EvaluationContext evaluationContext, @NotNull ObjectReference objRef, @NotNull Method method, @NotNull List<? extends Value> args) throws EvaluateException {
        return this.invokeInstanceMethod(evaluationContext, objRef, method, args, 0);
    }

    public Value invokeInstanceMethod(@NotNull EvaluationContext evaluationContext, @NotNull ObjectReference objRef, @NotNull Method method, @NotNull List<? extends Value> args, int invocationOptions) throws EvaluateException {
        return this.invokeInstanceMethod(evaluationContext, objRef, method, args, invocationOptions, false);
    }

    public Value invokeInstanceMethod(@NotNull EvaluationContext evaluationContext, final @NotNull ObjectReference objRef, @NotNull Method method, @NotNull List<? extends Value> args, final int invocationOptions, boolean internalEvaluate) throws EvaluateException {
        final ThreadReference thread = DebugProcessImpl.getEvaluationThread(evaluationContext);
        return new InvokeCommand<Value>(method, args){

            @Override
            protected Value invokeMethod(int invokePolicy, Method method, List<? extends Value> args) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invoking " + objRef.type().name() + "." + method.name());
                }
                return objRef.invokeMethod(thread, method, args, invokePolicy | invocationOptions);
            }
        }.start((EvaluationContextImpl)evaluationContext, internalEvaluate);
    }

    private static ThreadReference getEvaluationThread(EvaluationContext evaluationContext) throws EvaluateException {
        ThreadReferenceProxy evaluationThread = evaluationContext.getSuspendContext().getThread();
        if (evaluationThread == null) {
            throw EvaluateExceptionUtil.NULL_STACK_FRAME;
        }
        return evaluationThread.getThreadReference();
    }

    public Value invokeMethod(EvaluationContext evaluationContext, ClassType classType, Method method, List<? extends Value> args) throws EvaluateException {
        return this.invokeMethod(evaluationContext, classType, method, args, 0, false);
    }

    public Value invokeMethod(@NotNull EvaluationContext evaluationContext, @NotNull ClassType classType, @NotNull Method method, @NotNull List<? extends Value> args, boolean internalEvaluate) throws EvaluateException {
        return this.invokeMethod(evaluationContext, classType, method, args, 0, internalEvaluate);
    }

    public Value invokeMethod(@NotNull EvaluationContext evaluationContext, final @NotNull ClassType classType, @NotNull Method method, @NotNull List<? extends Value> args, final int extraInvocationOptions, boolean internalEvaluate) throws EvaluateException {
        final ThreadReference thread = DebugProcessImpl.getEvaluationThread(evaluationContext);
        return new InvokeCommand<Value>(method, args){

            @Override
            protected Value invokeMethod(int invokePolicy, Method method, List<? extends Value> args) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invoking " + classType.name() + "." + method.name());
                }
                return classType.invokeMethod(thread, method, args, invokePolicy | extraInvocationOptions);
            }
        }.start((EvaluationContextImpl)evaluationContext, internalEvaluate);
    }

    public Value invokeMethod(EvaluationContext evaluationContext, final InterfaceType interfaceType, Method method, List<? extends Value> args) throws EvaluateException {
        final ThreadReference thread = DebugProcessImpl.getEvaluationThread(evaluationContext);
        return new InvokeCommand<Value>(method, args){

            @Override
            protected Value invokeMethod(int invokePolicy, Method method, List<? extends Value> args) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invoking " + interfaceType.name() + "." + method.name());
                }
                try {
                    return interfaceType.invokeMethod(thread, method, args, invokePolicy);
                }
                catch (LinkageError e) {
                    throw new IllegalStateException("Interface method invocation is not supported in JVM " + SystemInfo.JAVA_VERSION + ". Use JVM 1.8.0_45 or higher to run " + ApplicationNamesInfo.getInstance().getFullProductName());
                }
            }
        }.start((EvaluationContextImpl)evaluationContext, false);
    }

    public ArrayReference newInstance(ArrayType arrayType, int dimension) throws EvaluateException {
        try {
            return arrayType.newInstance(dimension);
        }
        catch (Exception e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
    }

    public ObjectReference newInstance(@NotNull EvaluationContext evaluationContext, @NotNull ClassType classType, @NotNull Method method, @NotNull List<? extends Value> args) throws EvaluateException {
        return this.newInstance(evaluationContext, classType, method, args, 0, false);
    }

    public ObjectReference newInstance(@NotNull EvaluationContext evaluationContext, final @NotNull ClassType classType, @NotNull Method method, @NotNull List<? extends Value> args, final int invocationOptions, boolean internalEvaluate) throws EvaluateException {
        final ThreadReference thread = DebugProcessImpl.getEvaluationThread(evaluationContext);
        InvokeCommand<ObjectReference> invokeCommand = new InvokeCommand<ObjectReference>(method, args){

            @Override
            protected ObjectReference invokeMethod(int invokePolicy, Method method, List<? extends Value> args) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("New instance " + classType.name() + "." + method.name());
                }
                return classType.newInstance(thread, method, args, invokePolicy | invocationOptions);
            }
        };
        return (ObjectReference)invokeCommand.start((EvaluationContextImpl)evaluationContext, internalEvaluate);
    }

    public void clearCashes(int suspendPolicy) {
        if (!this.isAttached()) {
            return;
        }
        switch (suspendPolicy) {
            case 2: {
                this.getVirtualMachineProxy().clearCaches();
                break;
            }
            case 1: {
                this.getVirtualMachineProxy().clearCaches();
            }
        }
    }

    protected void beforeSuspend(SuspendContextImpl suspendContext) {
        this.clearCashes(suspendContext.getSuspendPolicy());
    }

    private void beforeMethodInvocation(SuspendContextImpl suspendContext, Method method, boolean internalEvaluate) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("before invocation in  thread " + suspendContext.getThread().name() + " method " + (method == null ? "null" : method.name()));
        }
        if (!internalEvaluate) {
            if (method != null) {
                this.showStatusText(JavaDebuggerBundle.message((String)"progress.evaluating", (Object[])new Object[]{DebuggerUtilsEx.methodName(method)}));
            } else {
                this.showStatusText(JavaDebuggerBundle.message((String)"title.evaluating", (Object[])new Object[0]));
            }
        }
    }

    private void afterMethodInvocation(SuspendContextImpl suspendContext, boolean internalEvaluate) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("after invocation in  thread " + suspendContext.getThread().name());
        }
        if (!internalEvaluate) {
            this.showStatusText("");
        }
    }

    public ReferenceType findClass(@Nullable EvaluationContext evaluationContext, String className2, ClassLoaderReference classLoader) throws EvaluateException {
        try {
            EvaluationContextImpl evalContext;
            DebuggerManagerThreadImpl.assertIsManagerThread();
            ReferenceType result = null;
            List types = ContainerUtil.filter(this.getVirtualMachineProxy().classesByName(className2), ReferenceType::isPrepared);
            result = (ReferenceType)ContainerUtil.find((Iterable)types, refType -> Objects.equals(classLoader, refType.classLoader()));
            if (result == null && classLoader != null) {
                result = (ReferenceType)ContainerUtil.find((Iterable)types, refType -> DebugProcessImpl.isVisibleFromClassLoader(classLoader, refType));
            }
            if (result == null && evaluationContext != null && (evalContext = (EvaluationContextImpl)evaluationContext).isAutoLoadClasses()) {
                return this.loadClass(evalContext, className2, classLoader);
            }
            return result;
        }
        catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InvocationException e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
    }

    private static boolean isVisibleFromClassLoader(@NotNull ClassLoaderReference fromLoader, ReferenceType refType) {
        if (fromLoader instanceof ClassLoaderReferenceImpl) {
            return ((ClassLoaderReferenceImpl)fromLoader).isVisible(refType);
        }
        return fromLoader.visibleClasses().contains(refType);
    }

    private static String reformatArrayName(String className2) {
        if (className2.indexOf(91) == -1) {
            return className2;
        }
        int dims = 0;
        while (className2.endsWith("[]")) {
            className2 = className2.substring(0, className2.length() - 2);
            ++dims;
        }
        StringBuilder buffer = new StringBuilder();
        StringUtil.repeatSymbol((Appendable)buffer, (char)'[', (int)dims);
        String primitiveSignature = JVMNameUtil.getPrimitiveSignature(className2);
        if (primitiveSignature != null) {
            buffer.append(primitiveSignature);
        } else {
            buffer.append('L');
            buffer.append(className2);
            buffer.append(';');
        }
        return buffer.toString();
    }

    public ReferenceType loadClass(EvaluationContextImpl evaluationContext, String qName, ClassLoaderReference classLoader) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        qName = DebugProcessImpl.reformatArrayName(qName);
        ReferenceType refType = null;
        VirtualMachineProxyImpl virtualMachine = this.getVirtualMachineProxy();
        ClassType classClassType = (ClassType)ContainerUtil.getFirstItem(virtualMachine.classesByName("java.lang.Class"));
        if (classClassType != null) {
            Method forNameMethod;
            ArrayList<Value> args = new ArrayList<Value>();
            args.add(virtualMachine.mirrorOf(qName));
            if (classLoader != null) {
                forNameMethod = DebuggerUtils.findMethod((ReferenceType)classClassType, (String)"forName", (String)"(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;");
                args.add(virtualMachine.mirrorOf(true));
                args.add(classLoader);
            } else {
                forNameMethod = DebuggerUtils.findMethod((ReferenceType)classClassType, (String)"forName", (String)"(Ljava/lang/String;)Ljava/lang/Class;");
            }
            Value classReference2 = this.invokeMethod(evaluationContext, classClassType, forNameMethod, args, 1024, true);
            if (classReference2 instanceof ClassObjectReference) {
                refType = ((ClassObjectReference)classReference2).reflectedType();
                if (classLoader instanceof ClassLoaderReferenceImpl) {
                    ((ClassLoaderReferenceImpl)classLoader).addVisible(refType);
                }
            }
        }
        return refType;
    }

    public void logThreads() {
        if (LOG.isDebugEnabled()) {
            try {
                Collection<ThreadReferenceProxyImpl> allThreads = this.getVirtualMachineProxy().allThreads();
                for (ThreadReferenceProxyImpl threadReferenceProxy : allThreads) {
                    LOG.debug("Thread name=" + threadReferenceProxy.name() + " suspendCount()=" + threadReferenceProxy.getSuspendCount());
                }
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    public void onHotSwapFinished() {
        this.getPositionManager().clearCache();
        StackCapturingLineBreakpoint.clearCaches(this);
    }

    @NotNull
    public SuspendManager getSuspendManager() {
        return this.mySuspendManager;
    }

    @NotNull
    public CompoundPositionManager getPositionManager() {
        return this.myPositionManager;
    }

    public void stop(boolean forceTerminate) {
        this.myIsStopped.set(true);
        this.stopConnecting();
        this.getManagerThread().terminateAndInvoke(this.createStopCommand(forceTerminate), ApplicationManager.getApplication().isUnitTestMode() ? 0 : 3000);
    }

    @NotNull
    public StopCommand createStopCommand(boolean forceTerminate) {
        return new StopCommand(forceTerminate);
    }

    @NotNull
    public GlobalSearchScope getSearchScope() {
        LOG.assertTrue(this.mySession != null, (Object)"Accessing debug session before its initialization");
        return this.mySession.getSearchScope();
    }

    public void reattach(final DebugEnvironment environment) {
        if (!this.myIsStopped.get()) {
            this.getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() {
                    DebugProcessImpl.this.closeProcess(false);
                    DebugProcessImpl.this.getManagerThread().processRemaining();
                    this.doReattach();
                }

                @Override
                protected void commandCancelled() {
                    this.doReattach();
                }

                private void doReattach() {
                    DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.myProject, () -> {
                        ((XDebugSessionImpl)DebugProcessImpl.this.getXdebugProcess().getSession()).reset();
                        DebugProcessImpl.this.myState.set(State.INITIAL);
                        DebugProcessImpl.this.myConnection = environment.getRemoteConnection();
                        DebugProcessImpl.this.getManagerThread().restartIfNeeded();
                        DebugProcessImpl.this.createVirtualMachine(environment);
                    });
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ExecutionResult attachVirtualMachine(DebugEnvironment environment, DebuggerSession session) throws ExecutionException {
        ExecutionResult executionResult;
        this.mySession = session;
        this.myWaitFor.down();
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.assertTrue(this.isInInitialState());
        this.myConnection = environment.getRemoteConnection();
        boolean serverMode = this.myConnection.isServerMode();
        if (serverMode) {
            this.createVirtualMachine(environment);
        }
        try {
            List<ProcessListener> list = this.myProcessListeners;
            synchronized (list) {
                this.myExecutionResult = executionResult = environment.createExecutionResult();
                if (executionResult == null) {
                    this.fail();
                    return null;
                }
                for (ProcessListener processListener : this.myProcessListeners) {
                    executionResult.getProcessHandler().addProcessListener(processListener);
                }
                this.myProcessListeners.clear();
                if (this.myTextBeforeStart.length() > 0) {
                    this.printToConsoleImpl(this.myTextBeforeStart.toString());
                    this.myTextBeforeStart.setLength(0);
                }
            }
        }
        catch (ExecutionException e) {
            this.fail();
            throw e;
        }
        if (!serverMode) {
            this.createVirtualMachine(environment);
        }
        return executionResult;
    }

    private void fail() {
        if (this.myIsFailed.compareAndSet(false, true)) {
            this.stop(false);
        }
    }

    private void createVirtualMachine(DebugEnvironment environment) {
        final String sessionName = environment.getSessionName();
        final long pollTimeout = environment.getPollTimeout();
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final AtomicBoolean connectorIsReady = new AtomicBoolean(false);
        this.myDebugProcessDispatcher.addListener((EventListener)new DebugProcessListener(){

            public void connectorIsReady() {
                connectorIsReady.set(true);
                semaphore.up();
                DebugProcessImpl.this.myDebugProcessDispatcher.removeListener((EventListener)((Object)this));
            }
        });
        DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().reloadBreakpoints();
        this.getManagerThread().schedule(new DebuggerCommandImpl(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void action() {
                VirtualMachine vm = null;
                try {
                    long time = System.currentTimeMillis();
                    while (true) {
                        try {
                            vm = DebugProcessImpl.this.createVirtualMachineInt();
                        }
                        catch (ExecutionException e) {
                            if (pollTimeout > 0L && !DebugProcessImpl.this.myConnection.isServerMode() && e.getCause() instanceof IOException) {
                                10 var5_5 = this;
                                synchronized (var5_5) {
                                    try {
                                        this.wait(500L);
                                    }
                                    catch (InterruptedException ignored) {
                                        break;
                                    }
                                }
                            }
                            ProcessHandler processHandler = DebugProcessImpl.this.getProcessHandler();
                            boolean terminated = processHandler != null && (processHandler.isProcessTerminating() || processHandler.isProcessTerminated());
                            DebugProcessImpl.this.fail();
                            DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.myProject, () -> {
                                if (DebugProcessImpl.this.myExecutionResult != null && !terminated || !connectorIsReady.get()) {
                                    ExecutionUtil.handleExecutionError((Project)DebugProcessImpl.this.myProject, (String)"Debug", (String)sessionName, (Throwable)e);
                                }
                            });
                            break;
                            if (System.currentTimeMillis() - time < pollTimeout) continue;
                        }
                        break;
                    }
                }
                finally {
                    semaphore.up();
                }
                if (vm != null) {
                    final VirtualMachine vm1 = vm;
                    DebugProcessImpl.this.afterProcessStarted(() -> DebugProcessImpl.this.getManagerThread().schedule(new DebuggerCommandImpl(){

                        @Override
                        protected void action() {
                            try {
                                DebugProcessImpl.this.commitVM(vm1);
                            }
                            catch (VMDisconnectedException e) {
                                DebugProcessImpl.this.fail();
                            }
                        }
                    }));
                } else {
                    DebugProcessImpl.this.fail();
                }
            }

            @Override
            protected void commandCancelled() {
                try {
                    super.commandCancelled();
                }
                finally {
                    semaphore.up();
                }
            }
        });
        semaphore.waitFor();
    }

    private void afterProcessStarted(final Runnable run2) {
        class MyProcessAdapter
        extends ProcessAdapter {
            private boolean alreadyRun = false;

            MyProcessAdapter() {
            }

            public synchronized void run() {
                if (!this.alreadyRun) {
                    this.alreadyRun = true;
                    run2.run();
                }
                DebugProcessImpl.this.removeProcessListener((ProcessListener)this);
            }

            public void startNotified(@NotNull ProcessEvent event) {
                this.run();
            }
        }
        MyProcessAdapter processListener = new MyProcessAdapter();
        this.addProcessListener((ProcessListener)processListener);
        if (this.myExecutionResult != null && this.myExecutionResult.getProcessHandler().isStartNotified()) {
            processListener.run();
        }
    }

    public boolean isPausePressed() {
        VirtualMachineProxyImpl vm = this.myVirtualMachineProxy;
        return vm != null && vm.isPausePressed();
    }

    @NotNull
    public DebuggerCommandImpl createPauseCommand() {
        return new PauseCommand();
    }

    @NotNull
    public ResumeCommand createResumeCommand(SuspendContextImpl suspendContext) {
        return this.createResumeCommand(suspendContext, PrioritizedTask.Priority.HIGH);
    }

    @NotNull
    public ResumeCommand createResumeCommand(SuspendContextImpl suspendContext, final PrioritizedTask.Priority priority) {
        final BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(this.getProject()).getBreakpointManager();
        return new ResumeCommand(suspendContext){

            @Override
            public void contextAction() {
                breakpointManager.applyThreadFilter(DebugProcessImpl.this, null);
                if (DebugProcessImpl.this.myReturnValueWatcher != null) {
                    DebugProcessImpl.this.myReturnValueWatcher.clear();
                }
                super.contextAction();
            }

            @Override
            public PrioritizedTask.Priority getPriority() {
                return priority;
            }
        };
    }

    @NotNull
    public ResumeCommand createStepOverCommand(SuspendContextImpl suspendContext, boolean ignoreBreakpoints) {
        return this.createStepOverCommand(suspendContext, ignoreBreakpoints, -2);
    }

    @NotNull
    public ResumeCommand createStepOverCommand(SuspendContextImpl suspendContext, boolean ignoreBreakpoints, int stepSize) {
        return this.createStepOverCommand(suspendContext, ignoreBreakpoints, null, -2);
    }

    @NotNull
    public ResumeCommand createStepOverCommand(SuspendContextImpl suspendContext, boolean ignoreBreakpoints, @Nullable MethodFilter methodFilter, int stepSize) {
        return new StepOverCommand(suspendContext, ignoreBreakpoints, methodFilter, stepSize);
    }

    @NotNull
    public ResumeCommand createStepOutCommand(SuspendContextImpl suspendContext) {
        return this.createStepOutCommand(suspendContext, -2);
    }

    @NotNull
    public ResumeCommand createStepOutCommand(SuspendContextImpl suspendContext, int stepSize) {
        return new StepOutCommand(suspendContext, stepSize);
    }

    @NotNull
    public ResumeCommand createStepIntoCommand(SuspendContextImpl suspendContext, boolean ignoreFilters, MethodFilter smartStepFilter) {
        return this.createStepIntoCommand(suspendContext, ignoreFilters, smartStepFilter, -2);
    }

    @NotNull
    public ResumeCommand createStepIntoCommand(SuspendContextImpl suspendContext, boolean ignoreFilters, MethodFilter smartStepFilter, int stepSize) {
        return new StepIntoCommand(suspendContext, ignoreFilters, smartStepFilter, stepSize);
    }

    @NotNull
    public ResumeCommand createRunToCursorCommand(SuspendContextImpl suspendContext, @NotNull XSourcePosition position, boolean ignoreBreakpoints) throws EvaluateException {
        RunToCursorCommand runToCursorCommand = new RunToCursorCommand(suspendContext, position, ignoreBreakpoints);
        if (runToCursorCommand.myRunToCursorBreakpoint == null) {
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(position.getFile());
            throw new EvaluateException(JavaDebuggerBundle.message((String)"error.running.to.cursor.no.executable.code", (Object[])new Object[]{psiFile != null ? psiFile.getName() : "<No File>", position.getLine()}), null);
        }
        return runToCursorCommand;
    }

    @NotNull
    public DebuggerCommandImpl createFreezeThreadCommand(ThreadReferenceProxyImpl thread) {
        return new FreezeThreadCommand(thread);
    }

    @NotNull
    public SuspendContextCommandImpl createResumeThreadCommand(SuspendContextImpl suspendContext, @NotNull ThreadReferenceProxyImpl thread) {
        return new ResumeThreadCommand(suspendContext, thread);
    }

    @NotNull
    public SuspendContextCommandImpl createPopFrameCommand(DebuggerContextImpl context, StackFrameProxyImpl stackFrame) {
        return new PopFrameCommand(context, stackFrame);
    }

    @NotNull
    public DebuggerContextImpl getDebuggerContext() {
        return this.mySession.getContextManager().getContext();
    }

    public void setXDebugProcess(JavaDebugProcess XDebugProcess2) {
        this.myXDebugProcess = XDebugProcess2;
    }

    @Nullable
    public JavaDebugProcess getXdebugProcess() {
        return this.myXDebugProcess;
    }

    public boolean areBreakpointsMuted() {
        XDebugSession session = this.mySession.getXDebugSession();
        return session != null && session.areBreakpointsMuted();
    }

    public DebuggerSession getSession() {
        return this.mySession;
    }

    static boolean isResumeOnlyCurrentThread() {
        return DebuggerSettings.getInstance().RESUME_ONLY_CURRENT_THREAD;
    }

    public boolean isEvaluationPossible() {
        return this.getSuspendManager().getPausedContext() != null;
    }

    public boolean isEvaluationPossible(SuspendContextImpl suspendContext) {
        return this.mySuspendManager.hasPausedContext(suspendContext);
    }

    public void startWatchingMethodReturn(ThreadReferenceProxyImpl thread) {
        if (this.myReturnValueWatcher != null) {
            this.myReturnValueWatcher.enable(thread.getThreadReference());
        }
    }

    void stopWatchingMethodReturn() {
        if (this.myReturnValueWatcher != null) {
            this.myReturnValueWatcher.disable();
        }
    }

    static {
        String traceStr = System.getProperty("idea.debugger.trace");
        int mask = 0;
        if (!StringUtil.isEmpty((String)traceStr)) {
            StringTokenizer tokenizer = new StringTokenizer(traceStr);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if ("SENDS".compareToIgnoreCase(token) == 0) {
                    mask |= 1;
                    continue;
                }
                if ("RAW_SENDS".compareToIgnoreCase(token) == 0) {
                    mask |= 0x1000000;
                    continue;
                }
                if ("RECEIVES".compareToIgnoreCase(token) == 0) {
                    mask |= 2;
                    continue;
                }
                if ("RAW_RECEIVES".compareToIgnoreCase(token) == 0) {
                    mask |= 0x2000000;
                    continue;
                }
                if ("EVENTS".compareToIgnoreCase(token) == 0) {
                    mask |= 4;
                    continue;
                }
                if ("REFTYPES".compareToIgnoreCase(token) == 0) {
                    mask |= 8;
                    continue;
                }
                if ("OBJREFS".compareToIgnoreCase(token) == 0) {
                    mask |= 0x10;
                    continue;
                }
                if ("ALL".compareToIgnoreCase(token) != 0) continue;
                mask |= 0xFFFFFF;
            }
        }
        ourTraceMask = mask;
    }

    private class PopFrameCommand
    extends DebuggerContextCommandImpl {
        private final StackFrameProxyImpl myStackFrame;

        PopFrameCommand(DebuggerContextImpl context, StackFrameProxyImpl frameProxy) {
            super(context, frameProxy.threadProxy());
            this.myStackFrame = frameProxy;
        }

        @Override
        public void threadAction(@NotNull SuspendContextImpl suspendContext) {
            ThreadReferenceProxyImpl thread = this.myStackFrame.threadProxy();
            try {
                if (!DebugProcessImpl.this.getSuspendManager().isSuspended(thread)) {
                    this.notifyCancelled();
                    return;
                }
            }
            catch (ObjectCollectedException ignored) {
                this.notifyCancelled();
                return;
            }
            if (!suspendContext.suspends(thread)) {
                suspendContext.postponeCommand(this);
                return;
            }
            if (this.myStackFrame.isBottom()) {
                DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.myProject, () -> Messages.showMessageDialog((Project)DebugProcessImpl.this.myProject, (String)JavaDebuggerBundle.message((String)"error.pop.bottom.stackframe", (Object[])new Object[0]), (String)ActionsBundle.actionText((String)"Debugger.PopFrame"), (Icon)Messages.getErrorIcon()));
                return;
            }
            try {
                thread.popFrames(this.myStackFrame);
                DebugProcessImpl.this.getSuspendManager().popFrame(suspendContext);
            }
            catch (EvaluateException e) {
                DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.myProject, () -> Messages.showMessageDialog((Project)DebugProcessImpl.this.myProject, (String)JavaDebuggerBundle.message((String)"error.pop.stackframe", (Object[])new Object[]{e.getLocalizedMessage()}), (String)ActionsBundle.actionText((String)"Debugger.PopFrame"), (Icon)Messages.getErrorIcon()));
                LOG.info((Throwable)e);
            }
        }
    }

    private class FreezeThreadCommand
    extends DebuggerCommandImpl {
        private final ThreadReferenceProxyImpl myThread;

        FreezeThreadCommand(ThreadReferenceProxyImpl thread) {
            this.myThread = thread;
        }

        @Override
        protected void action() {
            SuspendManager suspendManager = DebugProcessImpl.this.getSuspendManager();
            if (!suspendManager.isFrozen(this.myThread)) {
                suspendManager.freezeThread(this.myThread);
                SuspendContextImpl suspendContext = DebugProcessImpl.this.mySuspendManager.pushSuspendContext(1, 0);
                suspendContext.setThread(this.myThread.getThreadReference());
                ((DebugProcessListener)DebugProcessImpl.this.myDebugProcessDispatcher.getMulticaster()).paused((SuspendContext)suspendContext);
            }
        }
    }

    private class ResumeThreadCommand
    extends SuspendContextCommandImpl {
        private final ThreadReferenceProxyImpl myThread;

        ResumeThreadCommand(@NotNull SuspendContextImpl suspendContext, ThreadReferenceProxyImpl thread) {
            super(suspendContext);
            this.myThread = thread;
        }

        @Override
        public void contextAction() {
            Set<SuspendContextImpl> suspendingContexts = SuspendManagerUtil.getSuspendingContexts(DebugProcessImpl.this.getSuspendManager(), this.myThread);
            for (SuspendContextImpl suspendContext : suspendingContexts) {
                if (suspendContext.getSuspendPolicy() == 1 && suspendContext.getThread() == this.myThread) {
                    DebugProcessImpl.this.getSession().getXDebugSession().sessionResumed();
                    DebugProcessImpl.this.getManagerThread().invoke(DebugProcessImpl.this.createResumeCommand(suspendContext));
                    continue;
                }
                DebugProcessImpl.this.getSuspendManager().resumeThread(suspendContext, this.myThread);
            }
        }
    }

    private class PauseCommand
    extends DebuggerCommandImpl {
        PauseCommand() {
        }

        @Override
        public void action() {
            if (!DebugProcessImpl.this.isAttached() || DebugProcessImpl.this.getVirtualMachineProxy().isPausePressed()) {
                return;
            }
            DebugProcessImpl.this.logThreads();
            DebugProcessImpl.this.getVirtualMachineProxy().suspend();
            DebugProcessImpl.this.logThreads();
            SuspendContextImpl suspendContext = DebugProcessImpl.this.mySuspendManager.pushSuspendContext(2, 0);
            ((DebugProcessListener)DebugProcessImpl.this.myDebugProcessDispatcher.getMulticaster()).paused((SuspendContext)suspendContext);
        }
    }

    public abstract class ResumeCommand
    extends SuspendContextCommandImpl {
        @Nullable
        protected final ThreadReferenceProxyImpl myContextThread;

        public ResumeCommand(SuspendContextImpl suspendContext) {
            super(suspendContext);
            ThreadReferenceProxyImpl contextThread = DebugProcessImpl.this.getDebuggerContext().getThreadProxy();
            this.myContextThread = contextThread != null ? contextThread : (suspendContext != null ? suspendContext.getThread() : null);
        }

        @Override
        public PrioritizedTask.Priority getPriority() {
            return PrioritizedTask.Priority.HIGH;
        }

        @Override
        public void contextAction() {
            DebugProcessImpl.this.showStatusText(JavaDebuggerBundle.message((String)"status.process.resumed", (Object[])new Object[0]));
            this.resumeAction();
            ((DebugProcessListener)DebugProcessImpl.this.myDebugProcessDispatcher.getMulticaster()).resumed((SuspendContext)this.getSuspendContext());
        }

        protected void resumeAction() {
            DebugProcessImpl.this.getSuspendManager().resume(this.getSuspendContext());
        }

        @Nullable
        public ThreadReferenceProxyImpl getContextThread() {
            return this.myContextThread;
        }

        protected void applyThreadFilter(ThreadReferenceProxy thread) {
            if (this.getSuspendContext().getSuspendPolicy() == 2) {
                BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.getProject()).getBreakpointManager();
                breakpointManager.applyThreadFilter(DebugProcessImpl.this, thread.getThreadReference());
            }
        }
    }

    private abstract class StepCommand
    extends ResumeCommand {
        @Nullable
        protected final MethodFilter myMethodFilter;

        StepCommand(@Nullable SuspendContextImpl suspendContext, MethodFilter filter) {
            super(suspendContext);
            this.myMethodFilter = filter;
        }

        @Override
        protected void resumeAction() {
            SuspendContextImpl context = this.getSuspendContext();
            if (context != null && (context.getSuspendPolicy() == 1 || DebugProcessImpl.isResumeOnlyCurrentThread())) {
                DebugProcessImpl.this.myThreadBlockedMonitor.startWatching(this.myContextThread);
            }
            if (context != null && DebugProcessImpl.isResumeOnlyCurrentThread() && context.getSuspendPolicy() == 2 && this.myContextThread != null) {
                DebugProcessImpl.this.getSuspendManager().resumeThread(context, this.myContextThread);
            } else {
                super.resumeAction();
            }
        }
    }

    private class RunToCursorCommand
    extends StepCommand {
        private final RunToCursorBreakpoint myRunToCursorBreakpoint;
        private final boolean myIgnoreBreakpoints;

        private RunToCursorCommand(@NotNull SuspendContextImpl suspendContext, XSourcePosition position, boolean ignoreBreakpoints) {
            super(suspendContext, null);
            this.myIgnoreBreakpoints = ignoreBreakpoints;
            this.myRunToCursorBreakpoint = DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.myProject).getBreakpointManager().addRunToCursorBreakpoint(position, ignoreBreakpoints);
        }

        @Override
        public void contextAction() {
            DebugProcessImpl.this.showStatusText(JavaDebuggerBundle.message((String)"status.run.to.cursor", (Object[])new Object[0]));
            DebugProcessImpl.this.cancelRunToCursorBreakpoint();
            if (this.myRunToCursorBreakpoint == null) {
                return;
            }
            if (this.myIgnoreBreakpoints) {
                DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.myProject).getBreakpointManager().disableBreakpoints(DebugProcessImpl.this);
            }
            this.applyThreadFilter(this.getContextThread());
            SuspendContextImpl context = this.getSuspendContext();
            DebugProcessImpl.prepareAndSetSteppingBreakpoint(context, this.myRunToCursorBreakpoint, null, false);
            DebugProcessImpl debugProcess = context.getDebugProcess();
            if (debugProcess.getRequestsManager().getWarning(this.myRunToCursorBreakpoint) == null) {
                super.contextAction();
            } else {
                DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.myProject, () -> {
                    Messages.showErrorDialog((String)JavaDebuggerBundle.message((String)"error.running.to.cursor.no.executable.code", (Object[])new Object[]{this.myRunToCursorBreakpoint.getSourcePosition().getFile().getName(), this.myRunToCursorBreakpoint.getLineIndex() + 1}), (String)UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"RunToCursor")));
                    DebuggerSession session = debugProcess.getSession();
                    session.getContextManager().setState(DebuggerContextUtil.createDebuggerContext(session, context), DebuggerSession.State.PAUSED, DebuggerSession.Event.CONTEXT, null);
                });
            }
        }
    }

    public class StepOverCommand
    extends StepCommand {
        private final boolean myIsIgnoreBreakpoints;
        private final int myStepSize;

        public StepOverCommand(SuspendContextImpl suspendContext, @Nullable boolean ignoreBreakpoints, MethodFilter methodFilter, int stepSize) {
            super(suspendContext, methodFilter);
            this.myIsIgnoreBreakpoints = ignoreBreakpoints;
            this.myStepSize = stepSize;
        }

        public StepOverCommand(SuspendContextImpl suspendContext, boolean ignoreBreakpoints, int stepSize) {
            this(suspendContext, ignoreBreakpoints, null, stepSize);
        }

        protected int getStepDepth() {
            return 2;
        }

        @NotNull
        protected String getStatusText() {
            return JavaDebuggerBundle.message((String)"status.step.over", (Object[])new Object[0]);
        }

        @NotNull
        protected RequestHint getHint(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread) {
            RequestHint hint = new RequestHint(stepThread, suspendContext, -2, 2, this.myMethodFilter);
            hint.setRestoreBreakpoints(this.myIsIgnoreBreakpoints);
            hint.setIgnoreFilters(this.myIsIgnoreBreakpoints || DebugProcessImpl.this.mySession.shouldIgnoreSteppingFilters());
            return hint;
        }

        @Override
        public void contextAction() {
            DebugProcessImpl.this.showStatusText(this.getStatusText());
            SuspendContextImpl suspendContext = this.getSuspendContext();
            ThreadReferenceProxyImpl stepThread = this.getContextThread();
            RequestHint hint = this.getHint(suspendContext, stepThread);
            this.applyThreadFilter(stepThread);
            DebugProcessImpl.this.startWatchingMethodReturn(stepThread);
            DebugProcessImpl.this.doStep(suspendContext, stepThread, this.myStepSize, this.getStepDepth(), hint);
            if (this.myIsIgnoreBreakpoints) {
                DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.myProject).getBreakpointManager().disableBreakpoints(DebugProcessImpl.this);
            }
            super.contextAction();
        }
    }

    private class StepIntoCommand
    extends StepCommand {
        private final boolean myForcedIgnoreFilters;
        @Nullable
        private final StepIntoBreakpoint myBreakpoint;
        private final int myStepSize;

        StepIntoCommand(SuspendContextImpl suspendContext, @Nullable boolean ignoreFilters, MethodFilter methodFilter, int stepSize) {
            super(suspendContext, methodFilter);
            this.myForcedIgnoreFilters = ignoreFilters || methodFilter != null;
            this.myBreakpoint = methodFilter instanceof BreakpointStepMethodFilter ? DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.myProject).getBreakpointManager().addStepIntoBreakpoint((BreakpointStepMethodFilter)methodFilter) : null;
            this.myStepSize = stepSize;
        }

        @Override
        public void contextAction() {
            DebugProcessImpl.this.showStatusText(JavaDebuggerBundle.message((String)"status.step.into", (Object[])new Object[0]));
            SuspendContextImpl suspendContext = this.getSuspendContext();
            ThreadReferenceProxyImpl stepThread = this.getContextThread();
            RequestHint hint = new RequestHint(stepThread, suspendContext, -2, 1, this.myMethodFilter);
            hint.setResetIgnoreFilters(this.myMethodFilter != null && !DebugProcessImpl.this.mySession.shouldIgnoreSteppingFilters());
            if (this.myForcedIgnoreFilters) {
                try {
                    DebugProcessImpl.this.mySession.setIgnoreStepFiltersFlag(stepThread.frameCount());
                }
                catch (EvaluateException e) {
                    LOG.info((Throwable)e);
                }
            }
            hint.setIgnoreFilters(this.myForcedIgnoreFilters || DebugProcessImpl.this.mySession.shouldIgnoreSteppingFilters());
            this.applyThreadFilter(stepThread);
            if (this.myBreakpoint != null) {
                DebugProcessImpl.prepareAndSetSteppingBreakpoint(suspendContext, this.myBreakpoint, hint, false);
            }
            DebugProcessImpl.this.doStep(suspendContext, stepThread, this.myStepSize, 1, hint);
            super.contextAction();
        }
    }

    private class StepOutCommand
    extends StepCommand {
        private final int myStepSize;

        StepOutCommand(SuspendContextImpl suspendContext, int stepSize) {
            super(suspendContext, null);
            this.myStepSize = stepSize;
        }

        @Override
        public void contextAction() {
            DebugProcessImpl.this.showStatusText(JavaDebuggerBundle.message((String)"status.step.out", (Object[])new Object[0]));
            SuspendContextImpl suspendContext = this.getSuspendContext();
            ThreadReferenceProxyImpl thread = this.getContextThread();
            RequestHint hint = new RequestHint(thread, suspendContext, 3);
            hint.setIgnoreFilters(DebugProcessImpl.this.mySession.shouldIgnoreSteppingFilters());
            this.applyThreadFilter(thread);
            DebugProcessImpl.this.startWatchingMethodReturn(thread);
            DebugProcessImpl.this.doStep(suspendContext, thread, this.myStepSize, 3, hint);
            super.contextAction();
        }
    }

    protected class StopCommand
    extends DebuggerCommandImpl {
        private final boolean myIsTerminateTargetVM;

        public StopCommand(boolean isTerminateTargetVM) {
            this.myIsTerminateTargetVM = isTerminateTargetVM;
        }

        @Override
        public PrioritizedTask.Priority getPriority() {
            return PrioritizedTask.Priority.HIGH;
        }

        @Override
        protected void action() {
            if (DebugProcessImpl.this.isAttached()) {
                VirtualMachineProxyImpl virtualMachineProxy = DebugProcessImpl.this.getVirtualMachineProxy();
                if (!virtualMachineProxy.canBeModified()) {
                    DebugProcessImpl.this.closeProcess(false);
                    return;
                }
                if (this.myIsTerminateTargetVM) {
                    virtualMachineProxy.exit(-1);
                } else {
                    try {
                        virtualMachineProxy.resume();
                    }
                    finally {
                        virtualMachineProxy.dispose();
                    }
                }
            } else {
                try {
                    DebugProcessImpl.this.stopConnecting();
                }
                finally {
                    DebugProcessImpl.this.closeProcess(true);
                }
            }
        }
    }

    private abstract class InvokeCommand<E extends Value> {
        private final Method myMethod;
        private final List<Value> myArgs;

        protected InvokeCommand(@NotNull Method method, List<? extends Value> args) {
            this.myMethod = method;
            this.myArgs = new ArrayList<Value>(args);
        }

        public String toString() {
            return "INVOKE: " + super.toString();
        }

        protected abstract E invokeMethod(int var1, Method var2, List<? extends Value> var3) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException;

        E start(EvaluationContextImpl evaluationContext, boolean internalEvaluate) throws EvaluateException {
            while (true) {
                try {
                    return this.startInternal(evaluationContext, internalEvaluate);
                }
                catch (ClassNotLoadedException e) {
                    ReferenceType loadedClass = null;
                    try {
                        if (!evaluationContext.isAutoLoadClasses()) continue;
                        loadedClass = DebugProcessImpl.this.loadClass(evaluationContext, e.className(), evaluationContext.getClassLoader());
                        continue;
                    }
                    catch (Exception ignored) {
                        loadedClass = null;
                    }
                    if (loadedClass != null) continue;
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
                }
                break;
            }
        }

        E startInternal(EvaluationContextImpl evaluationContext, boolean internalEvaluate) throws EvaluateException, ClassNotLoadedException {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            SuspendContextImpl suspendContext = evaluationContext.getSuspendContext();
            SuspendManagerUtil.assertSuspendContext(suspendContext);
            ThreadReferenceProxyImpl invokeThread = suspendContext.getThread();
            if (SuspendManagerUtil.isEvaluating(DebugProcessImpl.this.getSuspendManager(), invokeThread)) {
                throw EvaluateExceptionUtil.NESTED_EVALUATION_ERROR;
            }
            if (!suspendContext.suspends(invokeThread)) {
                throw EvaluateExceptionUtil.THREAD_WAS_RESUMED;
            }
            Set<SuspendContextImpl> suspendingContexts = SuspendManagerUtil.getSuspendingContexts(DebugProcessImpl.this.getSuspendManager(), invokeThread);
            ThreadReference invokeThreadRef = invokeThread.getThreadReference();
            ((EvaluationListener)DebugProcessImpl.this.myEvaluationDispatcher.getMulticaster()).evaluationStarted(suspendContext);
            DebugProcessImpl.this.beforeMethodInvocation(suspendContext, this.myMethod, internalEvaluate);
            Object resumeData = null;
            try {
                for (SuspendContextImpl suspendingContext : suspendingContexts) {
                    ThreadReferenceProxyImpl suspendContextThread = suspendingContext.getThread();
                    if (suspendContextThread == invokeThread) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Resuming " + invokeThread + " that is paused by " + suspendContextThread);
                    }
                    LOG.assertTrue(suspendContextThread == null || !invokeThreadRef.equals(suspendContextThread.getThreadReference()));
                    DebugProcessImpl.this.getSuspendManager().resumeThread(suspendingContext, invokeThread);
                }
                resumeData = SuspendManagerUtil.prepareForResume(suspendContext);
                suspendContext.setIsEvaluating(evaluationContext);
                DebugProcessImpl.this.getVirtualMachineProxy().clearCaches();
                Iterator<SuspendContextImpl> iterator = this.invokeMethodAndFork(suspendContext);
                return (E)iterator;
            }
            catch (IncompatibleThreadStateException | InternalException | InvalidTypeException | InvocationException | ObjectCollectedException | UnsupportedOperationException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            finally {
                suspendContext.setIsEvaluating(null);
                if (resumeData != null) {
                    SuspendManagerUtil.restoreAfterResume(suspendContext, resumeData);
                }
                for (SuspendContextImpl suspendingContext : DebugProcessImpl.this.mySuspendManager.getEventContexts()) {
                    if (!suspendingContexts.contains((Object)suspendingContext) || suspendingContext.isEvaluating() || suspendingContext.suspends(invokeThread)) continue;
                    DebugProcessImpl.this.mySuspendManager.suspendThread(suspendingContext, invokeThread);
                }
                LOG.debug("getVirtualMachine().clearCaches()");
                DebugProcessImpl.this.getVirtualMachineProxy().clearCaches();
                DebugProcessImpl.this.afterMethodInvocation(suspendContext, internalEvaluate);
                ((EvaluationListener)DebugProcessImpl.this.myEvaluationDispatcher.getMulticaster()).evaluationFinished(suspendContext);
            }
        }

        private E invokeMethodAndFork(SuspendContextImpl context) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
            Ref exception = Ref.create();
            Ref result = Ref.create();
            DebugProcessImpl.this.getManagerThread().startLongProcessAndFork(() -> {
                ThreadReferenceProxyImpl thread = context.getThread();
                ThreadBlockedMonitor.InvocationWatcher invocationWatcher = null;
                try {
                    try {
                        int lastIndex;
                        if (LOG.isDebugEnabled()) {
                            VirtualMachineProxyImpl virtualMachineProxy = DebugProcessImpl.this.getVirtualMachineProxy();
                            virtualMachineProxy.logThreads();
                            LOG.debug("Invoke in " + thread.name());
                            this.assertThreadSuspended(thread, context);
                        }
                        if (this.myMethod.isVarArgs() && (lastIndex = this.myMethod.argumentTypeNames().size() - 1) >= 0 && this.myArgs.size() > lastIndex) {
                            List<String> argTypes;
                            ArrayReference arrayRef;
                            Value firstVararg = this.myArgs.get(lastIndex);
                            if (this.myArgs.size() == lastIndex + 1 && firstVararg instanceof ArrayReference && ((ArrayType)(arrayRef = (ArrayReference)firstVararg).referenceType()).componentType() instanceof InterfaceType && (argTypes = this.myMethod.argumentTypeNames()).size() > lastIndex && argTypes.get(lastIndex).startsWith("java.lang.Object")) {
                                this.myArgs.remove(lastIndex);
                                this.myArgs.addAll(arrayRef.getValues());
                            }
                        }
                        if (!Patches.IBM_JDK_DISABLE_COLLECTION_BUG) {
                            StreamEx.of(this.myArgs).select(ObjectReference.class).forEach(DebuggerUtilsEx::disableCollection);
                        }
                        if ((ourTraceMask & 1) != 0) {
                            this.myArgs.forEach(Object::toString);
                        }
                        if ((DebugProcessImpl.this.getTraceMask() & 1) != 0) {
                            StreamEx.of(this.myArgs).findAny(ThreadReference.class::isInstance).ifPresent(t -> {
                                System.err.println("[JDI: workaround for invocation of " + this.myMethod + "]");
                                this.myMethod.virtualMachine().setDebugTraceMode(DebugProcessImpl.this.getTraceMask() & 0xFFFFFFFE);
                            });
                        }
                        int invokePolicy = DebugProcessImpl.getInvokePolicy(context);
                        invocationWatcher = DebugProcessImpl.this.myThreadBlockedMonitor.startInvokeWatching(invokePolicy, thread, context);
                        result.set(this.invokeMethod(invokePolicy, this.myMethod, this.myArgs));
                    }
                    finally {
                        if (invocationWatcher != null) {
                            invocationWatcher.invocationFinished();
                        }
                        if ((DebugProcessImpl.this.getTraceMask() & 1) != 0) {
                            this.myMethod.virtualMachine().setDebugTraceMode(DebugProcessImpl.this.getTraceMask());
                        }
                        if (!Patches.IBM_JDK_DISABLE_COLLECTION_BUG) {
                            StreamEx.of(this.myArgs).select(ObjectReference.class).forEach(DebuggerUtilsEx::enableCollection);
                        }
                    }
                }
                catch (Exception e) {
                    exception.set((Object)e);
                }
            });
            Exception ex = (Exception)exception.get();
            if (ex != null) {
                if (ex instanceof InvocationException) {
                    throw (InvocationException)ex;
                }
                if (ex instanceof ClassNotLoadedException) {
                    throw (ClassNotLoadedException)ex;
                }
                if (ex instanceof IncompatibleThreadStateException) {
                    throw (IncompatibleThreadStateException)ex;
                }
                if (ex instanceof InvalidTypeException) {
                    throw (InvalidTypeException)ex;
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                LOG.error("Unexpected exception", new Throwable(ex));
            }
            return (E)((Value)result.get());
        }

        private void assertThreadSuspended(ThreadReferenceProxyImpl thread, SuspendContextImpl context) {
            LOG.assertTrue(context.isEvaluating());
            try {
                boolean isSuspended = thread.isSuspended();
                LOG.assertTrue(isSuspended, (Object)thread);
            }
            catch (ObjectCollectedException objectCollectedException) {
                // empty catch block
            }
        }
    }

    static enum State {
        INITIAL,
        ATTACHED,
        DETACHING,
        DETACHED;

    }
}

