/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;
import com.sun.jdi.Location;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ContextUtil {
    public static final Key<Boolean> IS_JSP_IMPLICIT = new Key("JspImplicit");
    private static final Logger LOG = Logger.getInstance(PositionUtil.class);

    @Nullable
    public static SourcePosition getSourcePosition(@Nullable StackFrameContext context) {
        if (context == null) {
            return null;
        }
        DebugProcessImpl debugProcess = (DebugProcessImpl)context.getDebugProcess();
        if (debugProcess == null) {
            return null;
        }
        StackFrameProxy frameProxy = context.getFrameProxy();
        if (frameProxy == null) {
            return null;
        }
        Location location = null;
        try {
            location = frameProxy.location();
        }
        catch (Throwable e) {
            LOG.debug(e);
        }
        if (location == null) {
            return null;
        }
        return debugProcess.getPositionManager().getSourcePosition(location);
    }

    @Nullable
    public static PsiElement getContextElement(StackFrameContext context) {
        return ContextUtil.getContextElement(context, ContextUtil.getSourcePosition(context));
    }

    @Nullable
    public static PsiElement getContextElement(StackFrameContext context, SourcePosition position) {
        if (LOG.isDebugEnabled()) {
            SourcePosition sourcePosition = ContextUtil.getSourcePosition(context);
            LOG.assertTrue(Comparing.equal((Object)sourcePosition, (Object)position));
        }
        return (PsiElement)ReadAction.compute(() -> {
            PsiElement element = ContextUtil.getContextElement(position);
            if (element == null) {
                return null;
            }
            if (element.getLanguage().getAssociatedFileType() != DefaultCodeFragmentFactory.getInstance().getFileType()) {
                return element;
            }
            StackFrameProxyImpl frameProxy = (StackFrameProxyImpl)context.getFrameProxy();
            if (frameProxy == null) {
                return element;
            }
            try {
                PsiStatement[] statements;
                List<LocalVariableProxyImpl> list = frameProxy.visibleVariables();
                PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)element.getProject()).getResolveHelper();
                StringBuilder buf = null;
                for (LocalVariableProxyImpl localVariable : list) {
                    String varName = localVariable.name();
                    if (resolveHelper.resolveReferencedVariable(varName, element) != null) continue;
                    if (buf == null) {
                        buf = new StringBuilder("{");
                    }
                    buf.append(localVariable.getVariable().typeName()).append(" ").append(varName).append(";");
                }
                if (buf == null) {
                    return element;
                }
                buf.append('}');
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)element.getProject());
                PsiCodeBlock codeBlockFromText = elementFactory.createCodeBlockFromText(buf.toString(), element);
                for (PsiStatement statement : statements = codeBlockFromText.getStatements()) {
                    PsiElement[] declaredElements;
                    if (!(statement instanceof PsiDeclarationStatement)) continue;
                    PsiDeclarationStatement declStatement = (PsiDeclarationStatement)statement;
                    for (PsiElement declaredElement : declaredElements = declStatement.getDeclaredElements()) {
                        declaredElement.putUserData(IS_JSP_IMPLICIT, (Object)Boolean.TRUE);
                    }
                }
                return codeBlockFromText;
            }
            catch (EvaluateException | IncorrectOperationException ignored) {
                return element;
            }
        });
    }

    @Nullable
    public static PsiElement getContextElement(@Nullable SourcePosition position) {
        return position == null ? null : position.getElementAt();
    }

    public static boolean isJspImplicit(PsiElement element) {
        return Boolean.TRUE.equals(element.getUserData(IS_JSP_IMPLICIT));
    }
}

