/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.jdi.ClassesByNameProvider;
import com.intellij.debugger.jdi.GeneratedLocation;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.settings.CaptureSettingsProvider;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncStacksUtils {
    private static final Logger LOG = Logger.getInstance(AsyncStacksUtils.class);
    public static final String CAPTURE_STORAGE_CLASS_NAME = "com.intellij.rt.debugger.agent.CaptureStorage";
    public static final String CAPTURE_AGENT_CLASS_NAME = "com.intellij.rt.debugger.agent.CaptureAgent";
    private static final Key<Pair<ClassType, Method>> CAPTURE_STORAGE_METHOD = Key.create((String)"CAPTURE_STORAGE_METHOD");
    private static final Pair<ClassType, Method> NO_CAPTURE_AGENT = Pair.empty();

    public static boolean isAgentEnabled() {
        return DebuggerSettings.getInstance().INSTRUMENTING_AGENT;
    }

    @Nullable
    public static List<StackFrameItem> getAgentRelatedStack(@NotNull StackFrameProxyImpl frame, @NotNull SuspendContextImpl suspendContext) {
        if (!AsyncStacksUtils.isAgentEnabled() || !frame.threadProxy().equals(suspendContext.getThread())) {
            return null;
        }
        try {
            Method method = DebuggerUtilsEx.getMethod(frame.location());
            if (method != null && method.name().endsWith("$$$capture")) {
                return AsyncStacksUtils.getProcessCapturedStack(new EvaluationContextImpl(suspendContext, frame));
            }
        }
        catch (EvaluateException e) {
            if (e.getCause() instanceof IncompatibleThreadStateException) {
                LOG.warn((Throwable)e);
            }
            LOG.error((Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<StackFrameItem> getProcessCapturedStack(EvaluationContextImpl evalContext) throws EvaluateException {
        EvaluationContextImpl evaluationContext = evalContext.withAutoLoadClasses(false);
        DebugProcessImpl process2 = evaluationContext.getDebugProcess();
        Pair methodPair = (Pair)process2.getUserData(CAPTURE_STORAGE_METHOD);
        if (methodPair == null) {
            try {
                ClassType captureClass = (ClassType)process2.findClass(evaluationContext, CAPTURE_STORAGE_CLASS_NAME, null);
                if (captureClass == null) {
                    methodPair = NO_CAPTURE_AGENT;
                    LOG.debug("Error loading debug agent", new Object[]{"agent class not found"});
                } else {
                    methodPair = Pair.create((Object)captureClass, (Object)DebuggerUtils.findMethod((ReferenceType)captureClass, (String)"getCurrentCapturedStack", null));
                }
            }
            catch (EvaluateException e) {
                methodPair = NO_CAPTURE_AGENT;
                LOG.debug("Error loading debug agent", (Throwable)e);
            }
            AsyncStacksUtils.putProcessUserData(CAPTURE_STORAGE_METHOD, methodPair, process2);
        }
        if (methodPair == NO_CAPTURE_AGENT) {
            return null;
        }
        Pair finalMethodPair = methodPair;
        VirtualMachineProxyImpl virtualMachineProxy = process2.getVirtualMachineProxy();
        List<IntegerValue> args = Collections.singletonList(virtualMachineProxy.mirrorOf(AsyncStacksUtils.getMaxStackLength()));
        String value2 = (String)DebuggerUtils.processCollectibleValue(() -> process2.invokeMethod(evaluationContext, (ClassType)finalMethodPair.first, (Method)finalMethodPair.second, args, 1, true), result -> result instanceof StringReference ? ((StringReference)result).value() : null);
        if (value2 == null) return null;
        ArrayList<StackFrameItem> res = new ArrayList<StackFrameItem>();
        ClassesByNameProvider classesByName = ClassesByNameProvider.createCache(virtualMachineProxy.allClasses());
        try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(value2.getBytes(StandardCharsets.ISO_8859_1)));){
            while (dis.available() > 0) {
                ProcessStackFrameItem item = null;
                if (dis.readBoolean()) {
                    String className2 = dis.readUTF();
                    String methodName = dis.readUTF();
                    int line = dis.readInt();
                    Location location = AsyncStacksUtils.findLocation(process2, (ReferenceType)ContainerUtil.getFirstItem(classesByName.get(className2)), methodName, line);
                    item = new ProcessStackFrameItem(location, className2, methodName);
                }
                res.add(item);
            }
            ArrayList<StackFrameItem> arrayList = res;
            return arrayList;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    public static void setupAgent(final DebugProcessImpl process2) {
        Properties properties;
        if (!AsyncStacksUtils.isAgentEnabled()) {
            return;
        }
        if (Registry.is((String)"debugger.capture.points.agent.debug")) {
            AsyncStacksUtils.enableAgentDebug(process2);
        }
        if (DebuggerUtilsImpl.isRemote(process2) && !(properties = CaptureSettingsProvider.getPointsProperties(process2.getProject())).isEmpty()) {
            process2.addDebugProcessListener(new DebugProcessAdapterImpl(){

                @Override
                public void paused(SuspendContextImpl suspendContext) {
                    if (process2.isEvaluationPossible()) {
                        try {
                            StackCapturingLineBreakpoint.deleteAll(process2);
                            try {
                                AsyncStacksUtils.addAgentCapturePoints(new EvaluationContextImpl(suspendContext, suspendContext.getFrameProxy()), properties);
                                process2.removeDebugProcessListener(this);
                            }
                            finally {
                                process2.onHotSwapFinished();
                                StackCapturingLineBreakpoint.createAll(process2);
                            }
                        }
                        catch (Exception e) {
                            LOG.debug((Throwable)e);
                        }
                    }
                }
            });
        }
    }

    private static void enableAgentDebug(final DebugProcessImpl process2) {
        final RequestManagerImpl requestsManager = process2.getRequestsManager();
        ClassPrepareRequestor requestor = new ClassPrepareRequestor(){

            public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                try {
                    requestsManager.deleteRequest((Requestor)this);
                    ((ClassType)referenceType).setValue(referenceType.fieldByName("DEBUG"), process2.getVirtualMachineProxy().mirrorOf(true));
                }
                catch (Exception e) {
                    LOG.warn("Error setting agent debug mode", (Throwable)e);
                }
            }
        };
        requestsManager.callbackOnPrepareClasses(requestor, CAPTURE_STORAGE_CLASS_NAME);
        try {
            ClassType captureClass = (ClassType)process2.findClass(null, CAPTURE_STORAGE_CLASS_NAME, null);
            if (captureClass != null) {
                requestor.processClassPrepare((DebugProcess)process2, (ReferenceType)captureClass);
            }
        }
        catch (Exception e) {
            LOG.warn("Error setting agent debug mode", (Throwable)e);
        }
    }

    private static Location findLocation(DebugProcessImpl debugProcess, ReferenceType type2, String methodName, int line) {
        if (type2 != null && line >= 0) {
            for (Method method : DebuggerUtilsEx.declaredMethodsByName(type2, methodName)) {
                List<Location> locations = DebuggerUtilsEx.locationsOfLine(method, line);
                if (locations.isEmpty()) continue;
                return locations.get(0);
            }
        }
        return new GeneratedLocation(debugProcess, type2, methodName, line);
    }

    public static void addAgentCapturePoints(EvaluationContextImpl evalContext, Properties properties) {
        EvaluationContextImpl evaluationContext = evalContext.withAutoLoadClasses(false);
        DebugProcessImpl process2 = evaluationContext.getDebugProcess();
        try {
            ClassType captureClass = (ClassType)process2.findClass(evaluationContext, CAPTURE_AGENT_CLASS_NAME, null);
            if (captureClass == null) {
                LOG.debug("Error loading debug agent", new Object[]{"agent class not found"});
            } else {
                Method method = DebuggerUtils.findMethod((ReferenceType)captureClass, (String)"addCapturePoints", null);
                if (method != null) {
                    StringWriter writer = new StringWriter();
                    try {
                        properties.store(writer, null);
                        List<StringReference> args = Collections.singletonList(DebuggerUtilsEx.mirrorOfString(writer.toString(), process2.getVirtualMachineProxy(), evalContext));
                        process2.invokeMethod(evaluationContext, captureClass, method, args, 1, true);
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        }
        catch (EvaluateException e) {
            LOG.debug("Error loading debug agent", (Throwable)e);
        }
    }

    public static <T> void putProcessUserData(final @NotNull Key<T> key2, @Nullable T value2, DebugProcessImpl debugProcess) {
        debugProcess.putUserData(key2, value2);
        debugProcess.addDebugProcessListener(new DebugProcessListener(){

            public void processDetached(@NotNull DebugProcess process2, boolean closedByUser) {
                process2.putUserData(key2, null);
            }
        });
    }

    public static int getMaxStackLength() {
        return Registry.intValue((String)"debugger.async.stacks.max.depth", (int)500);
    }

    private static class ProcessStackFrameItem
    extends StackFrameItem {
        final String myClass;
        final String myMethod;

        ProcessStackFrameItem(Location location, String aClass, String method) {
            super(location, null);
            this.myClass = aClass;
            this.myMethod = method;
        }

        @Override
        @NotNull
        public String path() {
            return this.myClass;
        }

        @Override
        @NotNull
        public String method() {
            return this.myMethod;
        }

        @Override
        public String toString() {
            return this.myClass + "." + this.myMethod + ":" + this.line();
        }
    }
}

