/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.AutoRendererAction;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.JavaReferringObjectsValue;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewAsGroup
extends ActionGroup
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(ViewAsGroup.class);
    private volatile AnAction[] myChildren = AnAction.EMPTY_ARRAY;

    public ViewAsGroup() {
        super(Presentation.NULL_STRING, true);
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        return this.myChildren;
    }

    private void updateChildren(List<JavaValue> values, Project project, AnActionEvent event) {
        ViewAsGroup.getApplicableRenderers(values, project).thenAccept(rs -> {
            AnAction[] viewAsActions;
            List renderers = StreamEx.of((Collection)rs).map(RendererAction::new).toList();
            if (ContainerUtil.isEmpty((Collection)renderers)) {
                return;
            }
            ArrayList<Object> children = new ArrayList<Object>();
            for (AnAction viewAsAction : viewAsActions = ((DefaultActionGroup)ActionManager.getInstance().getAction("Debugger.Representation")).getChildren(null)) {
                if (viewAsAction instanceof AutoRendererAction) {
                    if (renderers.size() <= 1) continue;
                    viewAsAction.getTemplatePresentation().setVisible(true);
                    children.add(viewAsAction);
                    continue;
                }
                children.add(viewAsAction);
            }
            if (!children.isEmpty()) {
                children.add(Separator.getInstance());
            }
            children.addAll(renderers);
            this.myChildren = children.toArray(AnAction.EMPTY_ARRAY);
            DebuggerAction.enableAction(event, this.myChildren.length > 0);
        });
    }

    @NotNull
    private static CompletableFuture<List<NodeRenderer>> getApplicableRenderers(List<JavaValue> values, Project project) {
        ArrayList<CompletableFuture<List<NodeRenderer>>> futures = new ArrayList<CompletableFuture<List<NodeRenderer>>>(values.size());
        for (JavaValue value2 : values) {
            if (value2 instanceof JavaReferringObjectsValue) {
                return CompletableFuture.completedFuture(Collections.emptyList());
            }
            ValueDescriptorImpl valueDescriptor = value2.getDescriptor();
            if (!valueDescriptor.isValueValid()) {
                return CompletableFuture.completedFuture(Collections.emptyList());
            }
            futures.add(DebuggerUtilsImpl.getApplicableRenderers(NodeRendererSettings.getInstance().getAllRenderers(project), valueDescriptor.getType()));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(__ -> {
            List res = null;
            for (CompletableFuture future : futures) {
                List list = (List)future.join();
                if (res == null) {
                    res = list;
                    continue;
                }
                res.retainAll(list);
            }
            return ContainerUtil.notNullize(res);
        });
    }

    public void update(final @NotNull AnActionEvent event) {
        if (!DebuggerAction.isFirstStart(event)) {
            return;
        }
        this.myChildren = AnAction.EMPTY_ARRAY;
        DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(event.getDataContext());
        final List<JavaValue> values = ViewAsGroup.getSelectedValues(event);
        if (values.isEmpty()) {
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        final DebugProcessImpl process2 = debuggerContext.getDebugProcess();
        if (process2 == null) {
            event.getPresentation().setEnabled(false);
            return;
        }
        process2.getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext){

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                ViewAsGroup.this.updateChildren(values, process2.getProject(), event);
            }
        });
    }

    @NotNull
    public static List<JavaValue> getSelectedValues(AnActionEvent event) {
        return StreamEx.of((Collection)XDebuggerTreeActionBase.getSelectedNodes((DataContext)event.getDataContext())).map(XValueContainerNode::getValueContainer).select(JavaValue.class).toList();
    }

    private static class RendererAction
    extends ToggleAction {
        private final NodeRenderer myNodeRenderer;

        RendererAction(NodeRenderer nodeRenderer) {
            super(nodeRenderer.getName());
            this.myNodeRenderer = nodeRenderer;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            List<JavaValue> values = ViewAsGroup.getSelectedValues(e);
            if (values.isEmpty()) {
                return false;
            }
            for (JavaValue value2 : values) {
                if (value2.getDescriptor().getLastRenderer() == this.myNodeRenderer) continue;
                return false;
            }
            return true;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (!state) {
                return;
            }
            DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext());
            List<JavaValue> values = ViewAsGroup.getSelectedValues(e);
            final List selectedNodes = XDebuggerTreeActionBase.getSelectedNodes((DataContext)e.getDataContext());
            LOG.assertTrue(!values.isEmpty());
            DebugProcessImpl process2 = debuggerContext.getDebugProcess();
            if (process2 == null) {
                return;
            }
            process2.getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext){

                @Override
                public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                    for (XValueNodeImpl node : selectedNodes) {
                        XValue container = (XValue)node.getValueContainer();
                        if (!(container instanceof JavaValue)) continue;
                        ((JavaValue)container).setRenderer(myNodeRenderer, node);
                    }
                }
            });
        }
    }
}

