/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.GotoFrameSourceAction;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.impl.DebuggerTreePanel;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.ui.DoubleClickListener;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerAction
extends AnAction {
    @Nullable
    public static DebuggerTree getTree(DataContext dataContext) {
        return (DebuggerTree)((Object)DebuggerTree.DATA_KEY.getData(dataContext));
    }

    @Nullable
    public static DebuggerTreePanel getPanel(DataContext dataContext) {
        return (DebuggerTreePanel)DebuggerTreePanel.DATA_KEY.getData(dataContext);
    }

    @Nullable
    public static DebuggerTreeNodeImpl getSelectedNode(DataContext dataContext) {
        DebuggerTree tree = DebuggerAction.getTree(dataContext);
        if (tree == null) {
            return null;
        }
        if (tree.getSelectionCount() != 1) {
            return null;
        }
        TreePath path = tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object component = path.getLastPathComponent();
        if (!(component instanceof DebuggerTreeNodeImpl)) {
            return null;
        }
        return (DebuggerTreeNodeImpl)component;
    }

    public static DebuggerTreeNodeImpl @Nullable [] getSelectedNodes(DataContext dataContext) {
        DebuggerTree tree = DebuggerAction.getTree(dataContext);
        if (tree == null) {
            return null;
        }
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return Holder.EMPTY_TREE_NODE_ARRAY;
        }
        ArrayList<DebuggerTreeNodeImpl> nodes = new ArrayList<DebuggerTreeNodeImpl>(paths.length);
        for (TreePath path : paths) {
            Object component = path.getLastPathComponent();
            if (!(component instanceof DebuggerTreeNodeImpl)) continue;
            nodes.add((DebuggerTreeNodeImpl)component);
        }
        return nodes.toArray(new DebuggerTreeNodeImpl[0]);
    }

    @NotNull
    public static DebuggerContextImpl getDebuggerContext(DataContext dataContext) {
        DebuggerTreePanel panel2 = DebuggerAction.getPanel(dataContext);
        if (panel2 != null) {
            return panel2.getContext();
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        return project != null ? DebuggerManagerEx.getInstanceEx(project).getContext() : DebuggerContextImpl.EMPTY_CONTEXT;
    }

    public static boolean isContextView(AnActionEvent e) {
        return "Debugger.EvaluationDialogPopup".equals(e.getPlace()) || "Debugger.FramePanelPopup".equals(e.getPlace()) || "Debugger.WatchesPanelPopup".equals(e.getPlace()) || "Debugger.InspectPanelPopup".equals(e.getPlace());
    }

    public static Disposable installEditAction(final JTree tree, String actionName) {
        DoubleClickListener listener = new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (tree.getPathForLocation(e.getX(), e.getY()) == null) {
                    return false;
                }
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)tree);
                GotoFrameSourceAction.doAction(dataContext);
                return true;
            }
        };
        listener.installOn((Component)tree);
        Disposable disposable = () -> listener.uninstall((Component)tree);
        DebuggerUIUtil.registerActionOnComponent((String)actionName, (JComponent)tree, (Disposable)disposable);
        return disposable;
    }

    public static boolean isFirstStart(AnActionEvent event) {
        String key2 = "initalized";
        if (event.getPresentation().getClientProperty(key2) != null) {
            return false;
        }
        event.getPresentation().putClientProperty(key2, (Object)key2);
        return true;
    }

    public static void enableAction(AnActionEvent event, boolean enable) {
        SwingUtilities.invokeLater(() -> {
            event.getPresentation().setEnabled(enable);
            event.getPresentation().setVisible(true);
        });
    }

    public static void refreshViews(AnActionEvent e) {
        XDebuggerTree tree = XDebuggerTree.getTree((DataContext)e.getDataContext());
        if (tree != null) {
            DebuggerAction.refreshViews(XDebugView.getSession((Component)tree));
        }
    }

    public static void refreshViews(@Nullable XDebugSession session) {
        if (session != null) {
            XDebugProcess process2 = session.getDebugProcess();
            if (process2 instanceof JavaDebugProcess) {
                ((JavaDebugProcess)process2).saveNodeHistory();
            }
            session.rebuildViews();
        }
    }

    public static boolean isInJavaSession(AnActionEvent e) {
        XDebugSession session = DebuggerAction.getSession(e);
        return session != null && session.getDebugProcess() instanceof JavaDebugProcess;
    }

    @Nullable
    public static XDebugSession getSession(AnActionEvent e) {
        Project project;
        XDebugSession session = (XDebugSession)e.getData(XDebugSession.DATA_KEY);
        if (session == null && (project = e.getProject()) != null) {
            session = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        }
        return session;
    }

    private static class Holder {
        private static final DebuggerTreeNodeImpl[] EMPTY_TREE_NODE_ARRAY = new DebuggerTreeNodeImpl[0];

        private Holder() {
        }
    }
}

