/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.progress;

import com.intellij.build.BuildBundle;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildViewManager;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.ExecutionNode;
import com.intellij.build.FileNavigatable;
import com.intellij.build.FilePosition;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.progress.BuildProgress;
import com.intellij.build.progress.BuildProgressDescriptor;
import com.intellij.compiler.impl.CompilerPropertiesAction;
import com.intellij.compiler.impl.ExcludeFromCompileAction;
import com.intellij.compiler.impl.ExitStatus;
import com.intellij.compiler.progress.BuildViewService;
import com.intellij.compiler.progress.CompilerMessagesService;
import com.intellij.compiler.progress.ModuleLinkFilter;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.RegexpFilter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.pom.Navigatable;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Stack;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class BuildOutputService
implements BuildViewService {
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_RED = "\u001b[31m";
    private static final String ANSI_YELLOW = "\u001b[33m";
    private static final String ANSI_BOLD = "\u001b[1m";
    @NotNull
    private final Project myProject;
    @NotNull
    private final BuildProgress<BuildProgressDescriptor> myBuildProgress;
    @NotNull
    private final String myContentName;

    public BuildOutputService(@NotNull Project project, @NotNull String contentName) {
        this.myProject = project;
        this.myContentName = contentName;
        this.myBuildProgress = BuildViewManager.createBuildProgress((Project)project);
    }

    @Override
    public void registerCloseAction(Runnable onClose) {
    }

    @Override
    public void onProgressChange(Object sessionId, ProgressIndicator indicator) {
    }

    @Override
    public void onStart(Object sessionId, long startCompilationStamp, Runnable restartWork, ProgressIndicator indicator) {
        List<AnAction> restartActions = this.getRestartActions(restartWork, indicator);
        List<AnAction> contextActions = BuildOutputService.getContextActions();
        String title = this.myContentName.equals(JavaCompilerBundle.message((String)"compiler.content.name.rebuild", (Object[])new Object[0])) || this.myContentName.equals(JavaCompilerBundle.message((String)"compiler.content.name.recompile", (Object[])new Object[0])) || this.myContentName.equals(JavaCompilerBundle.message((String)"compiler.content.name.make", (Object[])new Object[0])) ? this.myProject.getName() : StringUtil.capitalize((String)StringUtil.wordsToBeginFromLowerCase((String)this.myContentName));
        final DefaultBuildDescriptor buildDescriptor = new DefaultBuildDescriptor(sessionId, title, StringUtil.notNullize((String)this.myProject.getBasePath()), startCompilationStamp).withRestartActions(restartActions.toArray(AnAction.EMPTY_ARRAY)).withAction((AnAction)new CompilerPropertiesAction()).withExecutionFilter((Filter)new ModuleLinkFilter(this.myProject)).withExecutionFilter((Filter)new RegexpFilter(this.myProject, "$FILE_PATH$:$LINE$:$COLUMN$")).withContextAction(node -> new ExcludeFromCompileAction(this.myProject, (ExecutionNode)node){
            final /* synthetic */ ExecutionNode val$node;
            {
                this.val$node = executionNode;
                super(project);
            }

            @Override
            @Nullable
            protected VirtualFile getFile() {
                List navigatables = this.val$node.getNavigatables();
                if (navigatables.size() != 1) {
                    return null;
                }
                Navigatable navigatable = (Navigatable)navigatables.get(0);
                if (navigatable instanceof OpenFileDescriptor) {
                    return ((OpenFileDescriptor)navigatable).getFile();
                }
                if (navigatable instanceof FileNavigatable) {
                    OpenFileDescriptor fileDescriptor = ((FileNavigatable)navigatable).getFileDescriptor();
                    return fileDescriptor != null ? fileDescriptor.getFile() : null;
                }
                return null;
            }
        }).withContextActions(contextActions.toArray(AnAction.EMPTY_ARRAY));
        this.myBuildProgress.start(new BuildProgressDescriptor(){

            @NotNull
            public String getTitle() {
                return buildDescriptor.getTitle();
            }

            @NotNull
            public BuildDescriptor getBuildDescriptor() {
                return buildDescriptor;
            }
        });
        this.addIndicatorDelegate(indicator);
    }

    @Override
    public void onEnd(Object sessionId, ExitStatus exitStatus, long endBuildStamp) {
        if (exitStatus == ExitStatus.ERRORS) {
            String message2 = BuildBundle.message((String)"build.messages.failed", (Object[])new Object[]{StringUtil.wordsToBeginFromLowerCase((String)this.myContentName)});
            this.myBuildProgress.fail(endBuildStamp, message2);
        } else if (exitStatus == ExitStatus.CANCELLED) {
            String message3 = BuildBundle.message((String)"build.messages.cancelled", (Object[])new Object[]{StringUtil.wordsToBeginFromLowerCase((String)this.myContentName)});
            this.myBuildProgress.cancel(endBuildStamp, message3);
        } else {
            boolean isUpToDate;
            boolean bl = isUpToDate = exitStatus == ExitStatus.UP_TO_DATE;
            if ("Classes up-to-date check".equals(this.myContentName)) {
                if (isUpToDate) {
                    this.myBuildProgress.output(JavaCompilerBundle.message((String)"compiler.build.messages.classes.check.uptodate", (Object[])new Object[0]), true);
                } else {
                    this.myBuildProgress.output(JavaCompilerBundle.message((String)"compiler.build.messages.classes.check.outdated", (Object[])new Object[0]), true);
                }
            }
            String message4 = BuildBundle.message((String)"build.messages.finished", (Object[])new Object[]{StringUtil.wordsToBeginFromLowerCase((String)this.myContentName)});
            this.myBuildProgress.finish(endBuildStamp, isUpToDate, message4);
        }
    }

    @Override
    public void addMessage(Object sessionId, CompilerMessage compilerMessage) {
        MessageEvent.Kind kind2 = BuildOutputService.convertCategory(compilerMessage.getCategory());
        VirtualFile virtualFile = compilerMessage.getVirtualFile();
        Navigatable navigatable = compilerMessage.getNavigatable();
        if (virtualFile != null) {
            FilePosition filePosition;
            File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
            if (navigatable instanceof OpenFileDescriptor) {
                OpenFileDescriptor fileDescriptor = (OpenFileDescriptor)navigatable;
                int column = fileDescriptor.getColumn();
                int line = fileDescriptor.getLine();
                filePosition = new FilePosition(file, line, column);
            } else {
                filePosition = new FilePosition(file, 0, 0);
            }
            String title = BuildOutputService.getMessageTitle(compilerMessage);
            this.myBuildProgress.fileMessage(title, compilerMessage.getMessage(), kind2, filePosition);
        } else {
            if (kind2 == MessageEvent.Kind.ERROR || kind2 == MessageEvent.Kind.WARNING) {
                String title = BuildOutputService.getMessageTitle(compilerMessage);
                this.myBuildProgress.message(title, compilerMessage.getMessage(), kind2, navigatable);
            }
            String color = kind2 == MessageEvent.Kind.ERROR ? ANSI_RED : (kind2 == MessageEvent.Kind.WARNING ? ANSI_YELLOW : ANSI_BOLD);
            this.myBuildProgress.output(color + compilerMessage.getMessage() + ANSI_RESET + '\n', kind2 != MessageEvent.Kind.ERROR);
        }
    }

    @NotNull
    private List<AnAction> getRestartActions(final Runnable restartWork, final ProgressIndicator indicator) {
        SmartList restartActions = new SmartList();
        if (restartWork != null) {
            DumbAwareAction restartAction = new DumbAwareAction(ExecutionBundle.messagePointer((String)"rerun.configuration.action.name", (Object[])new Object[]{StringUtil.escapeMnemonics((String)this.myContentName)}), Presentation.NULL_STRING, AllIcons.Actions.Compile){

                public void update(@NotNull AnActionEvent e) {
                    e.getPresentation().setEnabled(!indicator.isRunning());
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    restartWork.run();
                }
            };
            restartActions.add(restartAction);
        }
        DumbAwareAction stopAction = new DumbAwareAction(IdeBundle.messagePointer((String)"action.stop", (Object[])new Object[0]), AllIcons.Actions.Suspend){

            public void actionPerformed(@NotNull AnActionEvent e) {
                indicator.cancel();
            }

            public void update(@NotNull AnActionEvent event) {
                event.getPresentation().setEnabled(indicator.isRunning());
            }
        };
        restartActions.add(stopAction);
        return restartActions;
    }

    private void addIndicatorDelegate(final ProgressIndicator indicator) {
        if (!(indicator instanceof ProgressIndicatorEx)) {
            return;
        }
        ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new CompilerMessagesService.DummyProgressIndicator(){
            private final Map<String, Set<String>> mySeenMessages = new HashMap<String, Set<String>>();
            private String lastMessage = null;
            private Stack<String> myTextStack;

            @Override
            public void setText(@Nls(capitalization=Nls.Capitalization.Sentence) String text2) {
                this.addIndicatorNewMessagesAsBuildOutput(text2);
            }

            @Override
            public void pushState() {
                this.getTextStack().push((Object)indicator.getText());
            }

            @Override
            public void setFraction(double fraction) {
                BuildOutputService.this.myBuildProgress.progress(this.lastMessage, 100L, (long)(fraction * 100.0), "%");
            }

            @NotNull
            private Stack<String> getTextStack() {
                Stack stack = this.myTextStack;
                if (stack == null) {
                    this.myTextStack = stack = new Stack(2);
                }
                return stack;
            }

            private void addIndicatorNewMessagesAsBuildOutput(String msg) {
                int end;
                Stack<String> textStack = this.getTextStack();
                if (!textStack.isEmpty() && msg.equals(textStack.peek())) {
                    textStack.pop();
                    return;
                }
                if (StringUtil.isEmptyOrSpaces((String)msg) || msg.equals(this.lastMessage)) {
                    return;
                }
                this.lastMessage = msg;
                int start = msg.indexOf("[");
                if (start >= 1 && (end = msg.indexOf(93, start + 1)) != -1) {
                    boolean isSeenMessage;
                    String buildTargetNameCandidate = msg.substring(start + 1, end);
                    Set targets = this.mySeenMessages.computeIfAbsent(buildTargetNameCandidate, unused -> new HashSet());
                    boolean bl = isSeenMessage = !targets.add(msg.substring(0, start));
                    if (isSeenMessage) {
                        return;
                    }
                }
                BuildOutputService.this.myBuildProgress.output(msg + '\n', true);
            }
        });
    }

    @NotNull
    private static List<AnAction> getContextActions() {
        SmartList contextActions = new SmartList();
        ActionGroup compilerErrorsViewPopupGroup = (ActionGroup)ActionManager.getInstance().getAction("CompilerErrorViewPopupMenu");
        if (compilerErrorsViewPopupGroup != null) {
            Collections.addAll(contextActions, compilerErrorsViewPopupGroup.getChildren(null));
        }
        return contextActions;
    }

    private static String getMessageTitle(@NotNull CompilerMessage compilerMessage) {
        String message2 = null;
        String[] messages = StringUtil.splitByLines((String)compilerMessage.getMessage());
        if (messages.length > 1) {
            String part1;
            String line0 = messages[0];
            String line1 = messages[1];
            int colonIndex = line1.indexOf(58);
            if (colonIndex > 0 && "symbol".equals(part1 = line1.substring(0, colonIndex).trim())) {
                String symbol = line1.substring(colonIndex + 1).trim();
                message2 = line0 + " " + symbol;
            }
        }
        if (message2 == null) {
            message2 = messages[0];
        }
        return StringUtil.trimEnd((String)StringUtil.trimStart(message2, (String)"java: "), (char)'.');
    }

    @NotNull
    private static MessageEvent.Kind convertCategory(@NotNull CompilerMessageCategory category) {
        switch (category) {
            case ERROR: {
                return MessageEvent.Kind.ERROR;
            }
            case WARNING: {
                return MessageEvent.Kind.WARNING;
            }
            case INFORMATION: {
                return MessageEvent.Kind.INFO;
            }
            case STATISTICS: {
                return MessageEvent.Kind.STATISTICS;
            }
        }
        return MessageEvent.Kind.SIMPLE;
    }
}

