/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.inspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceEx;
import com.intellij.compiler.backwardRefs.ReferenceIndexUnavailableException;
import com.intellij.compiler.inspection.ChangeSuperClassFix;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.SystemProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.CompilerRef;

public final class FrequentlyUsedInheritorInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(FrequentlyUsedInheritorInspection.class);
    public static final byte MAX_RESULT = 3;
    private static final int PERCENT_THRESHOLD = SystemProperties.getIntProperty((String)"FrequentlyUsedInheritorInspection.percent.threshold", (int)20);

    public ProblemDescriptor @Nullable [] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass instanceof PsiTypeParameter || aClass.isEnum()) {
            return null;
        }
        Pair<PsiClass, PsiElement> superClassAndPlace = FrequentlyUsedInheritorInspection.getSuperIfOnlyOne(aClass);
        if (superClassAndPlace == null) {
            return null;
        }
        PsiClass superClass = (PsiClass)superClassAndPlace.getFirst();
        long ms = System.currentTimeMillis();
        List<ClassAndInheritorCount> topInheritors = FrequentlyUsedInheritorInspection.getTopInheritorsUsingCompilerIndices(superClass, aClass.getResolveScope(), (PsiElement)aClass);
        if (LOG.isDebugEnabled()) {
            LOG.debug("search for inheritance structure of " + superClass.getQualifiedName() + " in " + (System.currentTimeMillis() - ms) + " ms");
        }
        if (topInheritors.isEmpty()) {
            return null;
        }
        ArrayList<ChangeSuperClassFix> topInheritorsQuickFix = new ArrayList<ChangeSuperClassFix>(topInheritors.size());
        for (ClassAndInheritorCount searchResult : topInheritors) {
            PsiClass psi = searchResult.psi;
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)psi, (PsiClass)aClass, (boolean)true)) continue;
            ChangeSuperClassFix quickFix = new ChangeSuperClassFix(aClass, psi, superClass, searchResult.number, searchResult.psi.isInterface() && !aClass.isInterface());
            topInheritorsQuickFix.add(quickFix);
            if (topInheritorsQuickFix.size() < 3) continue;
            break;
        }
        Object highlightingElement = aClass.getFields().length == 0 && aClass.getMethods().length == 0 && aClass.getInnerClasses().length == 0 && aClass.getInitializers().length == 0 ? aClass : (aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassReference() : (PsiElement)superClassAndPlace.getSecond());
        return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)highlightingElement, JavaCompilerBundle.message((String)"class.can.have.more.common.super.class", (Object[])new Object[0]), isOnTheFly, topInheritorsQuickFix.toArray(LocalQuickFix.EMPTY_ARRAY), ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
    }

    @Nullable
    private static Pair<PsiClass, PsiElement> getSuperIfOnlyOne(@NotNull PsiClass aClass) {
        PsiClass superClass = aClass.getSuperClass();
        if (superClass != null && !"java.lang.Object".equals(superClass.getQualifiedName())) {
            return FrequentlyUsedInheritorInspection.isInSourceContent((PsiElement)aClass) ? Pair.create((Object)superClass, (Object)aClass.getExtendsList()) : null;
        }
        PsiClass anInterface = ((Optional)((StreamEx)((StreamEx)StreamEx.of((Object[])aClass.getInterfaces()).filter(c -> !"java.lang.Object".equals(c.getQualifiedName()))).filter(c -> FrequentlyUsedInheritorInspection.isInSourceContent((PsiElement)c))).collect(MoreCollectors.onlyOne())).orElse(null);
        if (anInterface == null) {
            return null;
        }
        return Pair.create((Object)anInterface, (Object)(aClass.isInterface() ? aClass.getExtendsList() : aClass.getImplementsList()));
    }

    @NotNull
    private static List<ClassAndInheritorCount> getTopInheritorsUsingCompilerIndices(@NotNull PsiClass aClass, @NotNull GlobalSearchScope searchScope, @NotNull PsiElement place) {
        String qName = aClass.getQualifiedName();
        if (qName == null) {
            return Collections.emptyList();
        }
        Project project = aClass.getProject();
        CompilerReferenceServiceEx compilerRefService = (CompilerReferenceServiceEx)CompilerReferenceService.getInstance(project);
        try {
            int id = compilerRefService.getNameId(qName);
            if (id == 0) {
                return Collections.emptyList();
            }
            return FrequentlyUsedInheritorInspection.findInheritors(aClass, new CompilerRef.JavaCompilerClassRef(id), searchScope, place, -1, project, compilerRefService);
        }
        catch (ReferenceIndexUnavailableException e) {
            return Collections.emptyList();
        }
    }

    private static List<ClassAndInheritorCount> findInheritors(@NotNull PsiClass aClass, @NotNull CompilerRef.JavaCompilerClassRef classAsCompilerRef, @NotNull GlobalSearchScope searchScope, @NotNull PsiElement place, int hierarchyCardinality, @NotNull Project project, @NotNull CompilerReferenceServiceEx compilerRefService) {
        CompilerRef.CompilerClassHierarchyElementDef[] directInheritors = compilerRefService.getDirectInheritors((CompilerRef.CompilerClassHierarchyElementDef)classAsCompilerRef);
        if (hierarchyCardinality == -1 && (hierarchyCardinality = compilerRefService.getInheritorCount((CompilerRef.CompilerClassHierarchyElementDef)classAsCompilerRef)) == -1) {
            return Collections.emptyList();
        }
        int finalHierarchyCardinality = hierarchyCardinality;
        List directInheritorStats = Stream.of(directInheritors).filter(inheritor -> !(inheritor instanceof CompilerRef.CompilerAnonymousClassDef)).map(inheritor -> {
            ProgressManager.checkCanceled();
            int count = compilerRefService.getInheritorCount((CompilerRef.CompilerClassHierarchyElementDef)inheritor);
            if (count != 1 && count * 100 > finalHierarchyCardinality * PERCENT_THRESHOLD) {
                return new Object((CompilerRef.CompilerClassHierarchyElementDef)inheritor, count){
                    final CompilerRef.CompilerClassHierarchyElementDef myDef;
                    final int inheritorCount;
                    final /* synthetic */ CompilerRef.CompilerClassHierarchyElementDef val$inheritor;
                    final /* synthetic */ int val$count;
                    {
                        this.val$inheritor = compilerClassHierarchyElementDef;
                        this.val$count = n;
                        this.myDef = this.val$inheritor;
                        this.inheritorCount = this.val$count;
                    }
                };
            }
            return null;
        }).filter(Objects::nonNull).map(defAndCount -> {
            PsiClass inheritor;
            String name2 = compilerRefService.getName(defAndCount.myDef.getName());
            PsiClass[] inheritors = JavaPsiFacade.getInstance((Project)project).findClasses(name2, searchScope);
            if (inheritors.length == 1 && (inheritor = inheritors[0]).isInheritor(aClass, false)) {
                return new ClassAndInheritorCount(inheritor, defAndCount.myDef, defAndCount.inheritorCount);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        PsiResolveHelper resolveHelper = PsiResolveHelper.SERVICE.getInstance((Project)project);
        return directInheritorStats.stream().filter(c -> resolveHelper.isAccessible((PsiMember)((ClassAndInheritorCount)c).psi, place, null)).flatMap(c -> StreamEx.of(FrequentlyUsedInheritorInspection.getClassesIfInterface(c, finalHierarchyCardinality, searchScope, place, project, compilerRefService)).prepend(c)).sorted().limit(3L).collect(Collectors.toList());
    }

    private static List<ClassAndInheritorCount> getClassesIfInterface(@NotNull ClassAndInheritorCount classAndInheritorCount, int hierarchyCardinality, GlobalSearchScope searchScope, PsiElement place, Project project, CompilerReferenceServiceEx compilerRefService) {
        if (classAndInheritorCount.psi.isInterface()) {
            return FrequentlyUsedInheritorInspection.findInheritors(classAndInheritorCount.psi, (CompilerRef.JavaCompilerClassRef)classAndInheritorCount.descriptor, searchScope, place, hierarchyCardinality, project, compilerRefService);
        }
        return Collections.emptyList();
    }

    private static boolean isInSourceContent(@NotNull PsiElement e) {
        VirtualFile file = e.getContainingFile().getVirtualFile();
        if (file == null) {
            return false;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)e.getProject()).getFileIndex();
        return index.isInContent(file);
    }

    private static class ClassAndInheritorCount
    implements Comparable<ClassAndInheritorCount> {
        private final PsiClass psi;
        private final CompilerRef.CompilerClassHierarchyElementDef descriptor;
        private final int number;

        private ClassAndInheritorCount(PsiClass psi, CompilerRef.CompilerClassHierarchyElementDef descriptor, int number) {
            this.psi = psi;
            this.descriptor = descriptor;
            this.number = number;
        }

        @Override
        public int compareTo(@NotNull ClassAndInheritorCount o) {
            return -this.number + o.number;
        }
    }
}

