/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.javac;

import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfigurable;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.compiler.CompilerOptions;

public class JavacCompiler
implements BackendCompiler {
    private final Project myProject;

    public JavacCompiler(Project project) {
        this.myProject = project;
    }

    @Override
    @NotNull
    @NonNls
    public String getId() {
        return "Javac";
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return JavaCompilerBundle.message((String)"compiler.javac.name", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Configurable createConfigurable() {
        return new JavacConfigurable(this.myProject, JavacConfiguration.getOptions(this.myProject, JavacConfiguration.class));
    }

    @Override
    @NotNull
    public Set<FileType> getCompilableFileTypes() {
        return Collections.singleton(JavaFileType.INSTANCE);
    }

    @Override
    @NotNull
    public CompilerOptions getOptions() {
        return JavacConfiguration.getOptions(this.myProject, JavacConfiguration.class);
    }
}

