/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.CompilerReferenceService;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceImpl;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.StubbedSpine;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompilerElementRetriever {
    private static final Logger LOG = Logger.getInstance(JavaCompilerElementRetriever.class);
    private static final TokenSet FUN_EXPR = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.LAMBDA_EXPRESSION, JavaElementType.METHOD_REF_EXPRESSION});

    static PsiFunctionalExpression @NotNull [] retrieveFunExpressionsByIndices(@NotNull TIntHashSet indices2, @NotNull PsiFileWithStubSupport psiFile) {
        StubbedSpine spine = psiFile.getStubbedSpine();
        Object[] result = new PsiFunctionalExpression[indices2.size()];
        int resIdx = 0;
        int funExprIdx = 0;
        for (int i = 0; i < spine.getStubCount(); ++i) {
            if (!FUN_EXPR.contains(spine.getStubType(i)) || !indices2.contains(funExprIdx++)) continue;
            result[resIdx++] = (PsiFunctionalExpression)spine.getStubPsi(i);
        }
        if (result.length != resIdx) {
            CompilerReferenceServiceImpl compilerReferenceService = (CompilerReferenceServiceImpl)CompilerReferenceService.getInstance(psiFile.getProject());
            Set<Module> state = compilerReferenceService.getDirtyScopeHolder().getAllDirtyModules();
            VirtualFile file = psiFile.getVirtualFile();
            Module moduleForFile = ProjectFileIndex.getInstance((Project)psiFile.getProject()).getModuleForFile(file);
            LOG.error("Compiler functional expression index doesn't match to stub index.\nFunctional expression indices: " + indices2 + "\nDoes the file belong to dirty scope?: " + state.contains(moduleForFile), new Attachment[]{new Attachment(psiFile.getName(), psiFile.getText())});
            return ContainerUtil.filter((Object[])result, Objects::nonNull).toArray(PsiFunctionalExpression.EMPTY_ARRAY);
        }
        return result;
    }

    static PsiClass @NotNull [] retrieveClassesByInternalIds(SearchId @NotNull [] internalIds, @NotNull PsiFileWithStubSupport psiFile) {
        ClassMatcher matcher = ClassMatcher.create(internalIds);
        return (PsiClass[])ReadAction.compute(() -> matcher.retrieveClasses(psiFile));
    }

    private static class ClassMatcher {
        @Nullable
        private final TIntHashSet myAnonymousIndices;
        @NotNull
        private final Collection<? extends InternalNameMatcher> myClassNameMatchers;

        private ClassMatcher(@Nullable TIntHashSet anonymousIndices, @NotNull Collection<? extends InternalNameMatcher> nameMatchers) {
            this.myAnonymousIndices = anonymousIndices;
            this.myClassNameMatchers = nameMatchers;
        }

        private PsiClass[] retrieveClasses(PsiFileWithStubSupport file) {
            StubbedSpine spine = file.getStubbedSpine();
            ArrayList<PsiClass> result = new ArrayList<PsiClass>(this.myClassNameMatchers.size() + (this.myAnonymousIndices == null ? 0 : this.myAnonymousIndices.size()));
            int anonymousId = 0;
            for (int i = 0; i < spine.getStubCount(); ++i) {
                if (!Constants.CLASS_BIT_SET.contains(spine.getStubType(i))) continue;
                PsiClass element = (PsiClass)spine.getStubPsi(i);
                if (element instanceof PsiAnonymousClass) {
                    if (this.myAnonymousIndices == null || this.myAnonymousIndices.isEmpty()) continue;
                    if (this.myAnonymousIndices.contains(anonymousId)) {
                        result.add(element);
                    }
                    ++anonymousId;
                    continue;
                }
                if (!ClassMatcher.match(element, this.myClassNameMatchers)) continue;
                result.add(element);
            }
            return result.toArray(PsiClass.EMPTY_ARRAY);
        }

        private static boolean match(PsiClass psiClass, Collection<? extends InternalNameMatcher> matchers) {
            for (InternalNameMatcher internalNameMatcher : matchers) {
                if (!internalNameMatcher.matches(psiClass)) continue;
                if (internalNameMatcher instanceof InternalNameMatcher.ByQualifiedName) {
                    matchers.remove(internalNameMatcher);
                }
                return true;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        private static ClassMatcher create(SearchId @NotNull [] internalIds) {
            SmartList nameMatchers = new SmartList();
            TIntHashSet anonymousIndices = null;
            SearchId[] searchIdArray = internalIds;
            int n = searchIdArray.length;
            int n2 = 0;
            while (n2 < n) {
                SearchId internalId = searchIdArray[n2];
                if (internalId.getId() != -1) {
                    if (anonymousIndices == null) {
                        anonymousIndices = new TIntHashSet();
                    }
                    anonymousIndices.add(internalId.getId());
                } else {
                    String internalName = internalId.getDeserializedName();
                    int curLast = internalName.length() - 1;
                    while (true) {
                        int lastIndex;
                        if ((lastIndex = internalName.lastIndexOf(36, curLast)) > -1 && lastIndex < internalName.length() - 1) {
                            int followingIndex = lastIndex + 1;
                            boolean digit = Character.isDigit(internalName.charAt(followingIndex));
                            if (digit) {
                                if (curLast == internalName.length() - 1) {
                                    int nextNonDigit = ClassMatcher.getNextNonDigitIndex(internalName, followingIndex);
                                    if (nextNonDigit == -1) {
                                        throw new IllegalStateException();
                                    }
                                    nameMatchers.add(new InternalNameMatcher.ByName(internalName.substring(nextNonDigit)));
                                } else {
                                    nameMatchers.add(new InternalNameMatcher.ByName(StringUtil.getShortName((String)internalName, (char)'$')));
                                    break;
                                }
                            }
                        } else {
                            nameMatchers.add(new InternalNameMatcher.ByQualifiedName(StringUtil.replace((String)internalName, (String)"$", (String)".")));
                            break;
                        }
                        curLast = lastIndex - 1;
                    }
                }
                ++n2;
            }
            return new ClassMatcher(anonymousIndices, (Collection<? extends InternalNameMatcher>)nameMatchers);
        }

        private static int getNextNonDigitIndex(String name2, int digitIndex) {
            for (int i = digitIndex + 1; i < name2.length(); ++i) {
                if (Character.isDigit(name2.charAt(i))) continue;
                return i;
            }
            return -1;
        }
    }

    private static interface InternalNameMatcher {
        public boolean matches(PsiClass var1);

        public static class ByQualifiedName
        implements InternalNameMatcher {
            private final String myQName;

            public ByQualifiedName(String name2) {
                this.myQName = name2;
            }

            @Override
            public boolean matches(PsiClass psiClass) {
                return this.myQName.equals(psiClass.getQualifiedName());
            }
        }

        public static class ByName
        implements InternalNameMatcher {
            private final String myName;

            public ByName(String name2) {
                this.myName = name2;
            }

            @Override
            public boolean matches(PsiClass psiClass) {
                return this.myName.equals(psiClass.getName());
            }
        }
    }
}

