/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.backwardRefs.CompilerHierarchySearchType;
import com.intellij.compiler.backwardRefs.CompilerReferenceReader;
import com.intellij.compiler.backwardRefs.CompilerReferenceReaderFactory;
import com.intellij.compiler.backwardRefs.LanguageCompilerRefAdapter;
import com.intellij.compiler.backwardRefs.OccurrenceCounter;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Queue;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.InvertedIndexUtil;
import com.intellij.util.indexing.StorageException;
import gnu.trove.THashSet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.CompilerRef;
import org.jetbrains.jps.backwardRefs.JavaCompilerBackwardReferenceIndex;
import org.jetbrains.jps.backwardRefs.SignatureData;
import org.jetbrains.jps.backwardRefs.index.CompilerReferenceIndex;
import org.jetbrains.jps.backwardRefs.index.JavaCompilerIndices;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;

public final class JavaBackwardReferenceIndexReaderFactory
implements CompilerReferenceReaderFactory<BackwardReferenceReader> {
    public static final JavaBackwardReferenceIndexReaderFactory INSTANCE = new JavaBackwardReferenceIndexReaderFactory();
    private static final Logger LOG = Logger.getInstance(JavaBackwardReferenceIndexReaderFactory.class);

    @Override
    public int expectedIndexVersion() {
        return 7;
    }

    @Override
    @Nullable
    public BackwardReferenceReader create(Project project) {
        File buildDir = BuildManager.getInstance().getProjectSystemDirectory(project);
        if (buildDir == null || !CompilerReferenceIndex.exists((File)buildDir) || CompilerReferenceIndex.versionDiffers((File)buildDir, (int)this.expectedIndexVersion())) {
            return null;
        }
        try {
            return new BackwardReferenceReader(project, buildDir);
        }
        catch (RuntimeException e) {
            LOG.error("An exception while initialization of compiler reference index.", (Throwable)e);
            return null;
        }
    }

    public static class BackwardReferenceReader
    extends CompilerReferenceReader<JavaCompilerBackwardReferenceIndex> {
        protected BackwardReferenceReader(Project project, File buildDir) {
            super(buildDir, new JavaCompilerBackwardReferenceIndex(buildDir, new PathRelativizerService(project.getBasePath()), true));
        }

        @Override
        @Nullable
        public IntSet findReferentFileIds(@NotNull CompilerRef ref, boolean checkBaseClassAmbiguity) throws StorageException {
            CompilerRef.NamedCompilerRef[] hierarchy;
            if (ref instanceof CompilerRef.CompilerClassHierarchyElementDef) {
                hierarchy = new CompilerRef.NamedCompilerRef[]{(CompilerRef.NamedCompilerRef)ref};
            } else {
                CompilerRef.CompilerClassHierarchyElementDef hierarchyElement = ((CompilerRef.CompilerMember)ref).getOwner();
                hierarchy = this.getHierarchy(hierarchyElement, checkBaseClassAmbiguity, false, -1);
            }
            if (hierarchy == null) {
                return null;
            }
            IntOpenHashSet set = new IntOpenHashSet();
            for (CompilerRef.NamedCompilerRef aClass : hierarchy) {
                CompilerRef overriderUsage = ref.override(aClass.getName());
                this.addUsages(overriderUsage, (IntCollection)set);
            }
            return set;
        }

        @Override
        @Nullable
        public IntSet findFileIdsWithImplicitToString(@NotNull CompilerRef ref) throws StorageException {
            IntOpenHashSet result = new IntOpenHashSet();
            ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.IMPLICIT_TO_STRING).getData((Object)ref).forEach((arg_0, arg_1) -> this.lambda$findFileIdsWithImplicitToString$0((IntSet)result, arg_0, arg_1));
            return result;
        }

        @Override
        @NotNull
        public Map<VirtualFile, SearchId[]> getDirectInheritors(@NotNull CompilerRef searchElement, @NotNull GlobalSearchScope searchScope, @NotNull GlobalSearchScope dirtyScope, @NotNull FileType fileType, @NotNull CompilerHierarchySearchType searchType) throws StorageException {
            GlobalSearchScope effectiveSearchScope = GlobalSearchScope.notScope((GlobalSearchScope)dirtyScope).intersectWith(searchScope);
            LanguageCompilerRefAdapter adapter = LanguageCompilerRefAdapter.findAdapter(fileType);
            LOG.assertTrue(adapter != null, (Object)("adapter is null for file type: " + fileType));
            Class<? extends CompilerRef> requiredCompilerRefClass = searchType.getRequiredClass(adapter);
            HashMap candidatesPerFile = new HashMap();
            ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_HIERARCHY).getData((Object)searchElement).forEach((fileId, defs) -> {
                List requiredCandidates = ContainerUtil.filter((Collection)defs, requiredCompilerRefClass::isInstance);
                if (requiredCandidates.isEmpty()) {
                    return true;
                }
                VirtualFile file = this.findFile(fileId);
                if (file != null && effectiveSearchScope.contains(file)) {
                    candidatesPerFile.put(file, searchType.convertToIds(requiredCandidates, ((JavaCompilerBackwardReferenceIndex)this.myIndex).getByteSeqEum()));
                }
                return true;
            });
            return candidatesPerFile.isEmpty() ? Collections.emptyMap() : candidatesPerFile;
        }

        @Override
        @Nullable
        public Integer getAnonymousCount(@NotNull CompilerRef.CompilerClassHierarchyElementDef classDef, boolean checkDefinitions) {
            try {
                if (checkDefinitions && this.getDefinitionCount((CompilerRef)classDef) != DefCount.ONE) {
                    return null;
                }
                int[] count = new int[]{0};
                ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_HIERARCHY).getData((Object)classDef).forEach((id, value2) -> {
                    count[0] = count[0] + value2.size();
                    return true;
                });
                return count[0];
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int getOccurrenceCount(@NotNull CompilerRef element) {
            try {
                int[] result = new int[]{0};
                ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_USAGES).getData((Object)element).forEach((id, value2) -> {
                    result[0] = result[0] + value2;
                    return true;
                });
                return result[0];
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
        }

        @NotNull
        List<CompilerRef> getMembersFor(@NotNull SignatureData data) {
            try {
                ArrayList<CompilerRef> result = new ArrayList<CompilerRef>();
                ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_MEMBER_SIGN).getData((Object)data).forEach((id, refs) -> {
                    result.addAll((Collection<CompilerRef>)refs);
                    return true;
                });
                return result;
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
        }

        @NotNull
        IntSet getAllContainingFileIds(@NotNull CompilerRef ref) throws StorageException {
            return InvertedIndexUtil.collectInputIdsContainingAllKeys((InvertedIndex)((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_USAGES), Collections.singletonList(ref), null, null, null);
        }

        @NotNull
        OccurrenceCounter<CompilerRef> getTypeCastOperands(@NotNull CompilerRef castType, @Nullable IntCollection fileIds) throws StorageException {
            OccurrenceCounter<CompilerRef> result = new OccurrenceCounter<CompilerRef>();
            ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_CAST).getData((Object)castType).forEach((id, values) -> {
                if (fileIds != null && !fileIds.contains(id)) {
                    return true;
                }
                for (CompilerRef ref : values) {
                    result.add(ref);
                }
                return true;
            });
            return result;
        }

        private void addUsages(CompilerRef usage, IntCollection sink) throws StorageException {
            ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_USAGES).getData((Object)usage).forEach((id, value2) -> {
                VirtualFile file = this.findFile(id);
                if (file != null) {
                    sink.add(((VirtualFileWithId)file).getId());
                }
                return true;
            });
        }

        private VirtualFile findFile(int id) {
            try {
                String path = ((JavaCompilerBackwardReferenceIndex)this.myIndex).getFilePathEnumerator().valueOf(id);
                assert (path != null);
                return VfsUtil.findFileByIoFile((File)new File(path), (boolean)false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
        CompilerRef.CompilerClassHierarchyElementDef @Nullable(value="return null if the class hierarchy contains ambiguous qualified names") [] getHierarchy(CompilerRef.CompilerClassHierarchyElementDef hierarchyElement, boolean checkBaseClassAmbiguity, boolean includeAnonymous, int interruptNumber) {
            try {
                THashSet result = new THashSet();
                Queue q = new Queue(10);
                q.addLast((Object)hierarchyElement);
                while (!q.isEmpty()) {
                    CompilerRef.CompilerClassHierarchyElementDef curClass = (CompilerRef.CompilerClassHierarchyElementDef)q.pullFirst();
                    if (interruptNumber != -1 && result.size() > interruptNumber) break;
                    if (!result.add(curClass)) continue;
                    if (result.size() % 100 == 0) {
                        ProgressManager.checkCanceled();
                    }
                    if (!(curClass instanceof CompilerRef.CompilerAnonymousClassDef) && (checkBaseClassAmbiguity || curClass != hierarchyElement) && this.hasMultipleDefinitions((CompilerRef.NamedCompilerRef)curClass)) {
                        return null;
                    }
                    ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_HIERARCHY).getData((Object)curClass).forEach((id, children) -> {
                        for (CompilerRef child : children) {
                            if (!(child instanceof CompilerRef.CompilerClassHierarchyElementDef) || !includeAnonymous && child instanceof CompilerRef.CompilerAnonymousClassDef) continue;
                            q.addLast((Object)((CompilerRef.CompilerClassHierarchyElementDef)child));
                        }
                        return true;
                    });
                }
                return result.toArray(CompilerRef.CompilerClassHierarchyElementDef.EMPTY_ARRAY);
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
        }

        // Could not load outer class - annotation placement on inner may be incorrect
        CompilerRef.CompilerClassHierarchyElementDef @NotNull [] getDirectInheritors(CompilerRef hierarchyElement) throws StorageException {
            THashSet result = new THashSet();
            ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_HIERARCHY).getData((Object)hierarchyElement).forEach((arg_0, arg_1) -> BackwardReferenceReader.lambda$getDirectInheritors$8((Set)result, arg_0, arg_1));
            return result.toArray(CompilerRef.CompilerClassHierarchyElementDef.EMPTY_ARRAY);
        }

        private boolean hasMultipleDefinitions(CompilerRef.NamedCompilerRef def) throws StorageException {
            DefCount count = this.getDefinitionCount((CompilerRef)def);
            if (count == DefCount.NONE) {
                String name2 = def instanceof CompilerRef.CompilerAnonymousClassDef ? String.valueOf(def.getName()) : this.getNameEnumerator().getName(def.getName());
                LOG.error("Can't get definition files for: " + name2 + ", class: " + def.getClass());
            }
            return count == DefCount.MANY;
        }

        @NotNull
        private DefCount getDefinitionCount(CompilerRef def) throws StorageException {
            DefCount[] result = new DefCount[]{DefCount.NONE};
            ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_CLASS_DEF).getData((Object)def).forEach((id, value2) -> {
                if (result[0] == DefCount.NONE) {
                    result[0] = DefCount.ONE;
                    return true;
                }
                if (result[0] == DefCount.ONE) {
                    result[0] = DefCount.MANY;
                    return true;
                }
                return false;
            });
            return result[0];
        }

        private static /* synthetic */ boolean lambda$getDirectInheritors$8(Set result, int id, Collection children) {
            for (CompilerRef child : children) {
                if (!(child instanceof CompilerRef.CompilerClassHierarchyElementDef) || child instanceof CompilerRef.CompilerAnonymousClassDef) continue;
                result.add((CompilerRef.CompilerClassHierarchyElementDef)child);
            }
            return true;
        }

        private /* synthetic */ boolean lambda$findFileIdsWithImplicitToString$0(IntSet result, int id, Void value2) {
            VirtualFile file = this.findFile(id);
            if (file != null) {
                result.add(((VirtualFileWithId)file).getId());
            }
            return true;
        }

        private static enum DefCount {
            NONE,
            ONE,
            MANY;

        }
    }
}

