/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unusedReturnValue;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.MakeVoidQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.deadCode.UnreferencedFilter;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefUtil;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.codeInspection.unusedReturnValue.UnusedReturnValueLocalInspection;
import com.intellij.codeInspection.unusedSymbol.VisibilityModifierChooser;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.Consumer;
import com.intellij.util.VisibilityUtil;
import java.util.Collections;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedReturnValue
extends GlobalJavaBatchInspectionTool {
    public boolean IGNORE_BUILDER_PATTERN;
    @PsiModifier.ModifierConstant
    public static final String DEFAULT_HIGHEST_MODIFIER = "public";
    @PsiModifier.ModifierConstant
    public String highestModifier = "public";

    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor2) {
        if (refEntity instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refEntity;
            if (VisibilityUtil.compare((String)refMethod.getAccessModifier(), (String)this.highestModifier) < 0 || refMethod.isConstructor() || !refMethod.getSuperMethods().isEmpty() || refMethod.getInReferences().isEmpty() || refMethod.isEntry() || refMethod.isReturnValueUsed() || UnreferencedFilter.isExternallyReferenced((RefElement)refMethod)) {
                return null;
            }
            PsiMethod psiMethod = (PsiMethod)refMethod.getUastElement().getJavaPsi();
            if (psiMethod == null) {
                return null;
            }
            if (this.IGNORE_BUILDER_PATTERN && PropertyUtilBase.isSimplePropertySetter((PsiMethod)psiMethod)) {
                return null;
            }
            boolean isNative = psiMethod.hasModifierProperty("native");
            if (refMethod.isExternalOverride() && !isNative) {
                return null;
            }
            if (RefUtil.isImplicitRead((PsiElement)psiMethod)) {
                return null;
            }
            if (UnusedReturnValue.canIgnoreReturnValue(psiMethod)) {
                return null;
            }
            return new ProblemDescriptor[]{UnusedReturnValue.createProblemDescriptor(psiMethod, manager, processor2, isNative, false)};
        }
        return null;
    }

    static boolean canIgnoreReturnValue(PsiMethod psiMethod) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, Collections.singleton("com.google.errorprone.annotations.CanIgnoreReturnValue"), (int)1);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (this.IGNORE_BUILDER_PATTERN || this.highestModifier != DEFAULT_HIGHEST_MODIFIER) {
            super.writeSettings(node);
        }
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(JavaBundle.message((String)"checkbox.ignore.simple.setters", (Object[])new Object[0]), "IGNORE_BUILDER_PATTERN");
        VisibilityModifierChooser modifierChooser = new VisibilityModifierChooser(() -> true, this.highestModifier, (Consumer<? super String>)((Consumer)newModifier -> {
            this.highestModifier = newModifier;
        }));
        panel2.addComponent((JComponent)LabeledComponent.create((JComponent)modifierChooser, (String)JavaBundle.message((String)"label.maximal.reported.method.visibility", (Object[])new Object[0]), (String)"West"));
        return panel2;
    }

    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor processor2) {
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity instanceof RefElement && processor2.getDescriptions(refEntity) != null) {
                    refEntity.accept((RefVisitor)new RefJavaVisitor(){

                        public void visitMethod(final @NotNull RefMethod refMethod) {
                            globalContext.enqueueMethodUsagesProcessor(refMethod, new GlobalJavaInspectionContext.UsagesProcessor(){

                                public boolean process(PsiReference psiReference) {
                                    processor2.ignoreElement((RefEntity)refMethod);
                                    return false;
                                }
                            });
                        }
                    });
                }
            }
        });
        return false;
    }

    @NotNull
    public String getGroupDisplayName() {
        return InspectionsBundle.message((String)"group.names.declaration.redundancy", (Object[])new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return "UnusedReturnValue";
    }

    @Nullable
    public QuickFix getQuickFix(String hint) {
        return new MakeVoidQuickFix(null);
    }

    @Nullable
    public LocalInspectionTool getSharedLocalInspectionTool() {
        return new UnusedReturnValueLocalInspection(this);
    }

    static ProblemDescriptor createProblemDescriptor(@NotNull PsiMethod psiMethod, @NotNull InspectionManager manager, @Nullable ProblemDescriptionsProcessor processor2, boolean isNative, boolean isOnTheFly) {
        return manager.createProblemDescriptor((PsiElement)psiMethod.getNameIdentifier(), JavaBundle.message((String)"inspection.unused.return.value.problem.descriptor", (Object[])new Object[0]), (LocalQuickFix)(isNative ? null : new MakeVoidQuickFix(processor2)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
    }
}

