/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unneededThrows;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodThrowsFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.unneededThrows.RedundantThrowsDeclarationInspection;
import com.intellij.codeInspection.unneededThrows.RedundantThrowsGraphAnnotator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntheticElement;
import com.siyeh.ig.JavaOverridingMethodUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantThrowsDeclarationLocalInspection
extends AbstractBaseJavaLocalInspectionTool {
    private final RedundantThrowsDeclarationInspection myGlobalTool;

    public RedundantThrowsDeclarationLocalInspection() {
        this(new RedundantThrowsDeclarationInspection());
    }

    public RedundantThrowsDeclarationLocalInspection(@NotNull RedundantThrowsDeclarationInspection tool) {
        this.myGlobalTool = tool;
    }

    @NotNull
    public String getGroupDisplayName() {
        return this.myGlobalTool.getGroupDisplayName();
    }

    @NotNull
    public String getShortName() {
        return this.myGlobalTool.getShortName();
    }

    public ProblemDescriptor @Nullable [] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        return this.checkExceptionsNeverThrown(method, manager);
    }

    private ProblemDescriptor @Nullable [] checkExceptionsNeverThrown(PsiMethod method, InspectionManager inspectionManager) {
        if (method instanceof SyntheticElement) {
            return null;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || JavaHighlightUtil.isSerializationRelatedMethod(method, containingClass)) {
            return null;
        }
        PsiCodeBlock body2 = method.getBody();
        if (body2 == null) {
            return null;
        }
        if (this.myGlobalTool.IGNORE_ENTRY_POINTS && UnusedDeclarationInspectionBase.isDeclaredAsEntryPoint((PsiElement)method)) {
            return null;
        }
        ReferenceAndType[] thrownExceptions = RedundantThrowsDeclarationLocalInspection.getThrownCheckedExceptions(method);
        if (thrownExceptions.length == 0) {
            return null;
        }
        PsiModifierList modifierList = method.getModifierList();
        boolean needCheckOverridingMethods = !modifierList.hasModifierProperty("private") && !modifierList.hasModifierProperty("static") && !modifierList.hasModifierProperty("final") && !method.isConstructor() && !(containingClass instanceof PsiAnonymousClass) && !containingClass.hasModifierProperty("final");
        Set<PsiClassType> unhandled = RedundantThrowsGraphAnnotator.getUnhandledExceptions(body2, method, containingClass);
        List candidates = Arrays.stream(thrownExceptions).filter(refAndType -> unhandled.stream().noneMatch(unhandledException -> unhandledException.isAssignableFrom((PsiType)((ReferenceAndType)refAndType).type) || ((ReferenceAndType)refAndType).type.isAssignableFrom((PsiType)unhandledException))).collect(Collectors.toList());
        if (candidates.isEmpty()) {
            return null;
        }
        if (needCheckOverridingMethods) {
            Predicate<PsiMethod> methodContainsThrownExceptions = m -> m.getThrowsList().getReferencedTypes().length != 0;
            Stream<PsiMethod> overridingMethods = JavaOverridingMethodUtil.getOverridingMethodsIfCheapEnough(method, null, methodContainsThrownExceptions);
            if (overridingMethods == null) {
                return null;
            }
            Iterator overridingMethodIt = overridingMethods.iterator();
            while (overridingMethodIt.hasNext()) {
                PsiMethod m2 = (PsiMethod)overridingMethodIt.next();
                PsiClassType[] overridingMethodThrownExceptions = m2.getThrowsList().getReferencedTypes();
                candidates.removeIf(refAndType -> {
                    PsiClassType type2 = ((ReferenceAndType)refAndType).type;
                    return Arrays.stream(overridingMethodThrownExceptions).anyMatch(arg_0 -> ((PsiClassType)type2).isAssignableFrom(arg_0));
                });
                if (!candidates.isEmpty()) continue;
                return null;
            }
        }
        return (ProblemDescriptor[])candidates.stream().map(exceptionType -> {
            PsiJavaCodeReferenceElement reference = ((ReferenceAndType)exceptionType).ref;
            String description = JavaErrorBundle.message("exception.is.never.thrown", JavaHighlightUtil.formatType((PsiType)((ReferenceAndType)exceptionType).type));
            MethodThrowsFix.Remove quickFix = new MethodThrowsFix.Remove(method, ((ReferenceAndType)exceptionType).type, false);
            return inspectionManager.createProblemDescriptor((PsiElement)reference, description, (LocalQuickFix)quickFix, ProblemHighlightType.LIKE_UNUSED_SYMBOL, true);
        }).toArray(ProblemDescriptor[]::new);
    }

    private static ReferenceAndType[] getThrownCheckedExceptions(PsiMethod method) {
        return (ReferenceAndType[])Stream.of(method.getThrowsList().getReferenceElements()).map(ref -> {
            PsiElement resolved = ref.resolve();
            return resolved instanceof PsiClass && !ExceptionUtil.isUncheckedException((PsiClass)resolved) ? new ReferenceAndType((PsiJavaCodeReferenceElement)ref) : null;
        }).filter(Objects::nonNull).toArray(ReferenceAndType[]::new);
    }

    private static class ReferenceAndType {
        private final PsiJavaCodeReferenceElement ref;
        private final PsiClassType type;

        private ReferenceAndType(@NotNull PsiJavaCodeReferenceElement ref) {
            this.ref = ref;
            this.type = JavaPsiFacade.getElementFactory((Project)ref.getProject()).createType(ref);
        }
    }
}

