/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.uncheckedWarnings;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.GenerifyFileFix;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableArrayTypeFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.quickfix.ChangeVariableTypeQuickFixProvider;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.intellij.lang.annotations.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UncheckedWarningLocalInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "UNCHECKED_WARNING";
    @NonNls
    private static final String ID = "unchecked";
    private static final Logger LOG = Logger.getInstance(UncheckedWarningLocalInspection.class);
    public boolean IGNORE_UNCHECKED_ASSIGNMENT;
    public boolean IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION;
    public boolean IGNORE_UNCHECKED_CALL;
    public boolean IGNORE_UNCHECKED_CAST;
    public boolean IGNORE_UNCHECKED_OVERRIDING;

    protected LocalQuickFix @NotNull [] createFixes() {
        return new LocalQuickFix[]{new GenerifyFileFix()};
    }

    public JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0);
        panel2.add((Component)UncheckedWarningLocalInspection.createSetting("Ignore unchecked assignment", this.IGNORE_UNCHECKED_ASSIGNMENT, (Pass<? super JCheckBox>)new Pass<JCheckBox>(){

            public void pass(JCheckBox cb) {
                UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_ASSIGNMENT = cb.isSelected();
            }
        }), gc);
        panel2.add((Component)UncheckedWarningLocalInspection.createSetting("Ignore unchecked generics array creation for vararg parameter", this.IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION, (Pass<? super JCheckBox>)new Pass<JCheckBox>(){

            public void pass(JCheckBox cb) {
                UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION = cb.isSelected();
            }
        }), gc);
        panel2.add((Component)UncheckedWarningLocalInspection.createSetting("Ignore unchecked call as member of raw type", this.IGNORE_UNCHECKED_CALL, (Pass<? super JCheckBox>)new Pass<JCheckBox>(){

            public void pass(JCheckBox cb) {
                UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_CALL = cb.isSelected();
            }
        }), gc);
        panel2.add((Component)UncheckedWarningLocalInspection.createSetting("Ignore unchecked cast", this.IGNORE_UNCHECKED_CAST, (Pass<? super JCheckBox>)new Pass<JCheckBox>(){

            public void pass(JCheckBox cb) {
                UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_CAST = cb.isSelected();
            }
        }), gc);
        panel2.add((Component)UncheckedWarningLocalInspection.createSetting("Ignore unchecked overriding", this.IGNORE_UNCHECKED_OVERRIDING, (Pass<? super JCheckBox>)new Pass<JCheckBox>(){

            public void pass(JCheckBox cb) {
                UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_OVERRIDING = cb.isSelected();
            }
        }), gc);
        gc.fill = 1;
        gc.weighty = 1.0;
        panel2.add((Component)Box.createVerticalBox(), gc);
        return panel2;
    }

    @NotNull
    static JCheckBox createSetting(@NotNull String cbText, boolean option, @NotNull Pass<? super JCheckBox> pass) {
        JCheckBox uncheckedCb = new JCheckBox(cbText, option);
        uncheckedCb.addActionListener(e -> pass.pass((Object)uncheckedCb));
        return uncheckedCb;
    }

    private static LocalQuickFix @NotNull [] getChangeVariableTypeFixes(@NotNull PsiVariable parameter2, @Nullable PsiType itemType, LocalQuickFix[] generifyFixes) {
        if (itemType instanceof PsiMethodReferenceType) {
            return generifyFixes;
        }
        LOG.assertTrue(parameter2.isValid());
        ArrayList<LocalQuickFix> result = new ArrayList<LocalQuickFix>();
        if (itemType != null) {
            for (ChangeVariableTypeQuickFixProvider fixProvider : ChangeVariableTypeQuickFixProvider.EP_NAME.getExtensionList()) {
                for (IntentionAction action : fixProvider.getFixes(parameter2, itemType)) {
                    if (!(action instanceof LocalQuickFix)) continue;
                    result.add((LocalQuickFix)action);
                }
            }
        }
        if (generifyFixes.length > 0) {
            Collections.addAll(result, generifyFixes);
        }
        return result.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    @NotNull
    public String getGroupDisplayName() {
        return "";
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return SHORT_NAME;
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    @NonNls
    public String getID() {
        return ID;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (this.IGNORE_UNCHECKED_ASSIGNMENT || this.IGNORE_UNCHECKED_CALL || this.IGNORE_UNCHECKED_CAST || this.IGNORE_UNCHECKED_OVERRIDING || this.IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION) {
            super.writeSettings(node);
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)session.getFile());
        if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
            return super.buildVisitor(holder, isOnTheFly, session);
        }
        return new UncheckedWarningsVisitor(isOnTheFly, languageLevel){

            @Override
            protected void registerProblem(@NotNull String message2, @Nullable PsiElement callExpression, @NotNull PsiElement psiElement, LocalQuickFix @NotNull [] quickFixes) {
                String rawExpression = UncheckedWarningLocalInspection.isMethodCalledOnRawType(callExpression);
                if (rawExpression != null) {
                    String referenceName = ((PsiMethodCallExpression)callExpression).getMethodExpression().getReferenceName();
                    message2 = message2 + ". Reason: '" + rawExpression + "' has raw type, so result of " + referenceName + " is erased";
                }
                PsiJavaCodeReferenceElement element2Highlight = null;
                if (psiElement instanceof PsiNewExpression) {
                    element2Highlight = ((PsiNewExpression)psiElement).getClassOrAnonymousClassReference();
                } else if (psiElement instanceof PsiMethodCallExpression) {
                    element2Highlight = ((PsiMethodCallExpression)psiElement).getMethodExpression();
                }
                holder.registerProblem((PsiElement)ObjectUtils.notNull((Object)element2Highlight, (Object)psiElement), message2, quickFixes);
            }
        };
    }

    private static String isMethodCalledOnRawType(PsiElement expression2) {
        PsiClass qualifierClass;
        PsiExpression qualifierExpression2;
        if (expression2 instanceof PsiMethodCallExpression && (qualifierExpression2 = ((PsiMethodCallExpression)expression2).getMethodExpression().getQualifierExpression()) != null && (qualifierClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifierExpression2.getType())) != null && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)qualifierClass, (PsiSubstitutor)((PsiMethodCallExpression)expression2).resolveMethodGenerics().getSubstitutor())) {
            return qualifierExpression2.getText();
        }
        return null;
    }

    private abstract class UncheckedWarningsVisitor
    extends JavaElementVisitor {
        private final boolean myOnTheFly;
        @NotNull
        private final LanguageLevel myLanguageLevel;
        private final LocalQuickFix[] myGenerifyFixes;

        UncheckedWarningsVisitor(@NotNull boolean onTheFly, LanguageLevel level) {
            this.myOnTheFly = onTheFly;
            this.myLanguageLevel = level;
            this.myGenerifyFixes = onTheFly ? UncheckedWarningLocalInspection.this.createFixes() : LocalQuickFix.EMPTY_ARRAY;
        }

        protected abstract void registerProblem(@NotNull String var1, PsiElement var2, @NotNull PsiElement var3, LocalQuickFix @NotNull [] var4);

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION) {
                return;
            }
            JavaResolveResult result = expression2.advancedResolve(false);
            if (JavaGenericsUtil.isUncheckedWarning((PsiJavaCodeReferenceElement)expression2, (JavaResolveResult)result, (LanguageLevel)this.myLanguageLevel)) {
                this.registerProblem("Unchecked generics array creation for varargs parameter", null, (PsiElement)expression2, LocalQuickFix.EMPTY_ARRAY);
            }
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION) {
                return;
            }
            PsiJavaCodeReferenceElement classReference2 = expression2.getClassOrAnonymousClassReference();
            if (classReference2 != null && JavaGenericsUtil.isUncheckedWarning((PsiJavaCodeReferenceElement)classReference2, (JavaResolveResult)expression2.resolveMethodGenerics(), (LanguageLevel)this.myLanguageLevel)) {
                this.registerProblem("Unchecked generics array creation for varargs parameter", (PsiElement)expression2, (PsiElement)classReference2, LocalQuickFix.EMPTY_ARRAY);
            }
        }

        public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
            super.visitTypeCastExpression(expression2);
            if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_CAST) {
                return;
            }
            PsiTypeElement typeElement = expression2.getCastType();
            if (typeElement == null) {
                return;
            }
            PsiType castType = typeElement.getType();
            PsiExpression operand2 = expression2.getOperand();
            if (operand2 == null) {
                return;
            }
            PsiType exprType = operand2.getType();
            if (exprType == null) {
                return;
            }
            if (!TypeConversionUtil.areTypesConvertible((PsiType)exprType, (PsiType)castType)) {
                return;
            }
            if (JavaGenericsUtil.isUncheckedCast((PsiType)castType, (PsiType)exprType)) {
                String description = JavaErrorBundle.message("generics.unchecked.cast", JavaHighlightUtil.formatType(exprType), JavaHighlightUtil.formatType(castType));
                this.registerProblem(description, (PsiElement)operand2, (PsiElement)expression2, this.myGenerifyFixes);
            }
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
            super.visitMethodReferenceExpression(expression2);
            if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_CALL) {
                return;
            }
            JavaResolveResult result = expression2.advancedResolve(false);
            String description = this.getUncheckedCallDescription((PsiElement)expression2, result);
            if (description != null) {
                PsiElement referenceNameElement2 = expression2.getReferenceNameElement();
                this.registerProblem(description, (PsiElement)expression2, (PsiElement)(referenceNameElement2 != null ? referenceNameElement2 : expression2), this.myGenerifyFixes);
            }
        }

        public void visitCallExpression(PsiCallExpression callExpression) {
            super.visitCallExpression(callExpression);
            JavaResolveResult result = callExpression.resolveMethodGenerics();
            String description = this.getUncheckedCallDescription((PsiElement)callExpression, result);
            if (description != null) {
                if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_CALL) {
                    return;
                }
                this.registerProblem(description, null, (PsiElement)callExpression, this.myGenerifyFixes);
            } else {
                PsiMethod method;
                if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                    return;
                }
                PsiSubstitutor substitutor = result.getSubstitutor();
                PsiExpressionList argumentList = callExpression.getArgumentList();
                if (argumentList != null && (method = (PsiMethod)result.getElement()) != null) {
                    PsiExpression[] expressions2 = argumentList.getExpressions();
                    PsiParameter[] parameters2 = method.getParameterList().getParameters();
                    if (parameters2.length != 0) {
                        for (int i = 0; i < expressions2.length; ++i) {
                            PsiParameter parameter2 = parameters2[Math.min(i, parameters2.length - 1)];
                            PsiExpression expression2 = expressions2[i];
                            PsiType parameterType = substitutor.substitute(parameter2.getType());
                            PsiType expressionType = expression2.getType();
                            if (expressionType == null) continue;
                            this.checkRawToGenericsAssignment((PsiElement)expression2, expression2, parameterType, expressionType, () -> this.myGenerifyFixes);
                        }
                    }
                }
            }
        }

        public void visitVariable(PsiVariable variable) {
            super.visitVariable(variable);
            if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null || initializer instanceof PsiArrayInitializerExpression) {
                return;
            }
            PsiType initializerType = initializer.getType();
            this.checkRawToGenericsAssignment((PsiElement)initializer, initializer, variable.getType(), initializerType, () -> this.myOnTheFly ? UncheckedWarningLocalInspection.getChangeVariableTypeFixes(variable, initializerType, this.myGenerifyFixes) : LocalQuickFix.EMPTY_ARRAY);
        }

        public void visitForeachStatement(PsiForeachStatement statement) {
            super.visitForeachStatement(statement);
            if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiParameter parameter2 = statement.getIterationParameter();
            PsiType parameterType = parameter2.getType();
            PsiExpression iteratedValue2 = statement.getIteratedValue();
            if (iteratedValue2 == null) {
                return;
            }
            PsiType itemType = JavaGenericsUtil.getCollectionItemType((PsiExpression)iteratedValue2);
            this.checkRawToGenericsAssignment((PsiElement)parameter2, iteratedValue2, parameterType, itemType, () -> this.myOnTheFly ? UncheckedWarningLocalInspection.getChangeVariableTypeFixes((PsiVariable)parameter2, itemType, this.myGenerifyFixes) : LocalQuickFix.EMPTY_ARRAY);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            super.visitAssignmentExpression(expression2);
            if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            if (!"=".equals(expression2.getOperationSign().getText())) {
                return;
            }
            PsiExpression lExpr = expression2.getLExpression();
            PsiExpression rExpr = expression2.getRExpression();
            if (rExpr == null) {
                return;
            }
            PsiType lType = lExpr.getType();
            PsiType rType = rExpr.getType();
            if (rType == null) {
                return;
            }
            this.checkRawToGenericsAssignment((PsiElement)rExpr, rExpr, lType, rType, () -> {
                PsiElement element;
                if (this.myOnTheFly && lExpr instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)lExpr).resolve()) instanceof PsiVariable) {
                    return UncheckedWarningLocalInspection.getChangeVariableTypeFixes((PsiVariable)element, rType, this.myGenerifyFixes);
                }
                return LocalQuickFix.EMPTY_ARRAY;
            });
        }

        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            super.visitConditionalExpression(expression2);
            if (PsiUtil.isLanguageLevel8OrHigher((PsiElement)expression2) && PsiPolyExpressionUtil.isPolyExpression((PsiExpression)expression2)) {
                PsiType targetType = expression2.getType();
                if (targetType == null) {
                    return;
                }
                this.processConditionalPart(targetType, expression2.getThenExpression());
                this.processConditionalPart(targetType, expression2.getElseExpression());
            }
        }

        private void processConditionalPart(PsiType targetType, PsiExpression thenExpression2) {
            PsiType thenType;
            if (thenExpression2 != null && (thenType = thenExpression2.getType()) != null) {
                this.checkRawToGenericsAssignment((PsiElement)thenExpression2, thenExpression2, targetType, thenType, () -> this.myOnTheFly ? this.myGenerifyFixes : LocalQuickFix.EMPTY_ARRAY);
            }
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression arrayInitializer) {
            PsiExpression[] initializers;
            super.visitArrayInitializerExpression(arrayInitializer);
            if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiType type2 = arrayInitializer.getType();
            if (!(type2 instanceof PsiArrayType)) {
                return;
            }
            PsiType componentType = ((PsiArrayType)type2).getComponentType();
            boolean arrayTypeFixChecked = false;
            VariableArrayTypeFix fix = null;
            for (PsiExpression expression2 : initializers = arrayInitializer.getInitializers()) {
                PsiType itemType = expression2.getType();
                if (itemType == null || !TypeConversionUtil.isAssignable((PsiType)componentType, (PsiType)itemType) || !JavaGenericsUtil.isRawToGeneric((PsiType)componentType, (PsiType)itemType)) continue;
                String description = JavaErrorBundle.message("generics.unchecked.assignment", itemType.getCanonicalText(), componentType.getCanonicalText());
                if (!arrayTypeFixChecked) {
                    PsiType checkResult = JavaHighlightUtil.sameType(initializers);
                    fix = checkResult != null ? VariableArrayTypeFix.createFix(arrayInitializer, checkResult) : null;
                    arrayTypeFixChecked = true;
                }
                if (fix == null) continue;
                this.registerProblem(description, null, (PsiElement)expression2, new LocalQuickFix[]{fix});
            }
        }

        private void checkRawToGenericsAssignment(@NotNull PsiElement parameter2, PsiExpression expression2, PsiType parameterType, PsiType itemType, Supplier<LocalQuickFix[]> fixesSupplier) {
            if (parameterType == null || itemType == null) {
                return;
            }
            if (!TypeConversionUtil.isAssignable((PsiType)parameterType, (PsiType)itemType)) {
                return;
            }
            if (JavaGenericsUtil.isRawToGeneric((PsiType)parameterType, (PsiType)itemType)) {
                String description = JavaErrorBundle.message("generics.unchecked.assignment", itemType.getCanonicalText(), parameterType.getCanonicalText());
                this.registerProblem(description, (PsiElement)expression2, parameter2, fixesSupplier.get());
            }
        }

        public void visitMethod(PsiMethod method) {
            List superMethodSignatures;
            super.visitMethod(method);
            if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_OVERRIDING) {
                return;
            }
            if (!(method.isConstructor() || (superMethodSignatures = method.getHierarchicalMethodSignature().getSuperSignatures()).isEmpty() || method.hasModifierProperty("static"))) {
                MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
                for (MethodSignatureBackedByPsiMethod superSignature : superMethodSignatures) {
                    PsiMethod baseMethod = superSignature.getMethod();
                    PsiSubstitutor substitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)signature, (MethodSignature)superSignature);
                    if (substitutor == null) {
                        substitutor = superSignature.getSubstitutor();
                    }
                    if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)baseMethod, (PsiSubstitutor)superSignature.getSubstitutor())) continue;
                    PsiType baseReturnType = substitutor.substitute(baseMethod.getReturnType());
                    PsiType overriderReturnType = method.getReturnType();
                    if (baseReturnType == null || overriderReturnType == null) {
                        return;
                    }
                    if (!JavaGenericsUtil.isRawToGeneric((PsiType)baseReturnType, (PsiType)overriderReturnType)) continue;
                    String message2 = JavaErrorBundle.message("unchecked.overriding.incompatible.return.type", JavaHighlightUtil.formatType(overriderReturnType), JavaHighlightUtil.formatType(baseReturnType));
                    PsiTypeElement returnTypeElement = method.getReturnTypeElement();
                    LOG.assertTrue(returnTypeElement != null);
                    this.registerProblem(message2, null, (PsiElement)returnTypeElement, LocalQuickFix.EMPTY_ARRAY);
                }
            }
        }

        public void visitReturnStatement(PsiReturnStatement statement) {
            PsiType valueType;
            PsiExpression returnValue;
            super.visitReturnStatement(statement);
            if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiType returnType = PsiTypesUtil.getMethodReturnType((PsiElement)statement);
            if (returnType != null && !PsiType.VOID.equals((Object)returnType) && (returnValue = statement.getReturnValue()) != null && (valueType = returnValue.getType()) != null) {
                this.checkRawToGenericsAssignment((PsiElement)returnValue, returnValue, returnType, valueType, () -> {
                    LocalQuickFix[] localQuickFixArray;
                    PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
                    if (psiElement instanceof PsiMethod) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[0] = QuickFixFactory.getInstance().createMethodReturnFix((PsiMethod)psiElement, valueType, true);
                    } else {
                        localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                    }
                    return localQuickFixArray;
                });
            }
        }

        public void visitLambdaExpression(PsiLambdaExpression expression2) {
            PsiType type2;
            PsiType interfaceReturnType;
            super.visitLambdaExpression(expression2);
            if (UncheckedWarningLocalInspection.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiElement body2 = expression2.getBody();
            if (body2 instanceof PsiExpression && (interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)expression2)) != null && !PsiType.VOID.equals((Object)interfaceReturnType) && (type2 = ((PsiExpression)body2).getType()) != null) {
                this.checkRawToGenericsAssignment(body2, (PsiExpression)body2, interfaceReturnType, type2, () -> LocalQuickFix.EMPTY_ARRAY);
            }
        }

        @Nullable
        private String getUncheckedCallDescription(PsiElement place, JavaResolveResult resolveResult) {
            PsiElement element = resolveResult.getElement();
            if (!(element instanceof PsiMethod)) {
                return null;
            }
            PsiMethod method = (PsiMethod)element;
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            if (!PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)method, (PsiSubstitutor)substitutor)) {
                if (JavaVersionService.getInstance().isAtLeast(place, JavaSdkVersion.JDK_1_8)) {
                    for (PsiTypeParameter parameter2 : method.getTypeParameters()) {
                        PsiClassType[] extendsListTypes = parameter2.getExtendsListTypes();
                        if (extendsListTypes.length <= 0) continue;
                        PsiType subst = substitutor.substitute(parameter2);
                        for (PsiClassType classType : extendsListTypes) {
                            if (!JavaGenericsUtil.isRawToGeneric((PsiType)substitutor.substitute((PsiType)classType), (PsiType)subst)) continue;
                            return JavaErrorBundle.message("generics.unchecked.call", JavaHighlightUtil.formatMethod(method));
                        }
                    }
                }
                return null;
            }
            if (PsiTypesUtil.isUncheckedCall((JavaResolveResult)resolveResult)) {
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)method.getProject());
                PsiClassType type2 = elementFactory.createType(method.getContainingClass(), substitutor);
                return JavaErrorBundle.message("generics.unchecked.call.to.member.of.raw.type", JavaHighlightUtil.formatMethod(method), JavaHighlightUtil.formatType((PsiType)type2));
            }
            return null;
        }
    }
}

