/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefFieldImpl;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaModule;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefProject;
import com.intellij.codeInspection.reference.WritableRefElement;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.VisibilityUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UEnumConstant;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPostfixExpression;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastOperator;
import org.jetbrains.uast.UastPostfixOperator;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class RefJavaUtilImpl
extends RefJavaUtil {
    private static final Logger LOG = Logger.getInstance(RefJavaUtilImpl.class);

    public void addReferences(@NotNull PsiModifierListOwner psiFrom, @NotNull RefJavaElement ref, @Nullable PsiElement findIn) {
        UDeclaration decl = (UDeclaration)UastContextKt.toUElement((PsiElement)psiFrom, UDeclaration.class);
        UElement uFindIn = UastContextKt.toUElement((PsiElement)findIn);
        if (decl != null && findIn != null) {
            this.addReferencesTo(decl, ref, new UElement[]{uFindIn});
        }
    }

    public void addReferencesTo(final @NotNull UDeclaration decl, @NotNull RefJavaElement ref, UElement @Nullable [] findIn) {
        final RefJavaElementImpl refFrom = (RefJavaElementImpl)ref;
        if (findIn == null) {
            return;
        }
        for (UElement element : findIn) {
            if (element == null) continue;
            element.accept((UastVisitor)new AbstractUastVisitor(){

                public boolean visitEnumConstant(@NotNull UEnumConstant node) {
                    this.processNewLikeConstruct(node.resolve(), node.getValueArguments());
                    return false;
                }

                public boolean visitAnnotation(@NotNull UAnnotation node) {
                    PsiClass javaClass = node.resolve();
                    if (javaClass != null) {
                        RefClassImpl refClass = (RefClassImpl)refFrom.getRefManager().getReference(javaClass.getOriginalElement());
                        refFrom.addReference((RefElement)refClass, javaClass.getOriginalElement(), decl, false, true, null);
                    }
                    return false;
                }

                public boolean visitTypeReferenceExpression(@NotNull UTypeReferenceExpression node) {
                    PsiType type2 = node.getType();
                    this.visitTypeRefs(type2);
                    return false;
                }

                private void visitTypeRefs(PsiType type2) {
                    if ((type2 = type2.getDeepComponentType()) instanceof PsiClassType) {
                        type2.accept((PsiTypeVisitor)new PsiTypeVisitor<Void>(){

                            public Void visitClassType(@NotNull PsiClassType classType) {
                                for (PsiType parameter2 : classType.getParameters()) {
                                    parameter2.accept((PsiTypeVisitor)this);
                                }
                                UClass target = (UClass)UastContextKt.toUElement((PsiElement)classType.resolve(), UClass.class);
                                if (target != null) {
                                    RefClassImpl refClass = (RefClassImpl)refFrom.getRefManager().getReference(target.getSourcePsi());
                                    refFrom.addReference((RefElement)refClass, target.getSourcePsi(), decl, false, true, null);
                                }
                                return null;
                            }
                        });
                    }
                }

                public boolean visitVariable(@NotNull UVariable node) {
                    this.visitTypeRefs(node.getType());
                    return false;
                }

                public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                    PsiElement target = node.resolve();
                    this.visitReferenceExpression((UExpression)node);
                    if (target instanceof PsiClass) {
                        PsiClass aClass = (PsiClass)target;
                        RefClassImpl refClass = (RefClassImpl)refFrom.getRefManager().getReference((PsiElement)aClass);
                        refFrom.addReference((RefElement)refClass, (PsiElement)aClass, decl, false, true, null);
                    }
                    return false;
                }

                public boolean visitLiteralExpression(@NotNull ULiteralExpression node) {
                    PsiElement sourcePsi = node.getSourcePsi();
                    if (sourcePsi != null) {
                        for (PsiReference reference : sourcePsi.getReferences()) {
                            PsiElement resolve2 = reference.resolve();
                            if (!(resolve2 instanceof PsiMember)) continue;
                            RefElement refResolved = refFrom.getRefManager().getReference(resolve2);
                            refFrom.addReference(refResolved, resolve2, decl, false, true, null);
                            if (!(refResolved instanceof RefMethod)) continue;
                            RefJavaUtilImpl.this.updateRefMethod(resolve2, refResolved, (UExpression)node, (UElement)decl, (RefElement)refFrom);
                        }
                    }
                    return false;
                }

                public boolean visitPrefixExpression(@NotNull UPrefixExpression node) {
                    this.visitReferenceExpression((UExpression)node);
                    return false;
                }

                public boolean visitPostfixExpression(@NotNull UPostfixExpression node) {
                    this.visitReferenceExpression((UExpression)node);
                    return false;
                }

                public boolean visitUnaryExpression(@NotNull UUnaryExpression node) {
                    this.visitReferenceExpression((UExpression)node);
                    return false;
                }

                public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
                    this.visitReferenceExpression((UExpression)node);
                    return false;
                }

                public boolean visitQualifiedReferenceExpression(@NotNull UQualifiedReferenceExpression node) {
                    this.visitReferenceExpression((UExpression)node);
                    return false;
                }

                public boolean visitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
                    this.visitReferenceExpression((UExpression)node);
                    this.processFunctionalExpression((UExpression)node, RefJavaUtilImpl.getFunctionalInterfaceType(node));
                    this.markParametersReferenced(node);
                    return false;
                }

                private void markParametersReferenced(@NotNull UCallableReferenceExpression node) {
                    PsiElement resolved = node.resolve();
                    if (resolved == null) {
                        return;
                    }
                    RefElement refElement = refFrom.getRefManager().getReference(resolved);
                    if (refElement instanceof RefMethod) {
                        for (RefParameter parameter2 : ((RefMethod)refElement).getParameters()) {
                            refFrom.addReference((RefElement)parameter2, parameter2.getPsiElement(), decl, false, true, (UExpression)node);
                        }
                    }
                }

                public boolean visitObjectLiteralExpression(@NotNull UObjectLiteralExpression node) {
                    this.visitReferenceExpression((UExpression)node);
                    this.visitClass(node.getDeclaration());
                    return false;
                }

                public boolean visitCallExpression(@NotNull UCallExpression node) {
                    PsiElement constructorClass;
                    UReferenceExpression reference;
                    List argumentList;
                    PsiMethod resolvedMethod;
                    RefMethod refConstructor;
                    this.visitReferenceExpression((UExpression)node);
                    if (node instanceof UObjectLiteralExpression) {
                        this.visitClass(((UObjectLiteralExpression)node).getDeclaration());
                    }
                    if (node.getKind() == UastCallKind.CONSTRUCTOR_CALL && (refConstructor = this.processNewLikeConstruct(resolvedMethod = node.resolve(), argumentList = node.getValueArguments())) == null && (reference = node.getClassReference()) != null && (constructorClass = reference.resolve()) instanceof PsiClass) {
                        this.processClassReference((PsiClass)constructorClass, refFrom, decl, true, (UExpression)node);
                    }
                    try {
                        node.getTypeArguments().forEach(this::visitTypeRefs);
                    }
                    catch (UnsupportedOperationException e) {
                        LOG.error((Throwable)e);
                    }
                    return false;
                }

                private void visitReferenceExpression(UExpression node) {
                    UElement uastParent2 = node.getUastParent();
                    if (uastParent2 instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)uastParent2).getSelector() == node) {
                        return;
                    }
                    PsiElement psiResolved = null;
                    if (node instanceof UResolvable) {
                        psiResolved = ((UResolvable)node).resolve();
                    } else if (node instanceof UBinaryExpression) {
                        psiResolved = ((UBinaryExpression)node).resolveOperator();
                    } else if (node instanceof UUnaryExpression) {
                        psiResolved = ((UUnaryExpression)node).resolveOperator();
                    }
                    if (psiResolved == null) {
                        psiResolved = RefJavaUtilImpl.tryFindKotlinParameter(node, decl);
                    }
                    if (psiResolved instanceof LightElement) {
                        psiResolved = psiResolved.getNavigationElement();
                    }
                    RefElement refResolved = refFrom.getRefManager().getReference(psiResolved);
                    boolean writing = RefJavaUtilImpl.isAccessedForWriting((UElement)node);
                    boolean reading = RefJavaUtilImpl.isAccessedForReading((UElement)node);
                    refFrom.addReference(refResolved, psiResolved, decl, writing, reading, node);
                    if (refResolved instanceof RefMethod) {
                        RefJavaUtilImpl.this.updateRefMethod(psiResolved, refResolved, node, (UElement)decl, (RefElement)refFrom);
                    }
                    if (psiResolved instanceof PsiMember) {
                        RefJavaUtilImpl.addClassReferenceForStaticImport(node, (PsiMember)psiResolved, refFrom, decl);
                    }
                }

                public boolean visitLambdaExpression(@NotNull ULambdaExpression node) {
                    this.processFunctionalExpression((UExpression)node, node.getFunctionalInterfaceType());
                    return false;
                }

                private void processFunctionalExpression(UExpression expression2, PsiType type2) {
                    PsiClass aClass = PsiUtil.resolveClassInType((PsiType)type2);
                    if (aClass != null) {
                        aClass = aClass.getSourceElement();
                    }
                    if (aClass != null) {
                        refFrom.addReference(refFrom.getRefManager().getReference((PsiElement)aClass), (PsiElement)aClass, decl, false, true, null);
                        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)type2);
                        if (interfaceMethod != null) {
                            refFrom.addReference(refFrom.getRefManager().getReference((PsiElement)interfaceMethod), (PsiElement)interfaceMethod, decl, false, true, null);
                            refFrom.getRefManager().fireNodeMarkedReferenced((PsiElement)interfaceMethod, expression2.getSourcePsi());
                        }
                    }
                }

                @Nullable
                private RefMethod processNewLikeConstruct(PsiMethod javaConstructor, List<UExpression> argumentList) {
                    if (javaConstructor == null) {
                        return null;
                    }
                    RefMethodImpl refConstructor = (RefMethodImpl)refFrom.getRefManager().getReference(javaConstructor.getOriginalElement());
                    refFrom.addReference((RefElement)refConstructor, (PsiElement)javaConstructor, decl, false, true, null);
                    for (UExpression arg : argumentList) {
                        arg.accept((UastVisitor)this);
                    }
                    if (refConstructor != null) {
                        refConstructor.updateParameterValues(argumentList, (PsiElement)javaConstructor);
                    }
                    return refConstructor;
                }

                public boolean visitClass(@NotNull UClass uClass) {
                    for (UTypeReferenceExpression type2 : uClass.getUastSuperTypes()) {
                        type2.accept((UastVisitor)this);
                    }
                    RefClassImpl refClass = (RefClassImpl)refFrom.getRefManager().getReference(uClass.getSourcePsi());
                    refFrom.addReference((RefElement)refClass, uClass.getSourcePsi(), decl, false, true, null);
                    return true;
                }

                public boolean visitReturnExpression(@NotNull UReturnExpression node) {
                    if (refFrom instanceof RefMethodImpl && UastUtils.getParentOfType((UElement)node, UMethod.class, (boolean)false, (Class[])new Class[]{UClass.class, ULambdaExpression.class}) == decl) {
                        RefMethodImpl refMethod = (RefMethodImpl)refFrom;
                        refMethod.updateReturnValueTemplate(node.getReturnExpression());
                    }
                    return false;
                }

                public boolean visitClassLiteralExpression(@NotNull UClassLiteralExpression node) {
                    PsiType type2 = node.getType();
                    if (type2 instanceof PsiClassType) {
                        this.processClassReference(((PsiClassType)type2).resolve(), refFrom, decl, false, (UExpression)node);
                    }
                    return false;
                }

                private void processClassReference(PsiClass psiClass, RefJavaElementImpl refFrom2, UDeclaration from, boolean defaultConstructorOnly, UExpression node) {
                    RefClassImpl refClass;
                    if (psiClass != null && (refClass = (RefClassImpl)((Object)ObjectUtils.tryCast((Object)refFrom2.getRefManager().getReference(psiClass.getNavigationElement()), RefClassImpl.class))) != null) {
                        boolean hasConstructorsMarked = false;
                        if (defaultConstructorOnly) {
                            WritableRefElement refDefaultConstructor = (WritableRefElement)refClass.getDefaultConstructor();
                            if (refDefaultConstructor != null) {
                                refDefaultConstructor.addInReference((RefElement)refFrom2);
                                refFrom2.addOutReference((RefElement)refDefaultConstructor);
                                hasConstructorsMarked = true;
                            }
                        } else {
                            for (RefMethod cons : refClass.getConstructors()) {
                                if (cons instanceof RefImplicitConstructor) continue;
                                ((WritableRefElement)cons).addInReference((RefElement)refFrom2);
                                refFrom2.addOutReference((RefElement)cons);
                                hasConstructorsMarked = true;
                            }
                            UClass uClass = refClass.getUastElement();
                            if (uClass != null && uClass.getJavaPsi().isEnum()) {
                                for (RefEntity child : refClass.getChildren()) {
                                    UField uField;
                                    if (!(child instanceof RefField) || !((uField = ((RefField)child).getUastElement()) instanceof UEnumConstant)) continue;
                                    ((RefFieldImpl)child).markReferenced(refFrom2, false, true, node);
                                    refFrom2.addOutReference((RefElement)child);
                                }
                            }
                        }
                        if (!hasConstructorsMarked) {
                            refFrom2.addReference((RefElement)refClass, (PsiElement)psiClass, from, false, true, null);
                        }
                    }
                }
            });
        }
    }

    private static void addClassReferenceForStaticImport(UExpression node, PsiMember psiResolved, RefJavaElementImpl refFrom, UDeclaration decl) {
        RefElement refContainingClass;
        PsiClass containingClass;
        JavaResolveResult result;
        PsiElement sourcePsi = node.getSourcePsi();
        if (sourcePsi instanceof PsiReferenceExpression && (result = ((PsiReferenceExpression)sourcePsi).advancedResolve(false)).getCurrentFileResolveScope() instanceof PsiImportStaticStatement && (containingClass = psiResolved.getContainingClass()) != null && (refContainingClass = refFrom.getRefManager().getReference((PsiElement)containingClass)) != null) {
            refFrom.addReference(refContainingClass, (PsiElement)containingClass, decl, false, true, node);
        }
    }

    private static PsiElement tryFindKotlinParameter(@NotNull UExpression node, @NotNull UDeclaration decl) {
        UIdentifier identifier;
        if (node instanceof UCallExpression && "invoke".equals(((UCallExpression)node).getMethodName()) && (identifier = ((UCallExpression)node).getMethodIdentifier()) != null) {
            UParameter parameter2;
            String name2 = identifier.getName();
            if (decl instanceof UMethod && (parameter2 = (UParameter)((UMethod)decl).getUastParameters().stream().filter(p -> name2.equals(p.getName())).findAny().orElse(null)) != null) {
                return parameter2.getSourcePsi();
            }
        }
        return null;
    }

    private void updateRefMethod(PsiElement psiResolved, RefElement refResolved, UExpression refExpression, UElement uFrom, RefElement refFrom) {
        UMethod uMethod = (UMethod)Objects.requireNonNull(UastContextKt.toUElement((PsiElement)psiResolved, UMethod.class));
        RefMethodImpl refMethod = (RefMethodImpl)refResolved;
        if (refExpression instanceof UCallableReferenceExpression) {
            PsiType returnType = uMethod.getReturnType();
            if (!uMethod.isConstructor() && !PsiType.VOID.equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiType)RefJavaUtilImpl.getFunctionalInterfaceType((UCallableReferenceExpression)refExpression)))) {
                refMethod.setReturnValueUsed(true);
                this.addTypeReference(uFrom, returnType, refFrom.getRefManager());
            }
            refMethod.setParametersAreUnknown();
            return;
        }
        if (refExpression instanceof ULiteralExpression) {
            PsiType returnType = uMethod.getReturnType();
            if (!uMethod.isConstructor() && !PsiType.VOID.equals((Object)returnType)) {
                refMethod.setReturnValueUsed(true);
                this.addTypeReference(uFrom, returnType, refFrom.getRefManager());
            }
            return;
        }
        UCallExpression call = null;
        if (refExpression instanceof UCallExpression) {
            call = (UCallExpression)refExpression;
        } else if (refExpression instanceof UQualifiedReferenceExpression) {
            call = (UCallExpression)ObjectUtils.tryCast((Object)((UQualifiedReferenceExpression)refExpression).getSelector(), UCallExpression.class);
        }
        if (call != null) {
            PsiClassType methodOwnerType;
            String fqName;
            UClass containingClass;
            PsiType usedType;
            UExpression uExpression;
            List argumentList;
            PsiType returnType = uMethod.getReturnType();
            if (!uMethod.isConstructor() && !PsiType.VOID.equals((Object)returnType)) {
                PsiExpression expression2 = (PsiExpression)ObjectUtils.tryCast((Object)call.getJavaPsi(), PsiExpression.class);
                if (expression2 == null || !ExpressionUtils.isVoidContext(expression2)) {
                    refMethod.setReturnValueUsed(true);
                }
                this.addTypeReference(uFrom, returnType, refFrom.getRefManager());
            }
            if (!(argumentList = call.getValueArguments()).isEmpty()) {
                refMethod.updateParameterValues(argumentList, psiResolved);
            }
            if ((uExpression = call.getReceiver()) != null && (usedType = uExpression.getExpressionType()) != null && (containingClass = (UClass)UDeclarationKt.getContainingDeclaration((UElement)uMethod, UClass.class)) != null && (fqName = containingClass.getQualifiedName()) != null && !usedType.equals(methodOwnerType = JavaPsiFacade.getElementFactory((Project)psiResolved.getProject()).createTypeByFQClassName(fqName, GlobalSearchScope.allScope((Project)psiResolved.getProject())))) {
                refMethod.setCalledOnSubClass(true);
            }
        }
    }

    private static PsiType getFunctionalInterfaceType(UCallableReferenceExpression expression2) {
        PsiElement psi = expression2.getSourcePsi();
        if (psi instanceof PsiFunctionalExpression) {
            return ((PsiFunctionalExpression)psi).getFunctionalInterfaceType();
        }
        return null;
    }

    public RefClass getTopLevelClass(@NotNull RefElement refElement) {
        RefEntity refParent = refElement.getOwner();
        while (refParent instanceof RefElement && !(refParent instanceof RefFile)) {
            refElement = (RefElementImpl)refParent;
            refParent = refParent.getOwner();
        }
        return refElement instanceof RefClass ? (RefClass)refElement : null;
    }

    public boolean isInheritor(@NotNull RefClass subClass, RefClass superClass) {
        if (subClass == superClass) {
            return true;
        }
        for (RefClass baseClass : subClass.getBaseClasses()) {
            if (!this.isInheritor(baseClass, superClass)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getPackageName(RefEntity refEntity) {
        if (refEntity instanceof RefProject || refEntity instanceof RefJavaModule) {
            return null;
        }
        RefPackage refPackage = RefJavaUtilImpl.getPackage((RefEntity)refEntity);
        return refPackage == null ? JavaAnalysisBundle.message((String)"inspection.reference.default.package", (Object[])new Object[0]) : refPackage.getQualifiedName();
    }

    @NotNull
    public String getAccessModifier(@NotNull PsiModifierListOwner psiElement) {
        if (psiElement instanceof PsiParameter) {
            return "packageLocal";
        }
        PsiModifierList list = psiElement.getModifierList();
        String result = "packageLocal";
        if (list != null) {
            PsiClass ownerClass;
            if (list.hasModifierProperty("private")) {
                result = "private";
            } else if (list.hasModifierProperty("protected")) {
                result = "protected";
            } else if (list.hasModifierProperty("public")) {
                result = "public";
            } else if (psiElement.getParent() instanceof PsiClass && (ownerClass = (PsiClass)psiElement.getParent()).isInterface()) {
                result = "public";
            }
        }
        return result;
    }

    @Nullable
    public RefClass getOwnerClass(RefManager refManager, UElement uElement) {
        while (uElement != null && !(uElement instanceof UClass)) {
            uElement = uElement.getUastParent();
        }
        return uElement != null ? (RefClass)refManager.getReference(uElement.getSourcePsi()) : null;
    }

    @Nullable
    public RefClass getOwnerClass(RefElement refElement) {
        RefEntity parent = refElement.getOwner();
        while (!(parent instanceof RefClass) && parent instanceof RefElement) {
            parent = parent.getOwner();
        }
        if (parent instanceof RefClass) {
            return (RefClass)parent;
        }
        return null;
    }

    public boolean isMethodOnlyCallsSuper(UMethod method) {
        PsiMethod javaMethod = method.getJavaPsi();
        boolean hasStatements = false;
        UExpression body2 = method.getUastBody();
        if (body2 != null) {
            List statements = body2 instanceof UBlockExpression ? ((UBlockExpression)body2).getExpressions() : Collections.singletonList(body2);
            for (UExpression expression2 : statements) {
                boolean isCallToSameSuper = false;
                if (expression2 instanceof UReturnExpression) {
                    UExpression returnExpr = ((UReturnExpression)expression2).getReturnExpression();
                    isCallToSameSuper = returnExpr == null || this.isCallToSuperMethod(returnExpr, method);
                } else if (!(expression2 instanceof UBlockExpression)) {
                    isCallToSameSuper = this.isCallToSuperMethod(expression2, method);
                }
                hasStatements = true;
                if (isCallToSameSuper) continue;
                return false;
            }
        }
        if (hasStatements) {
            PsiMethod[] superMethods = javaMethod.findSuperMethods();
            int defaultCount = 0;
            for (PsiMethod superMethod : superMethods) {
                if (VisibilityUtil.compare((String)VisibilityUtil.getVisibilityModifier((PsiModifierList)superMethod.getModifierList()), (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)javaMethod.getModifierList())) > 0) {
                    return false;
                }
                if (!superMethod.hasModifierProperty("default")) continue;
                ++defaultCount;
            }
            if (defaultCount > 1) {
                return false;
            }
        }
        return hasStatements;
    }

    public boolean isCallToSuperMethod(UExpression expression2, UMethod method) {
        if (expression2 instanceof UQualifiedReferenceExpression) {
            UExpression receiver2 = ((UQualifiedReferenceExpression)expression2).getReceiver();
            UExpression selector2 = ((UQualifiedReferenceExpression)expression2).getSelector();
            if (receiver2 instanceof USuperExpression && selector2 instanceof UCallExpression) {
                PsiMethod superMethod = ((UCallExpression)selector2).resolve();
                if (superMethod == null || !MethodSignatureUtil.areSignaturesEqual((PsiMethod)method.getJavaPsi(), (PsiMethod)superMethod)) {
                    return false;
                }
                List args = ((UCallExpression)selector2).getValueArguments();
                List params = method.getUastParameters();
                for (int i = 0; i < args.size(); ++i) {
                    UExpression arg = (UExpression)args.get(i);
                    if (!(arg instanceof USimpleNameReferenceExpression)) {
                        return false;
                    }
                    if (((UParameter)params.get(i)).equals(((USimpleNameReferenceExpression)arg).resolve())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int compareAccess(String a1, String a2) {
        return Integer.compare(RefJavaUtilImpl.getAccessNumber(a1), RefJavaUtilImpl.getAccessNumber(a2));
    }

    private static int getAccessNumber(String a) {
        if (a == "private") {
            return 0;
        }
        if (a == "packageLocal") {
            return 1;
        }
        if (a == "protected") {
            return 2;
        }
        if (a == "public") {
            return 3;
        }
        return -1;
    }

    public void setAccessModifier(@NotNull RefJavaElement refElement, @NotNull String newAccess) {
        ((RefJavaElementImpl)refElement).setAccessModifier(newAccess);
    }

    public void setIsStatic(RefJavaElement refElement, boolean isStatic) {
        ((RefJavaElementImpl)refElement).setIsStatic(isStatic);
    }

    public void setIsFinal(RefJavaElement refElement, boolean isFinal) {
        ((RefJavaElementImpl)refElement).setIsFinal(isFinal);
    }

    public void addTypeReference(UElement uElement, PsiType psiType, RefManager refManager) {
        this.addTypeReference(uElement, psiType, refManager, null);
    }

    public void addTypeReference(UElement uElement, PsiType psiType, RefManager refManager, @Nullable RefJavaElement refMethod) {
        RefClass ownerClass;
        if (psiType != null && (ownerClass = this.getOwnerClass(refManager, uElement)) != null && (psiType = psiType.getDeepComponentType()) instanceof PsiClassType) {
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)psiType);
            if (psiClass != null && refManager.belongsToScope((PsiElement)psiClass)) {
                RefClassImpl refClass = (RefClassImpl)refManager.getReference((PsiElement)psiClass);
                if (refClass != null) {
                    refClass.addTypeReference((RefJavaElement)ownerClass);
                    if (refMethod != null) {
                        refClass.addClassExporter(refMethod);
                    }
                }
            } else {
                ((RefManagerImpl)refManager).fireNodeMarkedReferenced((PsiElement)psiClass, uElement.getSourcePsi());
            }
        }
    }

    private static boolean isAccessedForWriting(@NotNull UElement expression2) {
        if (RefJavaUtilImpl.isOnAssignmentLeftHand(expression2)) {
            return true;
        }
        UElement parent = RefJavaUtilImpl.skipParenthesises(expression2);
        return RefJavaUtilImpl.isIncrementDecrement(parent);
    }

    private static boolean isIncrementDecrement(UElement element) {
        if (!(element instanceof UUnaryExpression)) {
            return false;
        }
        UastOperator operator2 = ((UUnaryExpression)element).getOperator();
        return operator2 == UastPostfixOperator.DEC || operator2 == UastPostfixOperator.INC || operator2 == UastPrefixOperator.DEC || operator2 == UastPrefixOperator.INC;
    }

    private static boolean isAccessedForReading(@NotNull UElement expression2) {
        UElement parent = RefJavaUtilImpl.skipParenthesises(expression2);
        return !(parent instanceof UBinaryExpression) || !(((UBinaryExpression)parent).getOperator() instanceof UastBinaryOperator.AssignOperator) || UastUtils.isUastChildOf((UElement)((UBinaryExpression)parent).getRightOperand(), (UElement)expression2, (boolean)false);
    }

    private static boolean isOnAssignmentLeftHand(@NotNull UElement expression2) {
        UExpression parent = (UExpression)ObjectUtils.tryCast((Object)RefJavaUtilImpl.skipParenthesises(expression2), UExpression.class);
        if (parent == null) {
            return false;
        }
        return parent instanceof UBinaryExpression && ((UBinaryExpression)parent).getOperator() instanceof UastBinaryOperator.AssignOperator && UastUtils.isUastChildOf((UElement)expression2, (UElement)((UBinaryExpression)parent).getLeftOperand(), (boolean)false);
    }

    private static UElement skipParenthesises(@NotNull UElement expression2) {
        return UastUtils.skipParentOfType((UElement)expression2, (boolean)true, (Class[])new Class[]{UParenthesizedExpression.class});
    }
}

