/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaFileImpl;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.SyntheticElement;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.Stack;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastCallKind;

public abstract class RefJavaElementImpl
extends RefElementImpl
implements RefJavaElement {
    private Set<RefClass> myOutTypeReferences;
    private static final int ACCESS_MODIFIER_MASK = 3;
    private static final int ACCESS_PRIVATE = 0;
    private static final int ACCESS_PROTECTED = 1;
    private static final int ACCESS_PACKAGE = 2;
    private static final int ACCESS_PUBLIC = 3;
    private static final int IS_STATIC_MASK = 4;
    private static final int IS_FINAL_MASK = 8;
    private static final int IS_SYNTHETIC_JSP_ELEMENT_MASK = 1024;
    private static final int FORBID_PROTECTED_ACCESS_MASK = 2048;

    protected RefJavaElementImpl(@NotNull String name2, @NotNull RefJavaElement owner2) {
        super(name2, (RefElement)owner2);
        String am = owner2.getAccessModifier();
        this.doSetAccessModifier(am);
        boolean synthOwner = owner2.isSyntheticJSP();
        if (synthOwner) {
            this.setSyntheticJSP(true);
        }
    }

    protected RefJavaElementImpl(UDeclaration elem, PsiElement psi, RefManager manager) {
        super(RefJavaElementImpl.getName(elem), psi, manager);
        boolean isSynth;
        PsiModifierListOwner javaPsi = (PsiModifierListOwner)Objects.requireNonNull(ObjectUtils.tryCast((Object)elem.getJavaPsi(), PsiModifierListOwner.class));
        this.setAccessModifier(RefJavaUtil.getInstance().getAccessModifier(javaPsi));
        boolean bl = isSynth = javaPsi instanceof PsiMethod && psi instanceof SyntheticElement || psi instanceof PsiSyntheticClass;
        if (isSynth) {
            this.setSyntheticJSP(true);
        }
        this.setIsStatic(elem.isStatic());
        this.setIsFinal(elem.isFinal());
    }

    @NotNull
    public synchronized Collection<RefClass> getOutTypeReferences() {
        return (Collection)ObjectUtils.notNull(this.myOutTypeReferences, Collections.emptySet());
    }

    synchronized void addOutTypeReference(RefClass refClass) {
        if (this.myOutTypeReferences == null) {
            this.myOutTypeReferences = new THashSet();
        }
        this.myOutTypeReferences.add(refClass);
    }

    @NotNull
    public static String getName(UDeclaration declaration2) {
        PsiElement element = declaration2.getJavaPsi();
        if (element instanceof PsiAnonymousClass) {
            PsiAnonymousClass psiAnonymousClass = (PsiAnonymousClass)element;
            PsiClass psiBaseClass = psiAnonymousClass.getBaseClassType().resolve();
            if (psiBaseClass == null) {
                return "anonymous class";
            }
            return JavaAnalysisBundle.message((String)"inspection.reference.anonymous.name", (Object[])new Object[]{psiBaseClass.getName()});
        }
        if (element instanceof PsiSyntheticClass) {
            PsiSyntheticClass jspClass = (PsiSyntheticClass)element;
            PsiFile jspxFile = jspClass.getContainingFile();
            return "<" + jspxFile.getName() + ">";
        }
        if (element instanceof PsiMethod && element instanceof SyntheticElement) {
            return JavaAnalysisBundle.message((String)"inspection.reference.jsp.holder.method.anonymous.name", (Object[])new Object[0]);
        }
        String name2 = null;
        if (element instanceof PsiNamedElement) {
            name2 = ((PsiNamedElement)element).getName();
        }
        return name2 == null ? AnalysisBundle.message((String)"inspection.reference.anonymous", (Object[])new Object[0]) : name2;
    }

    public boolean isFinal() {
        return this.checkFlag(8L);
    }

    public boolean isStatic() {
        return this.checkFlag(4L);
    }

    void setIsStatic(boolean isStatic) {
        this.setFlag(isStatic, 4L);
    }

    void setIsFinal(boolean isFinal) {
        this.setFlag(isFinal, 8L);
    }

    public boolean isSyntheticJSP() {
        return this.checkFlag(1024L);
    }

    private void setSyntheticJSP(boolean b) {
        this.setFlag(b, 1024L);
    }

    @NotNull
    public String getAccessModifier() {
        long access_id = this.myFlags & 3L;
        if (access_id == 0L) {
            return "private";
        }
        if (access_id == 3L) {
            return "public";
        }
        if (access_id == 2L) {
            return "packageLocal";
        }
        return "protected";
    }

    public void setAccessModifier(String am) {
        this.doSetAccessModifier(am);
    }

    private void doSetAccessModifier(@NotNull String am) {
        int access_id = "private".equals(am) ? 0 : ("public".equals(am) ? 3 : ("packageLocal".equals(am) ? 2 : 1));
        this.myFlags = this.myFlags & 0xFFFFFFFFFFFFFFFCL | (long)access_id;
    }

    public boolean isSuspiciousRecursive() {
        return this.isCalledOnlyFrom(this, (Stack<RefJavaElement>)new Stack());
    }

    private boolean isCalledOnlyFrom(RefJavaElement refElement, Stack<RefJavaElement> callStack) {
        if (callStack.contains((Object)this)) {
            return refElement == this;
        }
        if (this.getInReferences().isEmpty()) {
            return false;
        }
        if (refElement instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refElement;
            for (RefMethod refSuper : refMethod.getSuperMethods()) {
                if (refSuper.getInReferences().isEmpty()) continue;
                return false;
            }
            if (refMethod.isConstructor()) {
                boolean unreachable = true;
                for (RefElement refOut : refMethod.getOutReferences()) {
                    unreachable &= !refOut.isReachable();
                }
                if (unreachable) {
                    return true;
                }
            }
        }
        callStack.push((Object)this);
        for (RefElement refCaller : this.getInReferences()) {
            if (((RefElementImpl)refCaller).isSuspicious() && refCaller instanceof RefJavaElementImpl && ((RefJavaElementImpl)refCaller).isCalledOnlyFrom(refElement, callStack)) continue;
            callStack.pop();
            return false;
        }
        callStack.pop();
        return true;
    }

    void addReference(RefElement refWhat, PsiElement psiWhat, UDeclaration from, boolean forWriting, boolean forReading, UExpression expression2) {
        PsiModifierListOwner psiFrom = from.getPsi();
        if (refWhat != null) {
            if (refWhat instanceof RefParameter) {
                if (forWriting) {
                    ((RefParameter)refWhat).parameterReferenced(true);
                }
                if (forReading) {
                    ((RefParameter)refWhat).parameterReferenced(false);
                }
            }
            this.addOutReference(refWhat);
            if (refWhat instanceof RefJavaFileImpl) {
                ((RefJavaFileImpl)refWhat).addInReference((RefElement)this);
                this.getRefManager().fireNodeMarkedReferenced(psiWhat, (PsiElement)psiFrom);
            } else if (refWhat instanceof RefJavaElementImpl) {
                ((RefJavaElementImpl)refWhat).markReferenced(this, forWriting, forReading, expression2);
            }
        } else {
            if (psiWhat instanceof PsiMethod) {
                this.markEnumUsedIfValuesMethod((PsiMethod)psiWhat, expression2);
            }
            this.getRefManager().fireNodeMarkedReferenced(psiWhat, (PsiElement)psiFrom);
        }
    }

    protected void markReferenced(@NotNull RefElementImpl refFrom, boolean forWriting, boolean forReading, @Nullable UExpression expressionFrom) {
        this.addInReference((RefElement)refFrom);
        this.setForbidProtectedAccess(refFrom, expressionFrom);
        this.getRefManager().fireNodeMarkedReferenced((RefElement)this, (RefElement)refFrom, false, forReading, forWriting, expressionFrom == null ? null : expressionFrom.getSourcePsi());
    }

    void setForbidProtectedAccess(RefElementImpl refFrom, @Nullable UExpression expressionFrom) {
        if (!this.checkFlag(2048L) && (expressionFrom instanceof UQualifiedReferenceExpression || expressionFrom instanceof UCallExpression && ((UCallExpression)expressionFrom).getKind() == UastCallKind.CONSTRUCTOR_CALL) && RefJavaUtil.getPackage((RefEntity)refFrom) != RefJavaUtil.getPackage((RefEntity)this)) {
            this.setFlag(true, 2048L);
        }
    }

    public boolean isProtectedAccessForbidden() {
        return this.checkFlag(2048L);
    }

    RefJavaManager getRefJavaManager() {
        return (RefJavaManager)this.getRefManager().getExtension(RefJavaManager.MANAGER);
    }

    public void referenceRemoved() {
        super.referenceRemoved();
        if (this.isEntry()) {
            this.getRefJavaManager().getEntryPointsManager().removeEntryPoint((RefElement)this);
        }
    }

    public Icon getIcon(boolean expanded) {
        PsiElement element;
        if (this.isSyntheticJSP() && (element = this.getPsiElement()) != null && element.isValid()) {
            return IconUtil.getIcon((VirtualFile)element.getContainingFile().getVirtualFile(), (int)3, (Project)element.getProject());
        }
        return super.getIcon(expanded);
    }

    private void markEnumUsedIfValuesMethod(PsiMethod psiWhat, UExpression expression2) {
        PsiClass containingClass = psiWhat.getContainingClass();
        if (containingClass != null && containingClass.isEnum() && "values".equals(psiWhat.getName())) {
            for (PsiField enumConstant : containingClass.getFields()) {
                RefJavaElementImpl enumConstantReference;
                if (!(enumConstant instanceof PsiEnumConstant) || (enumConstantReference = (RefJavaElementImpl)this.getRefManager().getReference((PsiElement)enumConstant)) == null) continue;
                this.addOutReference((RefElement)enumConstantReference);
                enumConstantReference.markReferenced(this, false, true, expression2);
            }
        }
    }
}

