/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.optionalToIf;

import com.intellij.codeInspection.optionalToIf.Operation;
import com.intellij.codeInspection.optionalToIf.OptionalToIfContext;
import com.intellij.codeInspection.optionalToIf.OptionalToIfInspection;
import com.intellij.codeInspection.streamToLoop.ChainVariable;
import com.intellij.codeInspection.streamToLoop.FunctionHelper;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class IntermediateOperation
implements Operation {
    IntermediateOperation() {
    }

    @Nullable
    static IntermediateOperation create(@NotNull String name2, PsiExpression @NotNull [] args) {
        if (args.length != 1) {
            return null;
        }
        if (name2.equals("map")) {
            FunctionHelper fn = FunctionHelper.create(args[0], 1);
            return fn == null ? null : new Map(fn);
        }
        if (name2.equals("filter")) {
            FunctionHelper fn = FunctionHelper.create(args[0], 1);
            return fn == null ? null : new Filter(fn);
        }
        if (name2.equals("or")) {
            FunctionHelper fn = FunctionHelper.create(args[0], 0);
            return fn == null ? null : Or.create(fn);
        }
        if (name2.equals("flatMap")) {
            FunctionHelper fn = FunctionHelper.create(args[0], 1);
            return fn == null ? null : FlatMap.create(fn);
        }
        return null;
    }

    @NotNull
    private static OptionalToIfInspection.OperationRecord replaceFnVariable(@NotNull String oldName, @NotNull OptionalToIfInspection.OperationRecord record, @NotNull ChainVariable outerVar, @NotNull OptionalToIfContext context) {
        ChainVariable inVar = IntermediateOperation.replaceFnVariable(oldName, record.myInVar, outerVar);
        ChainVariable outVar = IntermediateOperation.replaceFnVariable(oldName, record.myOutVar, outerVar);
        Operation operation = record.myOperation;
        operation.rename(oldName, outerVar, context);
        return new OptionalToIfInspection.OperationRecord(inVar, outVar, operation);
    }

    @NotNull
    private static ChainVariable replaceFnVariable(@NotNull String oldName, @NotNull ChainVariable variable, @NotNull ChainVariable replacement) {
        return oldName.equals(variable.getName()) ? replacement : variable;
    }

    @Nullable
    private static List<OptionalToIfInspection.OperationRecord> extractRecords(@NotNull FunctionHelper fn) {
        PsiMethodCallExpression chainExpression = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)fn.getExpression(), PsiMethodCallExpression.class);
        if (chainExpression == null) {
            return null;
        }
        List<Operation> operations = OptionalToIfInspection.extractOperations(chainExpression, false);
        if (operations == null || operations.isEmpty()) {
            return null;
        }
        return OptionalToIfInspection.createRecords(operations);
    }

    static class FlatMap
    extends IntermediateOperation {
        private List<OptionalToIfInspection.OperationRecord> myRecords;
        private final String myVarName;
        private final FunctionHelper myFn;

        @Contract(pure=true)
        private FlatMap(List<OptionalToIfInspection.OperationRecord> records, String varName, FunctionHelper fn) {
            this.myRecords = records;
            this.myVarName = varName;
            this.myFn = fn;
        }

        @Override
        @NotNull
        public ChainVariable getOutVar(@NotNull ChainVariable inVar) {
            ChainVariable outVar = this.myRecords.get((int)(this.myRecords.size() - 1)).myOutVar;
            return this.myVarName.equals(outVar.getName()) ? inVar : outVar;
        }

        @Override
        @NotNull
        public StreamEx<OptionalToIfInspection.OperationRecord> nestedOperations() {
            return StreamEx.of(this.myRecords).flatMap(or -> (StreamEx)StreamEx.of((Object)or).append(or.myOperation.nestedOperations()));
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            String elseBranch = context.getElseBranch();
            List records = ContainerUtil.map(this.myRecords, r -> IntermediateOperation.replaceFnVariable(this.myVarName, r, inVar, context));
            String wrapped = OptionalToIfInspection.wrapCode(context, records, code);
            context.setElseBranch(elseBranch);
            return wrapped;
        }

        @Override
        public void rename(@NotNull String oldName, @NotNull ChainVariable newVar, @NotNull OptionalToIfContext context) {
            this.myRecords = ContainerUtil.map(this.myRecords, r -> IntermediateOperation.replaceFnVariable(oldName, r, newVar, context));
        }

        @Override
        public void preprocessVariables(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull OptionalToIfContext context) {
            String name2 = this.myFn.getParameterName(0);
            if (name2 != null && !context.isUsedLambdaVarName(name2)) {
                inVar.addBestNameCandidate(name2);
                context.addLambdaVarName(name2);
            }
        }

        @Nullable
        static FlatMap create(@NotNull FunctionHelper fn) {
            String varName = fn.tryLightTransform();
            if (varName == null) {
                return null;
            }
            List records = IntermediateOperation.extractRecords(fn);
            return records == null ? null : new FlatMap(records, varName, fn);
        }
    }

    static class Or
    extends IntermediateOperation {
        private List<OptionalToIfInspection.OperationRecord> myRecords;

        @Contract(pure=true)
        Or(List<OptionalToIfInspection.OperationRecord> records) {
            this.myRecords = records;
        }

        @Override
        @NotNull
        public ChainVariable getOutVar(@NotNull ChainVariable inVar) {
            return new ChainVariable(inVar.getType());
        }

        @Override
        public void rename(@NotNull String oldName, @NotNull ChainVariable newVar, @NotNull OptionalToIfContext context) {
            this.myRecords = ContainerUtil.map(this.myRecords, r -> IntermediateOperation.replaceFnVariable(oldName, r, newVar, context));
        }

        @Override
        @NotNull
        public StreamEx<OptionalToIfInspection.OperationRecord> nestedOperations() {
            return StreamEx.of(this.myRecords).flatMap(or -> (StreamEx)StreamEx.of((Object)or).append(or.myOperation.nestedOperations()));
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            String orResult = this.myRecords.get((int)(this.myRecords.size() - 1)).myOutVar.getName();
            String orCode = OptionalToIfInspection.wrapCode(context, this.myRecords, outVar.getName() + "=" + orResult + ";");
            if (orCode == null) {
                return null;
            }
            return "if(" + outVar.getName() + "==null){\n" + orCode + "\n}" + context.generateNotNullCondition(outVar.getName(), code);
        }

        @Nullable
        static Or create(@NotNull FunctionHelper fn) {
            List records = IntermediateOperation.extractRecords(fn);
            return records == null ? null : new Or(records);
        }
    }

    static class Map
    extends IntermediateOperation {
        private final FunctionHelper myFn;

        @Contract(pure=true)
        Map(FunctionHelper fn) {
            this.myFn = fn;
        }

        @Override
        public void preprocessVariables(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull OptionalToIfContext context) {
            this.myFn.preprocessVariable(context, inVar, 0);
            this.myFn.suggestOutputNames(context, outVar);
        }

        @Override
        public void rename(@NotNull String oldName, @NotNull ChainVariable newVar, @NotNull OptionalToIfContext context) {
            this.myFn.rename(oldName, newVar.getName(), context);
        }

        @Override
        @NotNull
        public ChainVariable getOutVar(@NotNull ChainVariable inVar) {
            return new ChainVariable(this.myFn.getResultType());
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            this.myFn.transform(context, inVar.getName());
            return outVar.getDeclaration(this.myFn.getText()) + context.generateNotNullCondition(outVar.getName(), code);
        }
    }

    static class Filter
    extends IntermediateOperation {
        private final FunctionHelper myFn;

        @Contract(pure=true)
        Filter(FunctionHelper fn) {
            this.myFn = fn;
        }

        @Override
        @NotNull
        public ChainVariable getOutVar(@NotNull ChainVariable inVar) {
            return inVar;
        }

        @Override
        public void rename(@NotNull String oldName, @NotNull ChainVariable newVar, @NotNull OptionalToIfContext context) {
            this.myFn.rename(oldName, newVar.getName(), context);
        }

        @Override
        public void preprocessVariables(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull OptionalToIfContext context) {
            this.myFn.preprocessVariable(context, inVar, 0);
        }

        @Override
        @Nullable
        public String generate(@NotNull ChainVariable inVar, @NotNull ChainVariable outVar, @NotNull String code, @NotNull OptionalToIfContext context) {
            this.myFn.transform(context, outVar.getName());
            return context.generateCondition(this.myFn.getExpression(), code);
        }
    }
}

