/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class AnnotateOverriddenMethodParameterFix
implements LocalQuickFix {
    private final String myAnnotation;
    private final String[] myAnnosToRemove;

    AnnotateOverriddenMethodParameterFix(@NotNull String annotationFQN, String ... annosToRemove) {
        this.myAnnotation = annotationFQN;
        this.myAnnosToRemove = annosToRemove;
    }

    @NotNull
    public String getName() {
        return JavaAnalysisBundle.message((String)"annotate.overridden.methods.parameters", (Object[])new Object[]{ClassUtil.extractClassName((String)this.myAnnotation)});
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        ArrayList toAnnotate = new ArrayList();
        PsiParameter parameter2 = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiParameter.class, (boolean)false);
        if (parameter2 == null || !AnnotateOverriddenMethodParameterFix.processParameterInheritorsUnderProgress(parameter2, param -> {
            if (AddAnnotationPsiFix.isAvailable((PsiModifierListOwner)param, this.myAnnotation)) {
                toAnnotate.add(param);
            }
        })) {
            return;
        }
        FileModificationService.getInstance().preparePsiElementsForWrite(toAnnotate);
        Throwable exception = null;
        for (PsiParameter psiParam : toAnnotate) {
            assert (psiParam != null) : toAnnotate;
            try {
                if (AnnotationUtil.isAnnotatingApplicable((PsiElement)psiParam, (String)this.myAnnotation)) {
                    AddAnnotationPsiFix fix = new AddAnnotationPsiFix(this.myAnnotation, (PsiModifierListOwner)psiParam, PsiNameValuePair.EMPTY_ARRAY, this.myAnnosToRemove);
                    PsiFile containingFile = psiParam.getContainingFile();
                    if (psiParam.isValid() && fix.isAvailable(project, containingFile, (PsiElement)psiParam, (PsiElement)psiParam)) {
                        fix.invoke(project, containingFile, (PsiElement)psiParam, (PsiElement)psiParam);
                    }
                }
            }
            catch (PsiInvalidElementAccessException | IncorrectOperationException e) {
                exception = e;
            }
            if (exception == null) continue;
            throw exception;
        }
    }

    public static boolean processParameterInheritorsUnderProgress(@NotNull PsiParameter parameter2, @NotNull Consumer<? super PsiParameter> consumer) {
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parameter2, PsiMethod.class);
        if (method == null) {
            return false;
        }
        Object[] parameters2 = method.getParameterList().getParameters();
        int index = ArrayUtilRt.find((Object[])parameters2, (Object)parameter2);
        return AnnotateMethodFix.processModifiableInheritorsUnderProgress(method, psiMethod -> {
            PsiParameter[] psiParameters = psiMethod.getParameterList().getParameters();
            if (index < psiParameters.length) {
                consumer.accept(psiParameters[index]);
            }
        });
    }

    @NotNull
    public String getFamilyName() {
        return JavaAnalysisBundle.message((String)"annotate.overridden.methods.parameters.family.name", (Object[])new Object[0]);
    }
}

