/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.CommonBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.java.JavaBundle;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.SdkPopupFactory;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.PsiReferenceProcessor;
import com.intellij.psi.search.PsiReferenceProcessorAdapter;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

public class GlobalJavaInspectionContextImpl
extends GlobalJavaInspectionContext {
    private static final Logger LOG = Logger.getInstance(GlobalJavaInspectionContextImpl.class);
    private Map<SmartPsiElementPointer, List<GlobalJavaInspectionContext.DerivedMethodsProcessor>> myDerivedMethodsRequests;
    private Map<SmartPsiElementPointer, List<GlobalJavaInspectionContext.DerivedClassesProcessor>> myDerivedClassesRequests;
    private Map<SmartPsiElementPointer, List<GlobalJavaInspectionContext.UsagesProcessor>> myMethodUsagesRequests;
    private Map<SmartPsiElementPointer, List<GlobalJavaInspectionContext.UsagesProcessor>> myFieldUsagesRequests;
    private Map<SmartPsiElementPointer, List<GlobalJavaInspectionContext.UsagesProcessor>> myClassUsagesRequests;
    private Map<SmartPsiElementPointer, List<Runnable>> myQNameUsagesRequests;

    public void enqueueClassUsagesProcessor(RefClass refClass, GlobalJavaInspectionContext.UsagesProcessor p) {
        if (this.myClassUsagesRequests == null) {
            this.myClassUsagesRequests = new THashMap();
        }
        GlobalJavaInspectionContextImpl.enqueueRequestImpl((RefElement)refClass, this.myClassUsagesRequests, p);
    }

    public void enqueueDerivedClassesProcessor(RefClass refClass, GlobalJavaInspectionContext.DerivedClassesProcessor p) {
        if (this.myDerivedClassesRequests == null) {
            this.myDerivedClassesRequests = new THashMap();
        }
        GlobalJavaInspectionContextImpl.enqueueRequestImpl((RefElement)refClass, this.myDerivedClassesRequests, p);
    }

    public void enqueueDerivedMethodsProcessor(RefMethod refMethod, GlobalJavaInspectionContext.DerivedMethodsProcessor p) {
        if (refMethod.isConstructor() || refMethod.isStatic()) {
            return;
        }
        if (this.myDerivedMethodsRequests == null) {
            this.myDerivedMethodsRequests = new THashMap();
        }
        GlobalJavaInspectionContextImpl.enqueueRequestImpl((RefElement)refMethod, this.myDerivedMethodsRequests, p);
    }

    public void enqueueFieldUsagesProcessor(RefField refField, GlobalJavaInspectionContext.UsagesProcessor p) {
        if (this.myFieldUsagesRequests == null) {
            this.myFieldUsagesRequests = new THashMap();
        }
        GlobalJavaInspectionContextImpl.enqueueRequestImpl((RefElement)refField, this.myFieldUsagesRequests, p);
    }

    public void enqueueMethodUsagesProcessor(RefMethod refMethod, GlobalJavaInspectionContext.UsagesProcessor p) {
        if (this.myMethodUsagesRequests == null) {
            this.myMethodUsagesRequests = new THashMap();
        }
        GlobalJavaInspectionContextImpl.enqueueRequestImpl((RefElement)refMethod, this.myMethodUsagesRequests, p);
    }

    public void enqueueQualifiedNameOccurrencesProcessor(RefClass refClass, Runnable c) {
        if (this.myQNameUsagesRequests == null) {
            this.myQNameUsagesRequests = new THashMap();
        }
        GlobalJavaInspectionContextImpl.enqueueRequestImpl((RefElement)refClass, this.myQNameUsagesRequests, c);
    }

    public EntryPointsManager getEntryPointsManager(RefManager manager) {
        return ((RefJavaManager)manager.getExtension(RefJavaManager.MANAGER)).getEntryPointsManager();
    }

    public static boolean isInspectionsEnabled(boolean online, @NotNull Project project, @NotNull Runnable rerunAction) {
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        if (online) {
            if (modules.length == 0) {
                Messages.showMessageDialog((Project)project, (String)JavaBundle.message((String)"inspection.no.modules.error.message", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return false;
            }
            if (GlobalJavaInspectionContextImpl.isBadSdk(project, modules)) {
                Messages.showMessageDialog((Project)project, (String)JavaBundle.message((String)"inspection.no.jdk.error.message", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                SdkPopupFactory.newBuilder().withProject(project).withSdkType((SdkTypeId)JavaSdk.getInstance()).updateProjectSdkFromSelection().onSdkSelected(sdk -> {
                    DumbService.getInstance((Project)project).completeJustSubmittedTasks();
                    rerunAction.run();
                }).buildPopup().showInFocusCenter();
                return false;
            }
        } else {
            if (modules.length == 0) {
                System.err.println(JavaBundle.message((String)"inspection.no.modules.error.message", (Object[])new Object[0]));
                return false;
            }
            if (GlobalJavaInspectionContextImpl.isBadSdk(project, modules)) {
                System.err.println(JavaBundle.message((String)"inspection.no.jdk.error.message", (Object[])new Object[0]));
                System.err.println(JavaBundle.message((String)"offline.inspections.jdk.not.found", (Object[])new Object[]{ProjectRootManager.getInstance((Project)project).getProjectSdkName()}));
                return false;
            }
            for (Module module : modules) {
                OrderEntry[] entries;
                ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
                if (ModuleType.get((Module)module) instanceof JavaModuleType && rootManager.getSourceRoots(true).length == 0) {
                    LOG.info(JavaBundle.message((String)"offline.inspections.no.source.roots", (Object[])new Object[]{module.getName()}));
                }
                for (OrderEntry entry : entries = rootManager.getOrderEntries()) {
                    if (entry instanceof JdkOrderEntry) {
                        if (ModuleType.get((Module)module).isValidSdk(module, null)) continue;
                        System.err.println(InspectionsBundle.message((String)"offline.inspections.module.jdk.not.found", (Object[])new Object[]{((JdkOrderEntry)entry).getJdkName(), module.getName()}));
                        return false;
                    }
                    if (!(entry instanceof LibraryOrderEntry)) continue;
                    LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)entry;
                    Library library = libraryOrderEntry.getLibrary();
                    if (library == null) {
                        System.err.println(JavaBundle.message((String)"offline.inspections.library.was.not.resolved", (Object[])new Object[]{libraryOrderEntry.getPresentableName(), module.getName()}));
                        continue;
                    }
                    Set detectedUrls = Arrays.stream(library.getFiles(OrderRootType.CLASSES)).map(file -> file.getUrl()).collect(Collectors.toSet());
                    Set declaredUrls = ContainerUtil.set((Object[])library.getUrls(OrderRootType.CLASSES));
                    declaredUrls.removeAll(detectedUrls);
                    declaredUrls.removeIf(arg_0 -> ((Library)library).isJarDirectory(arg_0));
                    if (declaredUrls.isEmpty()) continue;
                    System.err.println(JavaBundle.message((String)"offline.inspections.library.urls.were.not.resolved", (Object[])new Object[]{StringUtil.join((Collection)declaredUrls, (String)", "), libraryOrderEntry.getPresentableName(), module.getName()}));
                }
            }
        }
        return true;
    }

    private static boolean isBadSdk(Project project, Module[] modules) {
        boolean anyModuleAcceptsSdk = false;
        boolean anyModuleUsesProjectSdk = false;
        Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        for (Module module : modules) {
            if (!ModuleRootManager.getInstance((Module)module).isSdkInherited()) continue;
            anyModuleUsesProjectSdk = true;
            if (!ModuleType.get((Module)module).isValidSdk(module, projectSdk)) continue;
            anyModuleAcceptsSdk = true;
        }
        return anyModuleUsesProjectSdk && !anyModuleAcceptsSdk;
    }

    private static <T> void enqueueRequestImpl(RefElement refElement, Map<SmartPsiElementPointer, List<T>> requestMap, T processor2) {
        List requests = requestMap.computeIfAbsent(refElement.getPointer(), __ -> new ArrayList());
        requests.add(processor2);
    }

    public void cleanup() {
        this.myDerivedMethodsRequests = null;
        this.myDerivedClassesRequests = null;
        this.myMethodUsagesRequests = null;
        this.myFieldUsagesRequests = null;
        this.myClassUsagesRequests = null;
    }

    private void processSearchRequests(GlobalInspectionContext context) {
        UClass uClass;
        UMethod uMethod;
        List<GlobalJavaInspectionContext.UsagesProcessor> processors;
        List<SmartPsiElementPointer> sortedIDs;
        final RefManager refManager = context.getRefManager();
        final AnalysisScope scope = refManager.getScope();
        GlobalSearchScope searchScope = new GlobalSearchScope(refManager.getProject()){
            private final boolean processedReferences;
            {
                super(x0);
                this.processedReferences = Registry.is((String)"batch.inspections.process.external.elements");
            }

            public boolean contains(@NotNull VirtualFile file) {
                if (scope != null && !scope.contains(file)) {
                    return true;
                }
                boolean inGraph = this.processedReferences ? refManager.isInGraph(file) : FileTypeRegistry.getInstance().isFileOfType(file, (FileType)JavaFileType.INSTANCE);
                return !inGraph;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                return true;
            }

            public boolean isSearchInLibraries() {
                return false;
            }
        };
        if (this.myDerivedClassesRequests != null) {
            sortedIDs = GlobalJavaInspectionContextImpl.getSortedIDs(this.myDerivedClassesRequests);
            for (SmartPsiElementPointer sortedID : sortedIDs) {
                UClass uClass2 = (UClass)ReadAction.compute(() -> (UClass)UastContextKt.toUElement((PsiElement)GlobalJavaInspectionContextImpl.dereferenceInReadAction(sortedID), UClass.class));
                if (uClass2 == null) continue;
                context.incrementJobDoneAmount(context.getStdJobDescriptors().FIND_EXTERNAL_USAGES, GlobalJavaInspectionContextImpl.getClassPresentableName(uClass2));
                processors = this.myDerivedClassesRequests.get(sortedID);
                LOG.assertTrue(processors != null, (Object)uClass2.getClass().getName());
                ClassInheritorsSearch.search((PsiClass)uClass2.getJavaPsi(), (SearchScope)searchScope, (boolean)false).forEach(GlobalJavaInspectionContextImpl.createMembersProcessor(processors, scope));
            }
            this.myDerivedClassesRequests = null;
        }
        if (this.myDerivedMethodsRequests != null) {
            sortedIDs = GlobalJavaInspectionContextImpl.getSortedIDs(this.myDerivedMethodsRequests);
            for (SmartPsiElementPointer sortedID : sortedIDs) {
                uMethod = (UMethod)ReadAction.compute(() -> (UMethod)UastContextKt.toUElement((PsiElement)GlobalJavaInspectionContextImpl.dereferenceInReadAction(sortedID), UMethod.class));
                if (uMethod == null) continue;
                RefMethod refMethod = (RefMethod)ReadAction.compute(() -> (RefMethod)refManager.getReference(uMethod.getSourcePsi()));
                context.incrementJobDoneAmount(context.getStdJobDescriptors().FIND_EXTERNAL_USAGES, refManager.getQualifiedName((RefEntity)refMethod));
                List<GlobalJavaInspectionContext.DerivedMethodsProcessor> processors2 = this.myDerivedMethodsRequests.get(sortedID);
                LOG.assertTrue(processors2 != null, (Object)uMethod.getClass().getName());
                OverridingMethodsSearch.search((PsiMethod)uMethod.getJavaPsi(), (SearchScope)searchScope, (boolean)true).forEach(GlobalJavaInspectionContextImpl.createMembersProcessor(processors2, scope));
            }
            this.myDerivedMethodsRequests = null;
        }
        if (this.myFieldUsagesRequests != null) {
            sortedIDs = GlobalJavaInspectionContextImpl.getSortedIDs(this.myFieldUsagesRequests);
            for (SmartPsiElementPointer sortedID : sortedIDs) {
                PsiElement field = GlobalJavaInspectionContextImpl.dereferenceInReadAction(sortedID);
                if (field == null) continue;
                processors = this.myFieldUsagesRequests.get(sortedID);
                LOG.assertTrue(processors != null, (Object)field.getClass().getName());
                context.incrementJobDoneAmount(context.getStdJobDescriptors().FIND_EXTERNAL_USAGES, refManager.getQualifiedName((RefEntity)refManager.getReference(field)));
                ReferencesSearch.search((PsiElement)field, (SearchScope)searchScope, (boolean)false).forEach((Processor)new PsiReferenceProcessorAdapter(GlobalJavaInspectionContextImpl.createReferenceProcessor(processors, context)));
            }
            this.myFieldUsagesRequests = null;
        }
        if (this.myClassUsagesRequests != null) {
            sortedIDs = GlobalJavaInspectionContextImpl.getSortedIDs(this.myClassUsagesRequests);
            for (SmartPsiElementPointer sortedID : sortedIDs) {
                PsiElement classDeclaration = GlobalJavaInspectionContextImpl.dereferenceInReadAction(sortedID);
                if (classDeclaration == null) continue;
                processors = this.myClassUsagesRequests.get(sortedID);
                LOG.assertTrue(processors != null, (Object)classDeclaration.getClass().getName());
                uClass = (UClass)ReadAction.compute(() -> (UClass)UastContextKt.toUElement((PsiElement)classDeclaration, UClass.class));
                context.incrementJobDoneAmount(context.getStdJobDescriptors().FIND_EXTERNAL_USAGES, GlobalJavaInspectionContextImpl.getClassPresentableName(uClass));
                ReferencesSearch.search((PsiElement)classDeclaration, (SearchScope)searchScope, (boolean)false).forEach((Processor)new PsiReferenceProcessorAdapter(GlobalJavaInspectionContextImpl.createReferenceProcessor(processors, context)));
            }
            this.myClassUsagesRequests = null;
        }
        if (this.myMethodUsagesRequests != null) {
            sortedIDs = GlobalJavaInspectionContextImpl.getSortedIDs(this.myMethodUsagesRequests);
            for (SmartPsiElementPointer sortedID : sortedIDs) {
                uMethod = (UMethod)ReadAction.compute(() -> (UMethod)UastContextKt.toUElement((PsiElement)GlobalJavaInspectionContextImpl.dereferenceInReadAction(sortedID), UMethod.class));
                if (uMethod == null) continue;
                processors = this.myMethodUsagesRequests.get(sortedID);
                LOG.assertTrue(processors != null, (Object)uMethod.getClass().getName());
                context.incrementJobDoneAmount(context.getStdJobDescriptors().FIND_EXTERNAL_USAGES, (String)ReadAction.compute(() -> uMethod.getName()));
                PsiMethod javaMethod = (PsiMethod)ReadAction.compute(() -> uMethod.getJavaPsi());
                if (javaMethod == null) continue;
                MethodReferencesSearch.search((PsiMethod)javaMethod, (SearchScope)searchScope, (boolean)true).forEach((Processor)new PsiReferenceProcessorAdapter(GlobalJavaInspectionContextImpl.createReferenceProcessor(processors, context)));
            }
            this.myMethodUsagesRequests = null;
        }
        if (this.myQNameUsagesRequests != null) {
            PsiSearchHelper helper = PsiSearchHelper.getInstance((Project)refManager.getProject());
            final RefJavaManager javaManager = (RefJavaManager)refManager.getExtension(RefJavaManager.MANAGER);
            List<SmartPsiElementPointer> sortedIDs2 = GlobalJavaInspectionContextImpl.getSortedIDs(this.myQNameUsagesRequests);
            for (SmartPsiElementPointer id : sortedIDs2) {
                uClass = (UClass)ReadAction.compute(() -> (UClass)UastContextKt.toUElement((PsiElement)GlobalJavaInspectionContextImpl.dereferenceInReadAction(id), UClass.class));
                String qualifiedName = uClass != null ? (String)ReadAction.compute(() -> uClass.getQualifiedName()) : null;
                if (qualifiedName == null) continue;
                List<Runnable> callbacks = this.myQNameUsagesRequests.get(id);
                GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)context.getProject());
                PsiNonJavaFileReferenceProcessor processor2 = (file, startOffset, endOffset) -> {
                    for (Runnable callback : callbacks) {
                        callback.run();
                    }
                    return false;
                };
                DelegatingGlobalSearchScope globalSearchScope = new DelegatingGlobalSearchScope(projectScope){
                    final Set<FileType> fileTypes;
                    {
                        super(x0);
                        this.fileTypes = javaManager.getLanguages().stream().map(l -> l.getAssociatedFileType()).collect(Collectors.toSet());
                    }

                    public boolean contains(@NotNull VirtualFile file) {
                        return !this.fileTypes.contains(file.getFileType()) && super.contains(file);
                    }
                };
                helper.processUsagesInNonJavaFiles(qualifiedName, processor2, (GlobalSearchScope)globalSearchScope);
            }
            this.myQNameUsagesRequests = null;
        }
    }

    private static String getClassPresentableName(@NotNull UClass uClass) {
        return (String)ReadAction.compute(() -> {
            String qualifiedName = uClass.getQualifiedName();
            return qualifiedName != null ? qualifiedName : uClass.getName();
        });
    }

    private static PsiElement dereferenceInReadAction(SmartPsiElementPointer sortedID) {
        return (PsiElement)ReadAction.compute(() -> sortedID.getElement());
    }

    private static <Member extends PsiMember, P extends Processor<Member>> PsiElementProcessorAdapter<Member> createMembersProcessor(List<P> processors, AnalysisScope scope) {
        return new PsiElementProcessorAdapter(member -> {
            if (scope.contains(member)) {
                return true;
            }
            ArrayList processorsArrayed = new ArrayList(processors);
            for (Processor processor2 : processorsArrayed) {
                if (processor2.process((Object)member)) continue;
                processors.remove(processor2);
            }
            return !processors.isEmpty();
        });
    }

    private int getRequestCount() {
        int sum = 0;
        sum += GlobalJavaInspectionContextImpl.getRequestListSize(this.myClassUsagesRequests);
        sum += GlobalJavaInspectionContextImpl.getRequestListSize(this.myDerivedClassesRequests);
        sum += GlobalJavaInspectionContextImpl.getRequestListSize(this.myDerivedMethodsRequests);
        sum += GlobalJavaInspectionContextImpl.getRequestListSize(this.myFieldUsagesRequests);
        return sum += GlobalJavaInspectionContextImpl.getRequestListSize(this.myMethodUsagesRequests);
    }

    private static int getRequestListSize(Map<?, ?> list) {
        return list == null ? 0 : list.size();
    }

    private static List<SmartPsiElementPointer> getSortedIDs(Map<SmartPsiElementPointer, ?> requests) {
        ArrayList<SmartPsiElementPointer> result = new ArrayList<SmartPsiElementPointer>();
        ApplicationManager.getApplication().runReadAction(() -> {
            for (SmartPsiElementPointer id : requests.keySet()) {
                if (id == null || id.getContainingFile() == null) continue;
                result.add(id);
            }
            result.sort((o1, o2) -> {
                PsiFile psiFile1 = o1.getContainingFile();
                LOG.assertTrue(psiFile1 != null);
                PsiFile psiFile2 = o2.getContainingFile();
                LOG.assertTrue(psiFile2 != null);
                return psiFile1.getName().compareTo(psiFile2.getName());
            });
        });
        return result;
    }

    private static PsiReferenceProcessor createReferenceProcessor(@NotNull List<GlobalJavaInspectionContext.UsagesProcessor> processors, GlobalInspectionContext context) {
        return reference -> {
            AnalysisScope scope = context.getRefManager().getScope();
            if (scope != null && scope.contains(reference.getElement()) && reference.getElement().getLanguage() == JavaLanguage.INSTANCE || PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiDocComment.class) != null) {
                return true;
            }
            List list = processors;
            synchronized (list) {
                GlobalJavaInspectionContext.UsagesProcessor[] processorsArrayed;
                for (GlobalJavaInspectionContext.UsagesProcessor processor2 : processorsArrayed = processors.toArray(new GlobalJavaInspectionContext.UsagesProcessor[0])) {
                    if (processor2.process((Object)reference)) continue;
                    processors.remove(processor2);
                }
            }
            return !processors.isEmpty();
        };
    }

    public void performPreRunActivities(@NotNull List<Tools> globalTools, @NotNull List<Tools> localTools, @NotNull GlobalInspectionContext context) {
        if (globalTools.stream().anyMatch(tools -> {
            InspectionProfileEntry tool = tools.getTool().getTool();
            return tool instanceof GlobalInspectionTool && ((GlobalInspectionTool)tool).isGraphNeeded();
        })) {
            this.getEntryPointsManager(context.getRefManager()).resolveEntryPoints(context.getRefManager());
        }
        for (int i = 0; i < globalTools.size(); ++i) {
            InspectionToolWrapper toolWrapper = globalTools.get(i).getTool();
            if (!"unused".equals(toolWrapper.getShortName())) continue;
            Collections.swap(globalTools, i, 0);
            break;
        }
    }

    public void performPostRunActivities(@NotNull List<InspectionToolWrapper<?, ?>> needRepeatSearchRequest, @NotNull GlobalInspectionContext context) {
        JobDescriptor progress = context.getStdJobDescriptors().FIND_EXTERNAL_USAGES;
        progress.setTotalAmount(this.getRequestCount());
        do {
            this.processSearchRequests(context);
            InspectionToolWrapper[] requestors = needRepeatSearchRequest.toArray(InspectionToolWrapper.EMPTY_ARRAY);
            InspectionManager inspectionManager = InspectionManager.getInstance((Project)context.getProject());
            for (InspectionToolWrapper toolWrapper : requestors) {
                boolean result = false;
                if (toolWrapper instanceof GlobalInspectionToolWrapper) {
                    InspectionToolPresentation presentation = ((GlobalInspectionContextImpl)context).getPresentation(toolWrapper);
                    result = ((GlobalInspectionTool)((GlobalInspectionToolWrapper)toolWrapper).getTool()).queryExternalUsagesRequests(inspectionManager, context, (ProblemDescriptionsProcessor)presentation);
                }
                if (result) continue;
                needRepeatSearchRequest.remove(toolWrapper);
            }
            int oldSearchRequestCount = progress.getTotalAmount();
            int oldDoneAmount = progress.getDoneAmount();
            int totalAmount = oldSearchRequestCount + this.getRequestCount();
            progress.setTotalAmount(totalAmount);
            progress.setDoneAmount(oldDoneAmount);
        } while (!needRepeatSearchRequest.isEmpty());
    }
}

