/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deprecation;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.apiUsage.ApiUsageUastVisitor;
import com.intellij.codeInspection.deprecation.DeprecatedApiUsageProcessor;
import com.intellij.codeInspection.deprecation.DeprecationInspectionBase;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElementVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class DeprecationInspection
extends DeprecationInspectionBase {
    public static final String SHORT_NAME = "Deprecation";
    public static final String ID = "deprecation";
    public static final String IGNORE_METHODS_OF_DEPRECATED_NAME = "IGNORE_METHODS_OF_DEPRECATED";
    public boolean IGNORE_INSIDE_DEPRECATED = true;
    public boolean IGNORE_ABSTRACT_DEPRECATED_OVERRIDES = true;
    public boolean IGNORE_IMPORT_STATEMENTS = true;
    public boolean IGNORE_METHODS_OF_DEPRECATED = true;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!Registry.is((String)"kotlin.deprecation.inspection.enabled", (boolean)false) && holder.getFile().getLanguage().getID().equals("kotlin")) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return ApiUsageUastVisitor.createPsiElementVisitor(new DeprecatedApiUsageProcessor(holder, this.IGNORE_INSIDE_DEPRECATED, this.IGNORE_ABSTRACT_DEPRECATED_OVERRIDES, this.IGNORE_IMPORT_STATEMENTS, this.IGNORE_METHODS_OF_DEPRECATED, this.IGNORE_IN_SAME_OUTERMOST_CLASS, false, null));
    }

    @NotNull
    public String getGroupDisplayName() {
        return "";
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    @NotNull
    public String getID() {
        return ID;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(JavaAnalysisBundle.message((String)"ignore.inside.deprecated.members", (Object[])new Object[0]), "IGNORE_INSIDE_DEPRECATED");
        panel2.addCheckbox(JavaAnalysisBundle.message((String)"ignore.inside.non.static.imports", (Object[])new Object[0]), "IGNORE_IMPORT_STATEMENTS");
        panel2.addCheckbox(JavaAnalysisBundle.message((String)"html.ignore.overrides.of.deprecated.abstract.methods", (Object[])new Object[0]), "IGNORE_ABSTRACT_DEPRECATED_OVERRIDES");
        panel2.addCheckbox(JavaAnalysisBundle.message((String)"ignore.members.of.deprecated.classes", (Object[])new Object[0]), IGNORE_METHODS_OF_DEPRECATED_NAME);
        DeprecationInspection.addSameOutermostClassCheckBox(panel2);
        return panel2;
    }
}

