/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum RelationType {
    LE("<="),
    LT("<"),
    GE(">="),
    GT(">"),
    EQ("=="),
    NE("!="),
    IS("is"),
    IS_NOT("isn't");

    private final String myName;

    private RelationType(String name2) {
        this.myName = name2;
    }

    @Nullable
    public RelationType meet(@NotNull RelationType other) {
        if (this.isSubRelation(other)) {
            return other;
        }
        if (other.isSubRelation(this)) {
            return this;
        }
        if (this == NE && other == LE || this == LE && other == NE) {
            return LT;
        }
        if (this == NE && other == GE || this == GE && other == NE) {
            return GT;
        }
        if (this == LE && other == GE || this == GE && other == LE) {
            return EQ;
        }
        return null;
    }

    public boolean isSubRelation(RelationType other) {
        if (other == this) {
            return true;
        }
        switch (this) {
            case LE: {
                return other == LT || other == EQ;
            }
            case GE: {
                return other == GT || other == EQ;
            }
            case NE: {
                return other == LT || other == GT;
            }
        }
        return false;
    }

    @NotNull
    public RelationType getNegated() {
        switch (this) {
            case LE: {
                return GT;
            }
            case LT: {
                return GE;
            }
            case GE: {
                return LT;
            }
            case GT: {
                return LE;
            }
            case EQ: {
                return NE;
            }
            case NE: {
                return EQ;
            }
            case IS: {
                return IS_NOT;
            }
            case IS_NOT: {
                return IS;
            }
        }
        throw new InternalError("Unexpected enum value: " + (Object)((Object)this));
    }

    @Nullable
    public RelationType getFlipped() {
        switch (this) {
            case LE: {
                return GE;
            }
            case LT: {
                return GT;
            }
            case GE: {
                return LE;
            }
            case GT: {
                return LT;
            }
            case NE: 
            case EQ: {
                return this;
            }
        }
        return null;
    }

    public boolean isInequality() {
        return this == LE || this == GE || this == LT || this == GT || this == NE;
    }

    public String toString() {
        return this.myName;
    }

    @Nullable
    public static RelationType fromElementType(IElementType type2) {
        if (JavaTokenType.EQEQ.equals(type2)) {
            return EQ;
        }
        if (JavaTokenType.NE.equals(type2)) {
            return NE;
        }
        if (JavaTokenType.LT.equals(type2)) {
            return LT;
        }
        if (JavaTokenType.GT.equals(type2)) {
            return GT;
        }
        if (JavaTokenType.LE.equals(type2)) {
            return LE;
        }
        if (JavaTokenType.GE.equals(type2)) {
            return GE;
        }
        if (JavaTokenType.INSTANCEOF_KEYWORD.equals(type2)) {
            return IS;
        }
        return null;
    }

    public static RelationType equivalence(boolean equal) {
        return equal ? EQ : NE;
    }
}

