/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.types;

import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DfConstantType<T>
implements DfType {
    private final T myValue;

    DfConstantType(T value2) {
        this.myValue = value2;
    }

    @Override
    public boolean isSuperType(@NotNull DfType other) {
        return other.equals(this) || other == DfTypes.BOTTOM;
    }

    @NotNull
    public abstract PsiType getPsiType();

    @Override
    @NotNull
    public DfType meet(@NotNull DfType other) {
        return other.isSuperType(this) ? this : DfTypes.BOTTOM;
    }

    public T getValue() {
        return this.myValue;
    }

    public int hashCode() {
        return Objects.hashCode(this.myValue);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof DfConstantType && Objects.equals(((DfConstantType)obj).myValue, this.myValue);
    }

    public String toString() {
        return DfConstantType.renderValue(this.myValue);
    }

    public static boolean isConst(@NotNull DfType dfType, @Nullable Object value2) {
        return dfType instanceof DfConstantType && Objects.equals(((DfConstantType)dfType).getValue(), value2);
    }

    @Nullable
    public static <T> T getConstantOfType(@NotNull DfType dfType, @NotNull Class<T> clazz) {
        return (T)(dfType instanceof DfConstantType ? ObjectUtils.tryCast(((DfConstantType)dfType).getValue(), clazz) : null);
    }

    public static String renderValue(Object value2) {
        if (value2 == null) {
            return "null";
        }
        if (value2 instanceof String) {
            return '\"' + StringUtil.escapeStringCharacters((String)((String)value2)) + '\"';
        }
        if (value2 instanceof Float) {
            return value2 + "f";
        }
        if (value2 instanceof Long) {
            return value2 + "L";
        }
        if (value2 instanceof PsiField) {
            PsiField field = (PsiField)value2;
            PsiClass containingClass = field.getContainingClass();
            return containingClass == null ? field.getName() : containingClass.getName() + "." + field.getName();
        }
        if (value2 instanceof PsiType) {
            return ((PsiType)value2).getPresentableText();
        }
        return value2.toString();
    }
}

