/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.ExpressionPushingInstruction;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import org.jetbrains.annotations.Nullable;

public class TypeCastInstruction
extends ExpressionPushingInstruction<PsiTypeCastExpression> {
    private final PsiExpression myCasted;
    private final PsiType myCastTo;
    @Nullable
    private final DfaControlTransferValue myTransferValue;

    public TypeCastInstruction(PsiTypeCastExpression castExpression, PsiExpression casted, PsiType castTo, @Nullable DfaControlTransferValue value2) {
        super(castExpression);
        assert (!(castTo instanceof PsiPrimitiveType));
        this.myCasted = casted;
        this.myCastTo = castTo;
        this.myTransferValue = value2;
    }

    @Nullable
    public DfaControlTransferValue getCastExceptionTransfer() {
        return this.myTransferValue;
    }

    public PsiExpression getCasted() {
        return this.myCasted;
    }

    public PsiType getCastTo() {
        return this.myCastTo;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor2) {
        return visitor2.visitTypeCast(this, runner, stateBefore);
    }

    public String toString() {
        return "CAST_TO " + this.myCastTo.getCanonicalText();
    }
}

