/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.psi.PsiArrayAccessExpression;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayAccessInstruction
extends ExpressionPushingInstruction<PsiArrayAccessExpression> {
    @NotNull
    private final DfaValue myValue;
    @Nullable
    private final DfaControlTransferValue myTransferValue;

    public ArrayAccessInstruction(@NotNull DfaValue value2, @NotNull PsiArrayAccessExpression expression2, @Nullable DfaControlTransferValue transferValue) {
        super(expression2);
        this.myValue = value2;
        this.myTransferValue = transferValue;
    }

    @Nullable
    public DfaControlTransferValue getOutOfBoundsExceptionTransfer() {
        return this.myTransferValue;
    }

    @NotNull
    public DfaValue getValue() {
        return this.myValue;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor2) {
        return visitor2.visitArrayAccess(this, runner, stateBefore);
    }

    public String toString() {
        return "ARRAY_ACCESS " + ((PsiArrayAccessExpression)Objects.requireNonNull(this.getExpression())).getText();
    }
}

