/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inliner;

import com.intellij.codeInspection.dataFlow.CFGBuilder;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.inliner.CallInliner;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiUtil;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.NotNull;

public class LambdaInliner
implements CallInliner {
    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        PsiParameter[] parameters2;
        PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getMethodExpression().getQualifierExpression());
        if (qualifier == null) {
            return false;
        }
        JavaResolveResult result = call.getMethodExpression().advancedResolve(false);
        PsiMethod method = (PsiMethod)result.getElement();
        if (method == null || method != LambdaUtil.getFunctionalInterfaceMethod((PsiClass)method.getContainingClass())) {
            return false;
        }
        if (method.isVarArgs()) {
            return false;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length != (parameters2 = method.getParameterList().getParameters()).length) {
            return false;
        }
        PsiSubstitutor substitutor = result.getSubstitutor();
        return builder.tryInlineLambda(args.length, qualifier, DfaPsiUtil.getTypeNullability(substitutor.substitute(method.getReturnType())), () -> EntryStream.zip((Object[])args, (Object[])parameters2).forKeyValue((arg, parameter2) -> builder.pushExpression((PsiExpression)arg).boxUnbox((PsiExpression)arg, parameter2.getType())));
    }
}

