/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inference;

import com.intellij.codeInspection.dataFlow.inference.ClassData;
import com.intellij.codeInspection.dataFlow.inference.ContractInferenceInterpreter;
import com.intellij.codeInspection.dataFlow.inference.JavaSourceInference;
import com.intellij.codeInspection.dataFlow.inference.MethodData;
import com.intellij.codeInspection.dataFlow.inference.MethodReturnInferenceResult;
import com.intellij.codeInspection.dataFlow.inference.MethodReturnInferenceVisitor;
import com.intellij.codeInspection.dataFlow.inference.ParameterNullityInferenceKt;
import com.intellij.codeInspection.dataFlow.inference.PreContract;
import com.intellij.codeInspection.dataFlow.inference.PurityInferenceResult;
import com.intellij.codeInspection.dataFlow.inference.PurityInferenceVisitor;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.JavaLightStubBuilder;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.RecursiveLighterASTNodeWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J<\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001c\u001a\u00020\u00072\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0002J\u001a\u0010&\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u00072\b\u0010(\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0007H\u0016J$\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020\u00072\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002000/H\u0002R-\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R-\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00130\u0006j\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0013`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00061"}, d2={"Lcom/intellij/codeInspection/dataFlow/inference/InferenceVisitor;", "Lcom/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor;", "tree", "Lcom/intellij/lang/LighterAST;", "(Lcom/intellij/lang/LighterAST;)V", "classData", "Ljava/util/HashMap;", "Lcom/intellij/lang/LighterASTNode;", "Lcom/intellij/codeInspection/dataFlow/inference/ClassData;", "Lkotlin/collections/HashMap;", "getClassData", "()Ljava/util/HashMap;", "methodIndex", "", "getMethodIndex", "()I", "setMethodIndex", "(I)V", "result", "Lcom/intellij/codeInspection/dataFlow/inference/MethodData;", "getResult", "getTree", "()Lcom/intellij/lang/LighterAST;", "calcClassData", "aClass", "calcData", "method", "createData", "body", "contracts", "", "Lcom/intellij/codeInspection/dataFlow/inference/PreContract;", "methodReturn", "Lcom/intellij/codeInspection/dataFlow/inference/MethodReturnInferenceResult;", "purity", "Lcom/intellij/codeInspection/dataFlow/inference/PurityInferenceResult;", "notNullParams", "Ljava/util/BitSet;", "getInferenceMode", "Lcom/intellij/codeInspection/dataFlow/inference/JavaSourceInference$InferenceMode;", "clsData", "visitNode", "", "element", "walkMethodBody", "root", "processor", "Lkotlin/Function1;", "", "intellij.java.analysis.impl"})
final class InferenceVisitor
extends RecursiveLighterASTNodeWalkingVisitor {
    private int methodIndex;
    @NotNull
    private final HashMap<LighterASTNode, ClassData> classData;
    @NotNull
    private final HashMap<Integer, MethodData> result;
    @NotNull
    private final LighterAST tree;

    public final int getMethodIndex() {
        return this.methodIndex;
    }

    public final void setMethodIndex(int n) {
        this.methodIndex = n;
    }

    @NotNull
    public final HashMap<LighterASTNode, ClassData> getClassData() {
        return this.classData;
    }

    @NotNull
    public final HashMap<Integer, MethodData> getResult() {
        return this.result;
    }

    public void visitNode(@NotNull LighterASTNode element) {
        IElementType iElementType = element.getTokenType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)JavaElementType.CLASS) || Intrinsics.areEqual((Object)iElementType, (Object)JavaElementType.ANONYMOUS_CLASS)) {
            ((Map)this.classData).put(element, this.calcClassData(element));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)JavaElementType.METHOD)) {
            MethodData methodData = this.calcData(element);
            if (methodData != null) {
                MethodData methodData2 = methodData;
                boolean bl = false;
                boolean bl2 = false;
                MethodData data = methodData2;
                boolean bl3 = false;
                ((Map)this.result).put(this.methodIndex, data);
            }
            int n = this.methodIndex;
            this.methodIndex = n + 1;
        }
        if (JavaLightStubBuilder.isCodeBlockWithoutStubs(element)) {
            return;
        }
        super.visitNode(element);
    }

    private final ClassData calcClassData(LighterASTNode aClass) {
        boolean hasSuper = Intrinsics.areEqual((Object)aClass.getTokenType(), (Object)JavaElementType.ANONYMOUS_CLASS);
        boolean isFinal = Intrinsics.areEqual((Object)aClass.getTokenType(), (Object)JavaElementType.ANONYMOUS_CLASS);
        HashMap fieldModifiers = new HashMap();
        ArrayList<LighterASTNode> initializers = new ArrayList<LighterASTNode>();
        for (LighterASTNode child : this.tree.getChildren(aClass)) {
            LighterASTNode body2;
            LighterASTNode modifiers;
            boolean isStatic;
            IElementType iElementType = child.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.RECORD_KEYWORD) || Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.ENUM_KEYWORD)) {
                isFinal = true;
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)JavaElementType.MODIFIER_LIST)) {
                isFinal = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)child, (IElementType)JavaTokenType.FINAL_KEYWORD) != null;
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)JavaElementType.ENUM_CONSTANT)) {
                isFinal = isFinal && LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)child, (IElementType)JavaElementType.ENUM_CONSTANT_INITIALIZER) == null;
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)JavaElementType.EXTENDS_LIST)) {
                if (LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)child, (IElementType)JavaElementType.JAVA_CODE_REFERENCE) == null) continue;
                hasSuper = true;
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)JavaElementType.FIELD)) {
                LighterASTNode initializer;
                String fieldName = JavaLightTreeUtil.getNameIdentifierText(this.tree, child);
                if (fieldName == null) continue;
                LighterASTNode modifiers2 = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)child, (IElementType)JavaElementType.MODIFIER_LIST);
                ((Map)fieldModifiers).put(fieldName, modifiers2);
                boolean isStatic2 = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)modifiers2, (IElementType)JavaTokenType.STATIC_KEYWORD) != null;
                if (isStatic2 || (initializer = JavaLightTreeUtil.findExpressionChild(this.tree, child)) == null) continue;
                initializers.add(initializer);
                continue;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)JavaElementType.CLASS_INITIALIZER) || (isStatic = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)(modifiers = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)child, (IElementType)JavaElementType.MODIFIER_LIST)), (IElementType)JavaTokenType.STATIC_KEYWORD) != null) || (body2 = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)child, (IElementType)((IElementType)JavaElementType.CODE_BLOCK))) == null) continue;
            initializers.add(body2);
        }
        boolean pureInitializer = true;
        Collection collection = initializers;
        boolean bl = false;
        if (!collection.isEmpty()) {
            PurityInferenceVisitor visitor2 = new PurityInferenceVisitor(this.tree, aClass, fieldModifiers, true);
            for (LighterASTNode initializer : initializers) {
                this.walkMethodBody(initializer, (Function1<? super LighterASTNode, Boolean>)((Function1)new Function1<LighterASTNode, Boolean>(visitor2){

                    public final boolean invoke(LighterASTNode p1) {
                        return ((PurityInferenceVisitor)this.receiver).visitNode(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(PurityInferenceVisitor.class);
                    }

                    public final String getName() {
                        return "visitNode";
                    }

                    public final String getSignature() {
                        return "visitNode(Lcom/intellij/lang/LighterASTNode;)Z";
                    }
                }));
                PurityInferenceResult result = visitor2.getResult();
                pureInitializer = result != null && result.getSingleCall$intellij_java_analysis_impl() == null && result.getMutatedRefs$intellij_java_analysis_impl().isEmpty();
                if (pureInitializer) continue;
                break;
            }
        }
        return new ClassData(hasSuper, pureInitializer, isFinal, fieldModifiers);
    }

    private final JavaSourceInference.InferenceMode getInferenceMode(LighterASTNode method, ClassData clsData) {
        boolean isPrivate;
        boolean ctor;
        ClassData classData = clsData;
        if (classData != null) {
            if (classData.isFinal()) {
                return JavaSourceInference.InferenceMode.ENABLED;
            }
        }
        boolean bl = ctor = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)method, (IElementType)JavaElementType.TYPE) == null;
        if (ctor) {
            return JavaSourceInference.InferenceMode.ENABLED;
        }
        LighterASTNode modifiers = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)method, (IElementType)JavaElementType.MODIFIER_LIST);
        boolean isStatic = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)modifiers, (IElementType)JavaTokenType.STATIC_KEYWORD) != null;
        boolean isFinal = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)modifiers, (IElementType)JavaTokenType.FINAL_KEYWORD) != null;
        boolean bl2 = isPrivate = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)modifiers, (IElementType)JavaTokenType.PRIVATE_KEYWORD) != null;
        if (isStatic || isFinal || isPrivate) {
            return JavaSourceInference.InferenceMode.ENABLED;
        }
        return JavaSourceInference.InferenceMode.PARAMETERS;
    }

    /*
     * WARNING - void declaration
     */
    private final MethodData calcData(LighterASTNode method) {
        LighterASTNode lighterASTNode = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)method, (IElementType)((IElementType)JavaElementType.CODE_BLOCK));
        if (lighterASTNode == null) {
            return null;
        }
        LighterASTNode body2 = lighterASTNode;
        List<String> parameterNames = ParameterNullityInferenceKt.getParameterNames(this.tree, method);
        Map map2 = this.classData;
        LighterASTNode lighterASTNode2 = this.tree.getParent(method);
        boolean bl = false;
        ClassData clsData = (ClassData)map2.get(lighterASTNode2);
        JavaSourceInference.InferenceMode inferenceMode = this.getInferenceMode(method, clsData);
        if (inferenceMode == JavaSourceInference.InferenceMode.PARAMETERS && parameterNames.isEmpty()) {
            return null;
        }
        List<LighterASTNode> statements = ContractInferenceInterpreter.getStatements(body2, this.tree);
        BitSet notNullParams = ParameterNullityInferenceKt.inferNotNullParameters(this.tree, parameterNames, statements);
        if (inferenceMode == JavaSourceInference.InferenceMode.PARAMETERS) {
            return this.createData(body2, CollectionsKt.emptyList(), null, null, notNullParams);
        }
        Object object = clsData;
        if (object == null || (object = ((ClassData)object).getFieldModifiers()) == null) {
            object = MapsKt.emptyMap();
        }
        Object fieldMap = object;
        boolean ctor = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)method, (IElementType)JavaElementType.TYPE) == null;
        boolean maybeImpureCtor = ctor && (clsData == null || clsData.getHasSuper() || !clsData.getHasPureInitializer());
        ContractInferenceInterpreter contractInference = new ContractInferenceInterpreter(this.tree, method, body2);
        List<PreContract> contracts2 = contractInference.inferContracts(statements);
        MethodReturnInferenceVisitor nullityVisitor = new MethodReturnInferenceVisitor(this.tree, contractInference.getParameters(), body2);
        PurityInferenceVisitor purityVisitor = new PurityInferenceVisitor(this.tree, body2, (Map<String, LighterASTNode>)fieldMap, ctor);
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = maybeImpureCtor;
        for (LighterASTNode statement : statements) {
            void stopPurityAnalysis;
            this.walkMethodBody(statement, (Function1<? super LighterASTNode, Boolean>)((Function1)new Function1<LighterASTNode, Boolean>(nullityVisitor, (Ref.BooleanRef)stopPurityAnalysis, purityVisitor){
                final /* synthetic */ MethodReturnInferenceVisitor $nullityVisitor;
                final /* synthetic */ Ref.BooleanRef $stopPurityAnalysis;
                final /* synthetic */ PurityInferenceVisitor $purityVisitor;

                public final boolean invoke(@NotNull LighterASTNode it) {
                    this.$nullityVisitor.visitNode(it);
                    if (!this.$stopPurityAnalysis.element) {
                        this.$stopPurityAnalysis.element = !this.$purityVisitor.visitNode(it);
                    }
                    return true;
                }
                {
                    this.$nullityVisitor = methodReturnInferenceVisitor;
                    this.$stopPurityAnalysis = booleanRef;
                    this.$purityVisitor = purityInferenceVisitor;
                    super(1);
                }
            }));
        }
        return this.createData(body2, contracts2, nullityVisitor.getResult(), maybeImpureCtor ? null : purityVisitor.getResult(), notNullParams);
    }

    private final void walkMethodBody(LighterASTNode root, Function1<? super LighterASTNode, Boolean> processor2) {
        new RecursiveLighterASTNodeWalkingVisitor(this, processor2, this.tree){
            final /* synthetic */ InferenceVisitor this$0;
            final /* synthetic */ Function1 $processor;

            public void visitNode(@NotNull LighterASTNode element) {
                IElementType type2 = element.getTokenType();
                if (type2 == JavaElementType.CLASS || type2 == JavaElementType.FIELD || type2 == JavaElementType.METHOD || type2 == JavaElementType.ANNOTATION_METHOD || type2 == JavaElementType.LAMBDA_EXPRESSION) {
                    return;
                }
                if (!((Boolean)this.$processor.invoke((Object)element)).booleanValue()) {
                    this.stopWalking();
                }
                super.visitNode(element);
            }
            {
                this.this$0 = this$0;
                this.$processor = $captured_local_variable$1;
                super($super_call_param$2);
            }
        }.visitNode(root);
    }

    private final MethodData createData(LighterASTNode body2, List<? extends PreContract> contracts2, MethodReturnInferenceResult methodReturn, PurityInferenceResult purity2, BitSet notNullParams) {
        if (methodReturn == null && purity2 == null && contracts2.isEmpty() && notNullParams.isEmpty()) {
            return null;
        }
        return new MethodData(methodReturn, purity2, contracts2, notNullParams, body2.getStartOffset(), body2.getEndOffset());
    }

    @NotNull
    public final LighterAST getTree() {
        return this.tree;
    }

    public InferenceVisitor(@NotNull LighterAST tree) {
        super(tree);
        this.tree = tree;
        this.classData = new HashMap();
        this.result = new HashMap();
    }
}

