/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.fix;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SurroundWithRequireNonNullFix
implements LocalQuickFix {
    private final String myText;
    private final SmartPsiElementPointer<PsiExpression> myQualifierPointer;

    public SurroundWithRequireNonNullFix(@NotNull PsiExpression expressionToSurround) {
        this.myText = expressionToSurround.getText();
        this.myQualifierPointer = SmartPointerManager.getInstance((Project)expressionToSurround.getProject()).createSmartPsiElementPointer((PsiElement)expressionToSurround);
    }

    @Nls
    @NotNull
    public String getName() {
        return JavaAnalysisBundle.message((String)"inspection.surround.requirenonnull.quickfix", (Object[])new Object[]{this.myText});
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return JavaAnalysisBundle.message((String)"inspection.surround.requirenonnull.quickfix", (Object[])new Object[]{""});
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiExpression qualifier = (PsiExpression)this.myQualifierPointer.getElement();
        if (qualifier == null) {
            return;
        }
        PsiExpression replacement = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("java.util.Objects.requireNonNull(" + qualifier.getText() + ")", (PsiElement)qualifier);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(qualifier.replace((PsiElement)replacement));
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        PsiExpression expression2 = (PsiExpression)this.myQualifierPointer.getElement();
        if (expression2 == null) {
            return null;
        }
        return new SurroundWithRequireNonNullFix((PsiExpression)PsiTreeUtil.findSameElementInCopy((PsiElement)expression2, (PsiFile)target));
    }
}

