/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.fix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class SimplifyToAssignmentFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        return JavaAnalysisBundle.message((String)"inspection.data.flow.simplify.to.assignment.quickfix.name", (Object[])new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement psiElement = descriptor.getPsiElement();
        if (psiElement == null) {
            return;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiAssignmentExpression.class);
        if (assignmentExpression == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        String lExpressionText = assignmentExpression.getLExpression().getText();
        PsiExpression rExpression = assignmentExpression.getRExpression();
        String rExpressionText = rExpression != null ? rExpression.getText() : "";
        assignmentExpression.replace((PsiElement)factory.createExpressionFromText(lExpressionText + " = " + rExpressionText, psiElement));
    }
}

