/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.fix;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class ReplaceWithArgumentFix
implements LocalQuickFix {
    private final String myText;
    private final int myArgNum;

    public ReplaceWithArgumentFix(PsiExpression argument, int argNum) {
        this.myText = PsiExpressionTrimRenderer.render((PsiExpression)argument);
        this.myArgNum = argNum;
    }

    public @IntentionName @NotNull String getName() {
        return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myText});
    }

    public @IntentionFamilyName @NotNull String getFamilyName() {
        return InspectionGadgetsBundle.message("inspection.redundant.string.replace.with.arg.fix.name", new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiMethodCallExpression.class);
        if (call == null) {
            return;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length <= this.myArgNum) {
            return;
        }
        new CommentTracker().replaceAndRestoreComments((PsiElement)call, (PsiElement)args[this.myArgNum]);
    }
}

