/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum SpecialField implements VariableDescriptor
{
    ARRAY_LENGTH("length", true){

        @Override
        boolean isMyQualifierType(PsiType type2) {
            return type2 instanceof PsiArrayType;
        }

        @Override
        boolean isMyAccessor(PsiMember accessor) {
            return accessor instanceof PsiField && "length".equals(accessor.getName()) && PsiUtil.isArrayClass((PsiElement)accessor.getContainingClass());
        }

        @Override
        @NotNull
        DfType fromInitializer(PsiExpression initializer) {
            if (initializer instanceof PsiArrayInitializerExpression) {
                return DfTypes.intValue(((PsiArrayInitializerExpression)initializer).getInitializers().length);
            }
            if (initializer instanceof PsiNewExpression) {
                Object length;
                PsiArrayInitializerExpression arrayInitializer = ((PsiNewExpression)initializer).getArrayInitializer();
                if (arrayInitializer != null) {
                    return DfTypes.intValue(arrayInitializer.getInitializers().length);
                }
                PsiExpression[] dimensions = ((PsiNewExpression)initializer).getArrayDimensions();
                if (dimensions.length > 0 && (length = ExpressionUtils.computeConstantExpression(dimensions[0])) instanceof Integer) {
                    return DfTypes.intValue((Integer)length);
                }
            }
            return DfTypes.TOP;
        }
    }
    ,
    STRING_LENGTH("length", true){

        @Override
        @NotNull
        DfType fromInitializer(PsiExpression initializer) {
            return this.fromConstant(ExpressionUtils.computeConstantExpression(initializer));
        }

        @Override
        boolean isMyQualifierType(PsiType type2) {
            return TypeUtils.isJavaLangString(type2);
        }

        @Override
        boolean isMyAccessor(PsiMember accessor) {
            if (!(accessor instanceof PsiMethod && "length".equals(accessor.getName()) && ((PsiMethod)accessor).getParameterList().isEmpty())) {
                return false;
            }
            PsiClass containingClass = accessor.getContainingClass();
            return containingClass != null && "java.lang.String".equals(containingClass.getQualifiedName());
        }

        @Override
        @NotNull
        public DfType fromConstant(@Nullable Object obj) {
            return obj instanceof String ? DfTypes.intValue(((String)obj).length()) : DfTypes.TOP;
        }
    }
    ,
    COLLECTION_SIZE("size", false){
        private final CallMatcher SIZE_METHODS = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Collection", "size").parameterCount(0), CallMatcher.instanceCall("java.util.Map", "size").parameterCount(0));
        private final CallMatcher MAP_COLLECTIONS = CallMatcher.instanceCall("java.util.Map", "keySet", "entrySet", "values").parameterCount(0);

        @Override
        boolean isMyQualifierType(PsiType type2) {
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
            if (psiClass == null) {
                return false;
            }
            return !InheritanceUtil.processSupers((PsiClass)psiClass, (boolean)true, cls -> {
                String qualifiedName = cls.getQualifiedName();
                return !"java.util.Map".equals(qualifiedName) && !"java.util.Collection".equals(qualifiedName);
            });
        }

        @Override
        boolean isMyAccessor(PsiMember accessor) {
            return accessor instanceof PsiMethod && this.SIZE_METHODS.methodMatches((PsiMethod)accessor);
        }

        @Override
        @NotNull
        public DfType fromConstant(@Nullable Object obj) {
            if (obj instanceof PsiField && DfaUtil.isEmptyCollectionConstantField((PsiVariable)obj)) {
                return DfTypes.intValue(0);
            }
            return super.fromConstant(obj);
        }

        @Override
        @NotNull
        public DfaValue createValue(@NotNull DfaValueFactory factory, @Nullable DfaValue qualifier, boolean forAccessor) {
            if (qualifier instanceof DfaVariableValue) {
                DfaVariableValue var = (DfaVariableValue)qualifier;
                PsiModifierListOwner owner2 = var.getPsiVariable();
                if (var.getQualifier() != null && owner2 instanceof PsiMethod && this.MAP_COLLECTIONS.methodMatches((PsiMethod)owner2)) {
                    return super.createValue(factory, var.getQualifier(), forAccessor);
                }
            }
            return super.createValue(factory, qualifier, forAccessor);
        }
    }
    ,
    UNBOX("value", true){
        private final CallMatcher UNBOXING_CALL = CallMatcher.anyOf(CallMatcher.exactInstanceCall("java.lang.Integer", "intValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Long", "longValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Short", "shortValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Byte", "byteValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Character", "charValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Boolean", "booleanValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Float", "floatValue").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Double", "doubleValue").parameterCount(0));

        public PsiPrimitiveType getType(DfaVariableValue variableValue) {
            return PsiPrimitiveType.getUnboxedType((PsiType)variableValue.getType());
        }

        @Override
        @NotNull
        public DfType getDefaultValue(boolean forAccessor) {
            return DfTypes.TOP;
        }

        @Override
        @NotNull
        public DfaValue createValue(@NotNull DfaValueFactory factory, @Nullable DfaValue qualifier, boolean forAccessor) {
            if (qualifier instanceof DfaBoxedValue) {
                return ((DfaBoxedValue)qualifier).getWrappedValue();
            }
            return super.createValue(factory, qualifier, forAccessor);
        }

        @Override
        boolean isMyQualifierType(PsiType type2) {
            return TypeConversionUtil.isPrimitiveWrapper((PsiType)type2);
        }

        @Override
        boolean isMyAccessor(PsiMember accessor) {
            return accessor instanceof PsiMethod && this.UNBOXING_CALL.methodMatches((PsiMethod)accessor);
        }
    }
    ,
    OPTIONAL_VALUE("value", true){

        @Override
        public PsiType getType(DfaVariableValue variableValue) {
            PsiType optionalType = variableValue.getType();
            PsiType type2 = OptionalUtil.getOptionalElementType(optionalType);
            if (type2 instanceof PsiPrimitiveType) {
                return ((PsiPrimitiveType)type2).getBoxedType((PsiElement)Objects.requireNonNull(((PsiClassType)optionalType).resolve()));
            }
            return type2;
        }

        @Override
        @NotNull
        public DfType getDefaultValue(boolean forAccessor) {
            return (forAccessor ? DfaNullability.NOT_NULL : DfaNullability.NULLABLE).asDfType();
        }

        @Override
        boolean isMyQualifierType(PsiType type2) {
            return TypeUtils.isOptional(type2);
        }

        @Override
        public String getPresentationText(@NotNull DfType dfType, @Nullable PsiType type2) {
            if (dfType == DfTypes.NULL) {
                return "empty Optional";
            }
            if (!dfType.isSuperType(DfTypes.NULL)) {
                return "present Optional";
            }
            return "";
        }

        @Override
        boolean isMyAccessor(PsiMember accessor) {
            return accessor instanceof PsiMethod && OptionalUtil.OPTIONAL_GET.methodMatches((PsiMethod)accessor);
        }
    };

    private static final SpecialField[] VALUES;
    private final String myTitle;
    private final boolean myFinal;

    private SpecialField(String title, boolean isFinal) {
        this.myTitle = title;
        this.myFinal = isFinal;
    }

    @Override
    public boolean isStable() {
        return this.myFinal;
    }

    abstract boolean isMyQualifierType(PsiType var1);

    abstract boolean isMyAccessor(PsiMember var1);

    public String getPresentationText(@NotNull DfType dfType, @Nullable PsiType type2) {
        if (this.getDefaultValue(false).equals(dfType)) {
            return "";
        }
        return dfType.toString();
    }

    @Contract(value="null -> null")
    @Nullable
    public static SpecialField findSpecialField(PsiElement accessor) {
        if (!(accessor instanceof PsiMember)) {
            return null;
        }
        PsiMember member = (PsiMember)accessor;
        for (SpecialField sf : VALUES) {
            if (!sf.isMyAccessor(member)) continue;
            return sf;
        }
        return null;
    }

    @Override
    @NotNull
    public final DfaValue createValue(@NotNull DfaValueFactory factory, @Nullable DfaValue qualifier) {
        return this.createValue(factory, qualifier, false);
    }

    @Override
    @NotNull
    public DfaValue createValue(@NotNull DfaValueFactory factory, @Nullable DfaValue qualifier, boolean forAccessor) {
        if (qualifier instanceof DfaVariableValue) {
            DfType dfType;
            PsiExpression initializer;
            DfaVariableValue variableValue = (DfaVariableValue)qualifier;
            PsiModifierListOwner psiVariable = variableValue.getPsiVariable();
            if (psiVariable instanceof PsiField && factory.canTrustFieldInitializer((PsiField)psiVariable) && psiVariable.hasModifierProperty("static") && psiVariable.hasModifierProperty("final") && (initializer = ((PsiField)psiVariable).getInitializer()) != null && (dfType = this.fromInitializer(initializer)) != DfTypes.TOP) {
                return factory.fromDfType(dfType);
            }
            return VariableDescriptor.super.createValue(factory, qualifier, forAccessor);
        }
        DfType dfType = qualifier == null ? DfTypes.TOP : this.getFromQualifier(qualifier.getDfType());
        return factory.fromDfType(dfType.meet(this.getDefaultValue(forAccessor)));
    }

    @NotNull
    public DfType getDefaultValue(boolean forAccessor) {
        return DfTypes.intRange(LongRangeSet.indexRange());
    }

    @Override
    public PsiType getType(DfaVariableValue variableValue) {
        return PsiType.INT;
    }

    @NotNull
    DfType fromInitializer(PsiExpression initializer) {
        return DfTypes.TOP;
    }

    @NotNull
    public DfType fromConstant(@Nullable Object obj) {
        return DfTypes.TOP;
    }

    public MethodContract[] getEmptyContracts() {
        ContractValue thisValue = ContractValue.qualifier().specialField(this);
        return new MethodContract[]{MethodContract.singleConditionContract(thisValue, RelationType.EQ, ContractValue.zero(), ContractReturnValue.returnTrue()), MethodContract.trivialContract(ContractReturnValue.returnFalse())};
    }

    public MethodContract[] getEqualsContracts() {
        return new MethodContract[]{new StandardMethodContract(new StandardMethodContract.ValueConstraint[]{StandardMethodContract.ValueConstraint.NULL_VALUE}, ContractReturnValue.returnFalse()), MethodContract.singleConditionContract(ContractValue.qualifier().specialField(this), RelationType.NE, ContractValue.argument(0).specialField(this), ContractReturnValue.returnFalse())};
    }

    @NotNull
    public DfType asDfType(@NotNull DfType fieldValue) {
        DfType defaultType = this == OPTIONAL_VALUE ? DfTypes.OBJECT_OR_NULL : this.getDefaultValue(false);
        DfType clamped = fieldValue.meet(defaultType);
        if (clamped.equals(defaultType)) {
            return DfTypes.NOT_NULL_OBJECT;
        }
        if (clamped.equals(DfTypes.BOTTOM)) {
            return DfTypes.BOTTOM;
        }
        return DfTypes.customObject(TypeConstraints.TOP, DfaNullability.NOT_NULL, Mutability.UNKNOWN, this, clamped);
    }

    @NotNull
    public DfType asDfType(@NotNull DfType fieldValue, @Nullable PsiType exactResultType) {
        DfType dfType = this.asDfType(fieldValue);
        if (exactResultType == null) {
            return dfType;
        }
        if (this == STRING_LENGTH && DfConstantType.isConst(fieldValue, 0)) {
            return DfTypes.constant("", exactResultType);
        }
        return dfType.meet(TypeConstraints.exact(exactResultType).asDfType());
    }

    @NotNull
    public DfType getFromQualifier(@NotNull DfType dfType) {
        if (dfType == DfTypes.TOP) {
            return DfTypes.TOP;
        }
        if (!(dfType instanceof DfReferenceType)) {
            return DfTypes.BOTTOM;
        }
        SpecialField sf = ((DfReferenceType)dfType).getSpecialField();
        if (sf == null) {
            return DfTypes.TOP;
        }
        if (sf != this) {
            return DfTypes.BOTTOM;
        }
        return ((DfReferenceType)dfType).getSpecialFieldType();
    }

    @Contract(value="null -> null")
    @Nullable
    public static SpecialField fromQualifierType(PsiType type2) {
        if (type2 == null) {
            return null;
        }
        for (SpecialField value2 : VALUES) {
            if (!value2.isMyQualifierType(type2)) continue;
            return value2;
        }
        return null;
    }

    @Nullable
    public static SpecialField fromQualifier(@NotNull DfaValue value2) {
        DfReferenceType dfType = (DfReferenceType)ObjectUtils.tryCast((Object)value2.getDfType(), DfReferenceType.class);
        if (dfType != null && dfType.getSpecialField() != null) {
            return dfType.getSpecialField();
        }
        return SpecialField.fromQualifierType(value2.getType());
    }

    public String toString() {
        return this.myTitle;
    }

    static {
        VALUES = SpecialField.values();
    }
}

