/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaPsiUtil {
    private static final CallMatcher NON_NULL_VAR_ARG = CallMatcher.anyOf(CallMatcher.staticCall("java.util.List", "of"), CallMatcher.staticCall("java.util.Set", "of"), CallMatcher.staticCall("java.util.Map", "ofEntries"));

    public static boolean isFinalField(PsiVariable var) {
        return var.hasModifierProperty("final") && !var.hasModifierProperty("transient") && var instanceof PsiField;
    }

    @NotNull
    public static Nullability getElementNullability(@Nullable PsiType resultType, @Nullable PsiModifierListOwner owner2) {
        return DfaPsiUtil.getElementNullability(resultType, owner2, false);
    }

    @NotNull
    public static Nullability getElementNullabilityIgnoringParameterInference(@Nullable PsiType resultType, @Nullable PsiModifierListOwner owner2) {
        return DfaPsiUtil.getElementNullability(resultType, owner2, true);
    }

    @NotNull
    private static Nullability getElementNullability(@Nullable PsiType resultType, @Nullable PsiModifierListOwner owner2, boolean ignoreParameterNullabilityInference) {
        PsiField field;
        if (owner2 == null) {
            return DfaPsiUtil.getTypeNullability(resultType);
        }
        if (resultType instanceof PsiPrimitiveType) {
            return Nullability.UNKNOWN;
        }
        if (owner2 instanceof PsiEnumConstant || PsiUtil.isAnnotationMethod((PsiElement)owner2)) {
            return Nullability.NOT_NULL;
        }
        if (owner2 instanceof PsiMethod && DfaPsiUtil.isEnumPredefinedMethod((PsiMethod)owner2)) {
            return Nullability.NOT_NULL;
        }
        Nullability fromAnnotation = DfaPsiUtil.getNullabilityFromAnnotation(owner2, ignoreParameterNullabilityInference);
        if (fromAnnotation != Nullability.UNKNOWN) {
            return fromAnnotation;
        }
        if (owner2 instanceof PsiMethod && DfaPsiUtil.isMapMethodWithUnknownNullity((PsiMethod)owner2)) {
            return DfaPsiUtil.getTypeNullability(resultType) == Nullability.NULLABLE ? Nullability.NULLABLE : Nullability.UNKNOWN;
        }
        Nullability fromType = DfaPsiUtil.getTypeNullability(resultType);
        if (fromType != Nullability.UNKNOWN) {
            return fromType;
        }
        if (owner2 instanceof PsiParameter) {
            return DfaPsiUtil.inferParameterNullability((PsiParameter)owner2);
        }
        if (owner2 instanceof PsiMethod && ((PsiMethod)owner2).getParameterList().isEmpty() && (field = PropertyUtil.getFieldOfGetter((PsiMethod)owner2)) != null && DfaPsiUtil.getElementNullability(resultType, (PsiModifierListOwner)field) == Nullability.NULLABLE) {
            return Nullability.NULLABLE;
        }
        return Nullability.UNKNOWN;
    }

    @NotNull
    private static Nullability getNullabilityFromAnnotation(PsiModifierListOwner owner2, boolean ignoreParameterNullabilityInference) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)owner2.getProject());
        NullabilityAnnotationInfo info = manager.findEffectiveNullabilityInfo(owner2);
        if (info == null) {
            return Nullability.UNKNOWN;
        }
        if (ignoreParameterNullabilityInference && owner2 instanceof PsiParameter && AnnotationUtil.isInferredAnnotation((PsiAnnotation)info.getAnnotation())) {
            List supers = AnnotationUtil.getSuperAnnotationOwners((PsiModifierListOwner)((PsiParameter)owner2));
            return ContainerUtil.exists((Iterable)supers, each -> manager.isNullable((PsiModifierListOwner)each, false)) ? Nullability.NULLABLE : Nullability.UNKNOWN;
        }
        return info.getNullability();
    }

    private static boolean isMapMethodWithUnknownNullity(@NotNull PsiMethod method) {
        String name2 = method.getName();
        if (!"get".equals(name2) && !"remove".equals(name2)) {
            return false;
        }
        PsiMethod superMethod = (PsiMethod)DeepestSuperMethodsSearch.search((PsiMethod)method).findFirst();
        return ("java.util.Map." + name2).equals(PsiUtil.getMemberQualifiedName((PsiMember)(superMethod != null ? superMethod : method)));
    }

    @NotNull
    public static Nullability inferParameterNullability(@NotNull PsiParameter parameter2) {
        PsiElement parent = parameter2.getParent();
        if (parent instanceof PsiParameterList) {
            PsiElement gParent = parent.getParent();
            if (gParent instanceof PsiLambdaExpression) {
                return DfaPsiUtil.getFunctionalParameterNullability((PsiFunctionalExpression)((PsiLambdaExpression)gParent), ((PsiParameterList)parent).getParameterIndex(parameter2));
            }
            if (gParent instanceof PsiMethod && OptionalUtil.OPTIONAL_OF_NULLABLE.methodMatches((PsiMethod)gParent)) {
                return Nullability.NULLABLE;
            }
        }
        if (parent instanceof PsiForeachStatement) {
            return DfaPsiUtil.getTypeNullability(DfaPsiUtil.inferLoopParameterTypeWithNullability((PsiForeachStatement)parent));
        }
        return Nullability.UNKNOWN;
    }

    @Nullable
    private static PsiType inferLoopParameterTypeWithNullability(PsiForeachStatement loop) {
        PsiForeachStatement targetLoop;
        PsiElement target;
        PsiExpression iteratedValue2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)loop.getIteratedValue());
        if (iteratedValue2 == null) {
            return null;
        }
        PsiType iteratedType = iteratedValue2.getType();
        if (iteratedValue2 instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)iteratedValue2).resolve()) instanceof PsiParameter && target.getParent() instanceof PsiForeachStatement && PsiTreeUtil.isAncestor((PsiElement)(targetLoop = (PsiForeachStatement)target.getParent()), (PsiElement)loop, (boolean)true) && !HighlightControlFlowUtil.isReassigned((PsiVariable)((PsiParameter)target), new HashMap<PsiElement, Collection<ControlFlowUtil.VariableInfo>>())) {
            iteratedType = DfaPsiUtil.inferLoopParameterTypeWithNullability(targetLoop);
        }
        return JavaGenericsUtil.getCollectionItemType((PsiType)iteratedType, (GlobalSearchScope)iteratedValue2.getResolveScope());
    }

    @NotNull
    public static Nullability getTypeNullability(@Nullable PsiType type2) {
        NullabilityAnnotationInfo info = DfaPsiUtil.getTypeNullabilityInfo(type2);
        return info == null ? Nullability.UNKNOWN : info.getNullability();
    }

    @Nullable
    public static NullabilityAnnotationInfo getTypeNullabilityInfo(@Nullable PsiType type2) {
        if (type2 == null || type2 instanceof PsiPrimitiveType) {
            return null;
        }
        Ref result = Ref.create(null);
        InheritanceUtil.processSuperTypes((PsiType)type2, (boolean)true, eachType -> {
            result.set((Object)DfaPsiUtil.getTypeOwnNullability(eachType));
            return result.get() == null && (!(type2 instanceof PsiClassType) || PsiUtil.resolveClassInClassTypeOnly((PsiType)type2) instanceof PsiTypeParameter);
        });
        return (NullabilityAnnotationInfo)result.get();
    }

    @Nullable
    private static NullabilityAnnotationInfo getTypeOwnNullability(PsiType eachType) {
        PsiElement context;
        for (PsiAnnotation annotation : eachType.getAnnotations()) {
            String qualifiedName = annotation.getQualifiedName();
            NullableNotNullManager nnn = NullableNotNullManager.getInstance((Project)annotation.getProject());
            if (nnn.getNullables().contains(qualifiedName)) {
                return new NullabilityAnnotationInfo(annotation, Nullability.NULLABLE, false);
            }
            if (!nnn.getNotNulls().contains(qualifiedName)) continue;
            return new NullabilityAnnotationInfo(annotation, Nullability.NOT_NULL, false);
        }
        if (eachType instanceof PsiClassType && (context = ((PsiClassType)eachType).getPsiContext()) != null) {
            return NullableNotNullManager.getInstance((Project)context.getProject()).findDefaultTypeUseNullability(context);
        }
        return null;
    }

    @NotNull
    public static Nullability getFunctionalParameterNullability(PsiFunctionalExpression function, int index) {
        PsiParameter parameter2;
        Nullability nullability = DfaPsiUtil.inferLambdaParameterNullability(function, index);
        if (nullability != Nullability.UNKNOWN) {
            return nullability;
        }
        PsiClassType type2 = (PsiClassType)ObjectUtils.tryCast((Object)LambdaUtil.getFunctionalInterfaceType((PsiElement)function, (boolean)true), PsiClassType.class);
        PsiMethod sam2 = LambdaUtil.getFunctionalInterfaceMethod((PsiType)type2);
        if (sam2 != null && (parameter2 = sam2.getParameterList().getParameter(index)) != null) {
            nullability = DfaPsiUtil.getElementNullability(null, (PsiModifierListOwner)parameter2);
            if (nullability != Nullability.UNKNOWN) {
                return nullability;
            }
            PsiType parameterType = type2.resolveGenerics().getSubstitutor().substitute(parameter2.getType());
            return DfaPsiUtil.getTypeNullability(GenericsUtil.eliminateWildcards((PsiType)parameterType, (boolean)false, (boolean)true));
        }
        return Nullability.UNKNOWN;
    }

    @NotNull
    private static Nullability inferLambdaParameterNullability(PsiFunctionalExpression lambda2, int parameterIndex) {
        PsiMethod method;
        PsiExpressionList list;
        PsiElement listParent;
        PsiFunctionalExpression expression2 = lambda2;
        PsiElement expressionParent = lambda2.getParent();
        while (expressionParent instanceof PsiConditionalExpression || expressionParent instanceof PsiParenthesizedExpression) {
            expression2 = expressionParent;
            expressionParent = expressionParent.getParent();
        }
        if (expressionParent instanceof PsiExpressionList && (listParent = (list = (PsiExpressionList)expressionParent).getParent()) instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)listParent).resolveMethod()) != null) {
            int expressionIndex = ArrayUtil.find((Object[])list.getExpressions(), (Object)expression2);
            return DfaPsiUtil.getLambdaParameterNullability(method, expressionIndex, parameterIndex);
        }
        return Nullability.UNKNOWN;
    }

    @NotNull
    private static Nullability getLambdaParameterNullability(@NotNull PsiMethod method, int parameterIndex, int lambdaParameterIndex) {
        String methodName;
        PsiClass type2 = method.getContainingClass();
        if (type2 != null && "java.util.Optional".equals(type2.getQualifiedName()) && ((methodName = method.getName()).equals("map") || methodName.equals("filter") || methodName.equals("ifPresent") || methodName.equals("flatMap")) && parameterIndex == 0 && lambdaParameterIndex == 0) {
            return Nullability.NOT_NULL;
        }
        return Nullability.UNKNOWN;
    }

    private static boolean isEnumPredefinedMethod(PsiMethod method) {
        return CallMatcher.enumValueOf().methodMatches(method) || CallMatcher.enumValues().methodMatches(method);
    }

    public static boolean isInitializedNotNull(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        PsiMethod[] constructors = containingClass.getConstructors();
        if (constructors.length == 0) {
            return false;
        }
        for (PsiMethod method : constructors) {
            if (DfaPsiUtil.getNotNullInitializedFields(method, containingClass).contains(field)) continue;
            return false;
        }
        return true;
    }

    private static Set<PsiField> getNotNullInitializedFields(final PsiMethod constructor, final PsiClass containingClass) {
        if (!constructor.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return Collections.emptySet();
        }
        PsiCodeBlock body2 = constructor.getBody();
        if (body2 == null) {
            return Collections.emptySet();
        }
        return (Set)CachedValuesManager.getCachedValue((PsiElement)constructor, (CachedValueProvider)new CachedValueProvider<Set<PsiField>>(){

            @NotNull
            public CachedValueProvider.Result<Set<PsiField>> compute() {
                final PsiCodeBlock body2 = constructor.getBody();
                final HashMap map2 = new HashMap();
                DataFlowRunner dfaRunner = new DataFlowRunner(constructor.getProject()){
                    PsiElement currentBlock;

                    private boolean isCallExposingNonInitializedFields(Instruction instruction) {
                        PsiExpression qualifier;
                        if (!(instruction instanceof MethodCallInstruction)) {
                            return false;
                        }
                        PsiCall call = ((MethodCallInstruction)instruction).getCallExpression();
                        if (call == null) {
                            return false;
                        }
                        if (call instanceof PsiNewExpression && this.canAccessFields((PsiExpression)call)) {
                            return true;
                        }
                        if (call instanceof PsiMethodCallExpression && ((qualifier = ((PsiMethodCallExpression)call).getMethodExpression().getQualifierExpression()) == null || this.canAccessFields(qualifier))) {
                            return true;
                        }
                        PsiExpressionList argumentList = call.getArgumentList();
                        if (argumentList != null) {
                            for (PsiExpression expression2 : argumentList.getExpressions()) {
                                if (!this.canAccessFields(expression2)) continue;
                                return true;
                            }
                        }
                        return false;
                    }

                    private boolean canAccessFields(PsiExpression expression2) {
                        PsiClass type2 = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType());
                        JBIterable typeContainers = JBIterable.generate((Object)type2, PsiClass::getContainingClass).takeWhile(c -> !c.hasModifierProperty("static"));
                        return typeContainers.contains((Object)containingClass);
                    }

                    @Override
                    @NotNull
                    protected List<DfaInstructionState> createInitialInstructionStates(@NotNull PsiElement psiBlock, @NotNull Collection<? extends DfaMemoryState> memStates, @NotNull ControlFlow flow) {
                        this.currentBlock = psiBlock;
                        return super.createInitialInstructionStates(psiBlock, memStates, flow);
                    }

                    @Override
                    protected DfaInstructionState @NotNull [] acceptInstruction(@NotNull InstructionVisitor visitor2, @NotNull DfaInstructionState instructionState) {
                        Instruction instruction = instructionState.getInstruction();
                        if (this.currentBlock == body2 && (this.isCallExposingNonInitializedFields(instruction) || instruction instanceof ReturnInstruction && !((ReturnInstruction)instruction).isViaException())) {
                            for (PsiField field : containingClass.getFields()) {
                                if (!instructionState.getMemoryState().isNotNull(this.getFactory().getVarFactory().createVariableValue((PsiVariable)field))) {
                                    map2.put(field, false);
                                    continue;
                                }
                                if (map2.containsKey(field)) continue;
                                map2.put(field, true);
                            }
                            return DfaInstructionState.EMPTY_ARRAY;
                        }
                        return super.acceptInstruction(visitor2, instructionState);
                    }
                };
                RunnerResult rc = dfaRunner.analyzeMethod((PsiElement)body2, new StandardInstructionVisitor());
                HashSet notNullFields = new HashSet();
                if (rc == RunnerResult.OK) {
                    for (Map.Entry entry : map2.entrySet()) {
                        if (!((Boolean)entry.getValue()).booleanValue()) continue;
                        notNullFields.add(entry.getKey());
                    }
                }
                return CachedValueProvider.Result.create(notNullFields, (Object[])new Object[]{constructor, PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
    }

    public static List<PsiExpression> findAllConstructorInitializers(PsiField field) {
        List result = ContainerUtil.createLockFreeCopyOnWriteList();
        ContainerUtil.addIfNotNull((Collection)result, (Object)field.getInitializer());
        PsiClass containingClass = field.getContainingClass();
        if (containingClass != null && !(containingClass instanceof PsiCompiledElement)) {
            result.addAll(DfaPsiUtil.getAllConstructorFieldInitializers(containingClass).get((Object)field));
        }
        return result;
    }

    private static MultiMap<PsiField, PsiExpression> getAllConstructorFieldInitializers(final PsiClass psiClass) {
        if (psiClass instanceof PsiCompiledElement) {
            return MultiMap.empty();
        }
        return (MultiMap)CachedValuesManager.getCachedValue((PsiElement)psiClass, (CachedValueProvider)new CachedValueProvider<MultiMap<PsiField, PsiExpression>>(){

            @NotNull
            public CachedValueProvider.Result<MultiMap<PsiField, PsiExpression>> compute() {
                final HashSet fieldNames = new HashSet();
                for (PsiField field : psiClass.getFields()) {
                    ContainerUtil.addIfNotNull(fieldNames, (Object)field.getName());
                }
                final MultiMap result = new MultiMap();
                JavaRecursiveElementWalkingVisitor visitor2 = new JavaRecursiveElementWalkingVisitor(){

                    public void visitAssignmentExpression(PsiAssignmentExpression assignment) {
                        PsiElement target;
                        super.visitAssignmentExpression(assignment);
                        PsiExpression lExpression = assignment.getLExpression();
                        PsiExpression rExpression = assignment.getRExpression();
                        if (rExpression != null && lExpression instanceof PsiReferenceExpression && fieldNames.contains(((PsiReferenceExpression)lExpression).getReferenceName()) && (target = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiField && ((PsiField)target).getContainingClass() == psiClass) {
                            result.putValue((Object)((PsiField)target), (Object)rExpression);
                        }
                    }
                };
                for (PsiMethod constructor : psiClass.getConstructors()) {
                    if (!constructor.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) continue;
                    constructor.accept((PsiElementVisitor)visitor2);
                }
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{psiClass});
            }
        });
    }

    @Nullable
    public static PsiElement getTopmostBlockInSameClass(@NotNull PsiElement position) {
        return (PsiElement)JBIterable.generate((Object)position, PsiElement::getParent).takeWhile(e -> !(e instanceof PsiMember) && !(e instanceof PsiFile) && !(e instanceof PsiLambdaExpression)).filter(e -> e instanceof PsiCodeBlock || e instanceof PsiExpression && e.getParent() instanceof PsiLambdaExpression).last();
    }

    @NotNull
    public static Collection<PsiExpression> getVariableAssignmentsInFile(@NotNull PsiVariable psiVariable, boolean literalsOnly, PsiElement place) {
        Ref modificationRef = Ref.create((Object)Boolean.FALSE);
        PsiElement codeBlock = place == null ? null : DfaPsiUtil.getTopmostBlockInSameClass(place);
        int placeOffset = codeBlock != null ? place.getTextRange().getStartOffset() : 0;
        PsiFile containingFile = psiVariable.getContainingFile();
        LocalSearchScope scope = new LocalSearchScope(new PsiElement[]{containingFile}, null, true);
        Collection references = ReferencesSearch.search((PsiElement)psiVariable, (SearchScope)scope).findAll();
        List list = ContainerUtil.mapNotNull((Collection)references, (Function)((NullableFunction)psiReference -> {
            if (((Boolean)modificationRef.get()).booleanValue()) {
                return null;
            }
            PsiElement parent = psiReference.getElement().getParent();
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                IElementType operation = assignmentExpression.getOperationTokenType();
                if (assignmentExpression.getLExpression() == psiReference) {
                    if (JavaTokenType.EQ.equals(operation)) {
                        PsiExpression rValue = assignmentExpression.getRExpression();
                        if (!literalsOnly || DfaPsiUtil.allOperandsAreLiterals(rValue)) {
                            if (PsiTreeUtil.isAncestor((PsiElement)codeBlock, (PsiElement)parent, (boolean)true) && placeOffset < parent.getTextRange().getStartOffset()) {
                                return null;
                            }
                            return rValue;
                        }
                        modificationRef.set((Object)Boolean.TRUE);
                    } else if (JavaTokenType.PLUSEQ.equals(operation)) {
                        modificationRef.set((Object)Boolean.TRUE);
                    }
                }
            }
            return null;
        }));
        if (((Boolean)modificationRef.get()).booleanValue()) {
            return Collections.emptyList();
        }
        PsiExpression initializer = psiVariable.getInitializer();
        if (initializer != null && (!literalsOnly || DfaPsiUtil.allOperandsAreLiterals(initializer))) {
            list = ContainerUtil.concat((List)list, Collections.singletonList(initializer));
        }
        return list;
    }

    private static boolean allOperandsAreLiterals(@Nullable PsiExpression expression2) {
        if (expression2 == null) {
            return false;
        }
        if (expression2 instanceof PsiLiteralExpression) {
            return true;
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            Stack stack = new Stack();
            stack.add((Object)expression2);
            while (!stack.isEmpty()) {
                PsiExpression psiExpression = (PsiExpression)stack.pop();
                if (psiExpression instanceof PsiPolyadicExpression) {
                    PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)psiExpression;
                    for (PsiExpression op : binaryExpression.getOperands()) {
                        stack.push((Object)op);
                    }
                    continue;
                }
                if (psiExpression instanceof PsiLiteralExpression) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @NotNull
    static Nullability getVarArgComponentNullability(PsiMethod method) {
        if (method != null) {
            PsiType type2;
            if (NON_NULL_VAR_ARG.methodMatches(method)) {
                return Nullability.NOT_NULL;
            }
            PsiParameter varArg = (PsiParameter)ArrayUtil.getLastElement((Object[])method.getParameterList().getParameters());
            if (varArg != null && (type2 = varArg.getType()) instanceof PsiEllipsisType) {
                PsiType componentType = ((PsiEllipsisType)type2).getComponentType();
                return DfaPsiUtil.getTypeNullability(componentType);
            }
        }
        return Nullability.UNKNOWN;
    }

    public static PsiType tryGenerify(PsiExpression expression2, PsiType type2) {
        PsiClass aClass;
        if (!(type2 instanceof PsiClassType)) {
            return type2;
        }
        PsiClassType classType = (PsiClassType)type2;
        if (!classType.isRaw()) {
            return classType;
        }
        PsiClass psiClass = classType.resolve();
        if (psiClass == null) {
            return classType;
        }
        PsiType expressionType = expression2.getType();
        if (!(expressionType instanceof PsiClassType)) {
            return classType;
        }
        PsiClassType result = GenericsUtil.getExpectedGenericType((PsiElement)expression2, (PsiClass)psiClass, (PsiClassType)((PsiClassType)expressionType));
        if (result.isRaw() && (aClass = result.resolve()) != null) {
            int length = aClass.getTypeParameters().length;
            PsiWildcardType wildcard = PsiWildcardType.createUnbounded((PsiManager)aClass.getManager());
            Object[] arguments = new PsiType[length];
            Arrays.fill(arguments, wildcard);
            return JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass, (PsiType[])arguments);
        }
        return result;
    }

    @NotNull
    public static DfType fromLiteral(@NotNull PsiLiteralExpression expr2) {
        PsiType type2 = expr2.getType();
        if (type2 == null) {
            return DfTypes.TOP;
        }
        if (PsiType.NULL.equals((Object)type2)) {
            return DfTypes.NULL;
        }
        Object value2 = expr2.getValue();
        if (value2 == null) {
            return DfTypes.typedObject(type2, Nullability.NOT_NULL);
        }
        return DfTypes.constant(value2, type2);
    }
}

