/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnimplementInterfaceAction
implements IntentionAction {
    private String myName = "Interface";

    @NotNull
    public String getText() {
        return JavaBundle.message((String)"intention.text.unimplement.0", (Object[])new Object[]{this.myName});
    }

    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"intention.family.unimplement.interface.class", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        PsiReference psiReference = TargetElementUtil.findReference((Editor)editor);
        if (psiReference == null) {
            return false;
        }
        PsiReferenceList referenceList = (PsiReferenceList)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiReferenceList.class);
        if (referenceList == null) {
            return false;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referenceList, PsiClass.class);
        if (psiClass == null) {
            return false;
        }
        if (psiClass.getExtendsList() != referenceList && psiClass.getImplementsList() != referenceList) {
            return false;
        }
        PsiJavaCodeReferenceElement referenceElement = UnimplementInterfaceAction.getTopLevelRef(psiReference, referenceList);
        if (referenceElement == null) {
            return false;
        }
        PsiElement target = referenceElement.resolve();
        if (!(target instanceof PsiClass)) {
            return false;
        }
        PsiClass targetClass = (PsiClass)target;
        this.myName = targetClass.isInterface() ? "Interface" : "Class";
        return true;
    }

    @Nullable
    private static PsiJavaCodeReferenceElement getTopLevelRef(PsiReference psiReference, PsiReferenceList referenceList) {
        PsiElement element = psiReference.getElement();
        while (element.getParent() != referenceList) {
            if ((element = element.getParent()) != null) continue;
            return null;
        }
        if (!(element instanceof PsiJavaCodeReferenceElement)) {
            return null;
        }
        return (PsiJavaCodeReferenceElement)element;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiMethod[] psiMethods;
        PsiReference psiReference = TargetElementUtil.findReference((Editor)editor);
        if (psiReference == null) {
            return;
        }
        PsiReferenceList referenceList = (PsiReferenceList)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiReferenceList.class);
        if (referenceList == null) {
            return;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referenceList, PsiClass.class);
        if (psiClass == null) {
            return;
        }
        if (psiClass.getExtendsList() != referenceList && psiClass.getImplementsList() != referenceList) {
            return;
        }
        PsiJavaCodeReferenceElement element = UnimplementInterfaceAction.getTopLevelRef(psiReference, referenceList);
        if (element == null) {
            return;
        }
        PsiElement target = element.resolve();
        if (!(target instanceof PsiClass)) {
            return;
        }
        PsiClass targetClass = (PsiClass)target;
        HashMap<PsiMethod, PsiMethod> implementations = new HashMap<PsiMethod, PsiMethod>();
        for (PsiMethod psiMethod : targetClass.getAllMethods()) {
            PsiMethod implementingMethod = MethodSignatureUtil.findMethodBySuperMethod((PsiClass)psiClass, (PsiMethod)psiMethod, (boolean)false);
            if (implementingMethod == null) continue;
            implementations.put(psiMethod, implementingMethod);
        }
        element.delete();
        if (target == psiClass) {
            return;
        }
        HashSet superMethods = new HashSet();
        for (PsiClass aClass : psiClass.getSupers()) {
            Collections.addAll(superMethods, aClass.getAllMethods());
        }
        for (PsiMethod psiMethod : psiMethods = targetClass.getAllMethods()) {
            PsiMethod impl;
            if (superMethods.contains(psiMethod) || (impl = (PsiMethod)implementations.get(psiMethod)) == null) continue;
            impl.delete();
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

