/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class VariableTypeCanBeExplicitInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!PsiUtil.isLanguageLevel10OrHigher((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                ArrayList<PsiTypeElement> typeElements = new ArrayList<PsiTypeElement>();
                for (PsiParameter parameter2 : expression2.getParameterList().getParameters()) {
                    PsiTypeElement typeElement = this.getTypeElementToExpand((PsiVariable)parameter2);
                    if (typeElement == null) {
                        return;
                    }
                    typeElements.add(typeElement);
                }
                for (PsiTypeElement typeElement : typeElements) {
                    this.registerTypeElementProblem(typeElement);
                }
            }

            public void visitVariable(PsiVariable variable) {
                if (variable instanceof PsiParameter && ((PsiParameter)variable).getDeclarationScope() instanceof PsiLambdaExpression) {
                    return;
                }
                PsiTypeElement typeElement = this.getTypeElementToExpand(variable);
                if (typeElement != null) {
                    this.registerTypeElementProblem(typeElement);
                }
            }

            private void registerTypeElementProblem(PsiTypeElement typeElement) {
                holder.registerProblem((PsiElement)typeElement, JavaAnalysisBundle.message((String)"var.can.be.replaced.with.explicit.type", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceVarWithExplicitTypeFix()});
            }

            private PsiTypeElement getTypeElementToExpand(PsiVariable variable) {
                PsiType type2;
                PsiTypeElement typeElement = variable.getTypeElement();
                if (typeElement != null && typeElement.isInferredType() && PsiTypesUtil.isDenotableType((PsiType)(type2 = variable.getType()), (PsiElement)variable)) {
                    return typeElement;
                }
                return null;
            }
        };
    }

    private static class ReplaceVarWithExplicitTypeFix
    implements LocalQuickFix {
        private ReplaceVarWithExplicitTypeFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return JavaAnalysisBundle.message((String)"replace.var.with.explicit.type", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiTypeElement) {
                PsiElement declarationScope;
                PsiElement parent = element.getParent();
                if (parent instanceof PsiParameter && (declarationScope = ((PsiParameter)parent).getDeclarationScope()) instanceof PsiLambdaExpression) {
                    for (PsiParameter parameter2 : ((PsiLambdaExpression)declarationScope).getParameterList().getParameters()) {
                        PsiTypeElement typeElement = parameter2.getTypeElement();
                        if (typeElement == null) continue;
                        PsiTypesUtil.replaceWithExplicitType((PsiTypeElement)typeElement);
                    }
                    return;
                }
                PsiTypesUtil.replaceWithExplicitType((PsiTypeElement)((PsiTypeElement)element));
            }
        }
    }
}

