/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamFilterNotNullFix
implements LocalQuickFix,
HighPriorityAction {
    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"inspection.data.flow.filter.notnull.quickfix", (Object[])new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiFunctionalExpression function = StreamFilterNotNullFix.findFunction(descriptor.getStartElement());
        if (function == null) {
            return;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)function, PsiMethodCallExpression.class);
        if (call == null) {
            return;
        }
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (qualifier == null) {
            return;
        }
        String name2 = StreamFilterNotNullFix.suggestVariableName(function, qualifier);
        PsiExpression replacement = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(qualifier.getText() + ".filter(" + name2 + "->" + name2 + "!=null)", (PsiElement)qualifier);
        PsiMethodCallExpression result = (PsiMethodCallExpression)qualifier.replace((PsiElement)replacement);
        LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences((PsiElement)result.getArgumentList());
    }

    @NotNull
    private static String suggestVariableName(@NotNull PsiFunctionalExpression function, @NotNull PsiExpression qualifier) {
        PsiParameter parameter2;
        String name2 = null;
        if (function instanceof PsiLambdaExpression && (parameter2 = (PsiParameter)ArrayUtil.getFirstElement((Object[])((PsiLambdaExpression)function).getParameterList().getParameters())) != null) {
            name2 = parameter2.getName();
        }
        PsiType type2 = StreamApiUtil.getStreamElementType(qualifier.getType());
        return new VariableNameGenerator((PsiElement)qualifier, VariableKind.PARAMETER).byName(name2).byType(type2).byName("obj").generate(false);
    }

    @Nullable
    private static PsiFunctionalExpression findFunction(PsiElement reference) {
        if (reference instanceof PsiFunctionalExpression) {
            return (PsiFunctionalExpression)reference;
        }
        if (reference instanceof PsiIdentifier && (reference = reference.getParent()) instanceof PsiReferenceExpression) {
            reference = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiReferenceExpression)reference).getQualifierExpression());
        }
        if (reference instanceof PsiReferenceExpression) {
            PsiParameter parameter2 = (PsiParameter)ObjectUtils.tryCast((Object)((PsiReferenceExpression)reference).resolve(), PsiParameter.class);
            if (parameter2 == null) {
                return null;
            }
            PsiParameterList parameterList = (PsiParameterList)ObjectUtils.tryCast((Object)parameter2.getParent(), PsiParameterList.class);
            if (parameterList == null || parameterList.getParametersCount() != 1) {
                return null;
            }
            return (PsiFunctionalExpression)ObjectUtils.tryCast((Object)parameterList.getParent(), PsiLambdaExpression.class);
        }
        return null;
    }

    public static StreamFilterNotNullFix makeFix(PsiElement reference) {
        PsiFunctionalExpression fn = StreamFilterNotNullFix.findFunction(reference);
        if (fn == null) {
            return null;
        }
        PsiExpressionList args = (PsiExpressionList)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)fn.getParent()), PsiExpressionList.class);
        if (args == null || args.getExpressionCount() != 1) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)args.getParent(), PsiMethodCallExpression.class);
        if (call == null) {
            return null;
        }
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (qualifier == null || !InheritanceUtil.isInheritor((PsiType)qualifier.getType(), (String)"java.util.stream.Stream")) {
            return null;
        }
        return new StreamFilterNotNullFix();
    }
}

