/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.java.JavaBundle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class ReplaceWithTernaryOperatorFix
implements LocalQuickFix {
    private final String myText;

    @NotNull
    public String getName() {
        return JavaBundle.message((String)"inspection.replace.ternary.quickfix", (Object[])new Object[]{this.myText});
    }

    public ReplaceWithTernaryOperatorFix(@NotNull PsiExpression expressionToAssert) {
        this.myText = ParenthesesUtils.getText(expressionToAssert, 10);
    }

    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"inspection.surround.if.family", (Object[])new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement parent;
        PsiElement element = descriptor.getPsiElement();
        while ((parent = element.getParent()) instanceof PsiCallExpression || parent instanceof PsiJavaCodeReferenceElement) {
            element = parent;
        }
        if (!(element instanceof PsiExpression)) {
            return;
        }
        PsiExpression expression2 = (PsiExpression)element;
        PsiFile file = expression2.getContainingFile();
        PsiConditionalExpression conditionalExpression = ReplaceWithTernaryOperatorFix.replaceWithConditionalExpression(project, this.myText + "!=null", expression2, ReplaceWithTernaryOperatorFix.suggestDefaultValue(expression2));
        ReplaceWithTernaryOperatorFix.selectElseBranch(file, conditionalExpression);
    }

    static void selectElseBranch(PsiFile file, PsiConditionalExpression conditionalExpression) {
        Project project;
        Editor editor;
        PsiExpression elseExpression2 = conditionalExpression.getElseExpression();
        if (elseExpression2 != null && (editor = FileEditorManager.getInstance((Project)(project = file.getProject())).getSelectedTextEditor()) != null) {
            Document document = editor.getDocument();
            PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)file);
            if (topLevelFile != null && document == topLevelFile.getViewProvider().getDocument()) {
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
                TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)elseExpression2);
                builder.replaceElement((PsiElement)elseExpression2, (Expression)new ConstantNode(elseExpression2.getText()));
                builder.run(editor, true);
            }
        }
    }

    @NotNull
    private static PsiConditionalExpression replaceWithConditionalExpression(@NotNull Project project, @NotNull String condition2, @NotNull PsiExpression expression2, @NotNull String defaultValue) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiElement parent = expression2.getParent();
        PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)factory.createExpressionFromText(condition2 + " ? " + expression2.getText() + " : " + defaultValue, parent);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        return (PsiConditionalExpression)expression2.replace(codeStyleManager.reformat((PsiElement)conditionalExpression));
    }

    public static boolean isAvailable(@NotNull PsiExpression qualifier, @NotNull PsiExpression expression2) {
        if (!qualifier.isValid() || qualifier.getText() == null) {
            return false;
        }
        return !(expression2.getParent() instanceof PsiExpressionStatement) && !PsiUtil.isAccessedForWriting((PsiExpression)expression2);
    }

    private static String suggestDefaultValue(@NotNull PsiExpression expression2) {
        PsiType type2 = expression2.getType();
        return PsiTypesUtil.getDefaultValueOfType((PsiType)type2);
    }

    public static class ReplaceMethodRefWithTernaryOperatorFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"inspection.replace.methodref.ternary.quickfix", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodReferenceExpression element = (PsiMethodReferenceExpression)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), PsiMethodReferenceExpression.class);
            if (element == null) {
                return;
            }
            PsiLambdaExpression lambda2 = LambdaRefactoringUtil.convertMethodReferenceToLambda(element, false, true);
            if (lambda2 == null) {
                return;
            }
            PsiExpression expression2 = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
            if (expression2 == null) {
                return;
            }
            PsiParameter parameter2 = (PsiParameter)ArrayUtil.getFirstElement((Object[])lambda2.getParameterList().getParameters());
            if (parameter2 == null) {
                return;
            }
            String text2 = parameter2.getName();
            PsiFile file = expression2.getContainingFile();
            PsiConditionalExpression conditionalExpression = ReplaceWithTernaryOperatorFix.replaceWithConditionalExpression(project, text2 + "!=null", expression2, ReplaceWithTernaryOperatorFix.suggestDefaultValue(expression2));
            ReplaceWithTernaryOperatorFix.selectElseBranch(file, conditionalExpression);
        }
    }
}

