/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collection;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaCanBeMethodReferenceInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(LambdaCanBeMethodReferenceInspection.class);

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return InspectionsBundle.message((String)"group.names.language.level.specific.issues.and.migration.aids", (Object[])new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        return "Convert2MethodRef";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (!HighlightingFeature.LAMBDA_EXPRESSIONS.isAvailable((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                ProblemHighlightType type2;
                super.visitLambdaExpression(expression2);
                PsiElement body2 = expression2.getBody();
                PsiType functionalInterfaceType = expression2.getFunctionalInterfaceType();
                if (functionalInterfaceType == null) {
                    return;
                }
                MethodReferenceCandidate methodRefCandidate = LambdaCanBeMethodReferenceInspection.extractMethodReferenceCandidateExpression(body2);
                if (methodRefCandidate == null) {
                    return;
                }
                PsiExpression candidate = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem((PsiVariable[])expression2.getParameterList().getParameters(), functionalInterfaceType, null, methodRefCandidate.myExpression);
                if (candidate == null) {
                    return;
                }
                if (methodRefCandidate.mySafeQualifier && methodRefCandidate.myConformsCodeStyle) {
                    type2 = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                } else {
                    if (!isOnTheFly) {
                        return;
                    }
                    type2 = ProblemHighlightType.INFORMATION;
                }
                PsiLambdaExpression element = type2 == ProblemHighlightType.INFORMATION || InspectionProjectProfileManager.isInformationLevel((String)LambdaCanBeMethodReferenceInspection.this.getShortName(), (PsiElement)expression2) ? expression2 : candidate;
                holder.registerProblem(holder.getManager().createProblemDescriptor((PsiElement)element, LambdaCanBeMethodReferenceInspection.this.getDisplayName(), type2 != ProblemHighlightType.INFORMATION, type2, true, new LocalQuickFix[]{new ReplaceWithMethodRefFix(methodRefCandidate.mySafeQualifier ? "" : " (may change semantics)")}));
            }
        };
    }

    @Nullable
    public static PsiExpression canBeMethodReferenceProblem(@Nullable PsiElement body2, PsiVariable[] parameters2, PsiType functionalInterfaceType, @Nullable PsiElement context) {
        MethodReferenceCandidate methodRefCandidate = LambdaCanBeMethodReferenceInspection.extractMethodReferenceCandidateExpression(body2);
        if (methodRefCandidate == null || !methodRefCandidate.mySafeQualifier || !methodRefCandidate.myConformsCodeStyle) {
            return null;
        }
        return LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem(parameters2, functionalInterfaceType, context, methodRefCandidate.myExpression);
    }

    @Nullable
    public static PsiExpression canBeMethodReferenceProblem(PsiVariable @NotNull [] parameters2, @Nullable PsiType functionalInterfaceType, @Nullable PsiElement context, PsiExpression methodRefCandidate) {
        PsiNewExpression newExpression;
        if (functionalInterfaceType == null) {
            return null;
        }
        if (Stream.of(parameters2).anyMatch(LambdaCanBeMethodReferenceInspection::hasAnnotation)) {
            return null;
        }
        if (methodRefCandidate instanceof PsiNewExpression && ((newExpression = (PsiNewExpression)methodRefCandidate).getAnonymousClass() != null || newExpression.getArrayInitializer() != null)) {
            return null;
        }
        String methodReferenceText = LambdaCanBeMethodReferenceInspection.createMethodReferenceText((PsiElement)methodRefCandidate, functionalInterfaceType, parameters2);
        if (methodReferenceText != null) {
            PsiMethodReferenceExpression methodReferenceExpression;
            LOG.assertTrue(methodRefCandidate != null);
            if (!(methodRefCandidate instanceof PsiCallExpression)) {
                return methodRefCandidate;
            }
            PsiCallExpression callExpression = (PsiCallExpression)methodRefCandidate;
            PsiMethod method = callExpression.resolveMethod();
            if (method != null) {
                if (!LambdaCanBeMethodReferenceInspection.isSimpleCall(parameters2, callExpression, method)) {
                    return null;
                }
            } else {
                LOG.assertTrue(callExpression instanceof PsiNewExpression);
                if (((PsiNewExpression)callExpression).getQualifier() != null) {
                    return null;
                }
                PsiExpression[] dims = ((PsiNewExpression)callExpression).getArrayDimensions();
                if (dims.length == 1 && parameters2.length == 1 ? !ExpressionUtils.isReferenceTo(dims[0], parameters2[0]) : dims.length > 0) {
                    return null;
                }
                if (callExpression.getTypeArguments().length > 0) {
                    return null;
                }
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)callExpression.getProject());
            try {
                methodReferenceExpression = (PsiMethodReferenceExpression)elementFactory.createExpressionFromText(methodReferenceText, (PsiElement)(context != null ? context : callExpression));
            }
            catch (IncorrectOperationException | ClassCastException e) {
                LOG.error(callExpression.getText(), e);
                return null;
            }
            return (PsiExpression)LambdaUtil.performWithTargetType((PsiElement)methodReferenceExpression, (PsiType)functionalInterfaceType, () -> {
                JavaResolveResult result = methodReferenceExpression.advancedResolve(false);
                PsiElement element = result.getElement();
                if (element != null && result.isAccessible() && (!(result instanceof MethodCandidateInfo) || ((MethodCandidateInfo)result).isApplicable())) {
                    if (!(element instanceof PsiMethod)) {
                        return callExpression;
                    }
                    return method != null && MethodSignatureUtil.areSignaturesEqual((PsiMethod)((PsiMethod)element), (PsiMethod)method) ? callExpression : null;
                }
                return null;
            });
        }
        return null;
    }

    private static boolean isSimpleCall(PsiVariable[] parameters2, PsiCallExpression callExpression, PsiMethod psiMethod) {
        int offset;
        PsiExpressionList argumentList = callExpression.getArgumentList();
        if (argumentList == null) {
            return false;
        }
        int calledParametersCount = psiMethod.getParameterList().getParametersCount();
        PsiExpression[] expressions2 = argumentList.getExpressions();
        Object qualifier = callExpression instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)callExpression).getMethodExpression().getQualifierExpression() : (callExpression instanceof PsiNewExpression ? ((PsiNewExpression)callExpression).getQualifier() : null);
        if (expressions2.length == 0 && parameters2.length == 0) {
            return !(callExpression instanceof PsiNewExpression) || qualifier == null;
        }
        int n = offset = parameters2.length > 0 && ExpressionUtils.isReferenceTo(qualifier, parameters2[0]) ? 1 : 0;
        if (parameters2.length != expressions2.length + offset) {
            return false;
        }
        if (psiMethod.isVarArgs() ? expressions2.length < calledParametersCount - 1 : expressions2.length != calledParametersCount) {
            return false;
        }
        for (int i = 0; i < expressions2.length; ++i) {
            if (ExpressionUtils.isReferenceTo(expressions2[i], parameters2[i + offset])) continue;
            return false;
        }
        if (offset == 0 && qualifier != null) {
            return SyntaxTraverser.psiTraverser((PsiElement)qualifier).filter(PsiReferenceExpression.class).map(PsiReference::resolve).filter(target -> ArrayUtil.find((Object[])parameters2, (Object)target) >= 0).first() == null;
        }
        return true;
    }

    @Nullable
    static MethodReferenceCandidate extractMethodReferenceCandidateExpression(PsiElement body2) {
        PsiExpression expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)LambdaUtil.extractSingleExpressionFromBody((PsiElement)body2));
        if (expression2 == null) {
            return null;
        }
        if (expression2 instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)expression2;
            if (newExpression.getQualifier() != null || newExpression.getAnonymousClass() != null || newExpression.getArrayInitializer() != null) {
                return null;
            }
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList != null) {
                for (PsiExpression arg : argumentList.getExpressions()) {
                    if (LambdaCanBeMethodReferenceInspection.isMethodReferenceArgCandidate(arg)) continue;
                    return null;
                }
            }
            return new MethodReferenceCandidate(expression2, true, true);
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            for (PsiExpression arg : ((PsiMethodCallExpression)expression2).getArgumentList().getExpressions()) {
                if (LambdaCanBeMethodReferenceInspection.isMethodReferenceArgCandidate(arg)) continue;
                return null;
            }
            return new MethodReferenceCandidate(expression2, LambdaCanBeMethodReferenceInspection.checkQualifier(((PsiMethodCallExpression)expression2).getMethodExpression().getQualifier()), true);
        }
        JavaCodeStyleSettings javaSettings = JavaCodeStyleSettings.getInstance(expression2.getContainingFile());
        if (expression2 instanceof PsiInstanceOfExpression) {
            if (!LambdaCanBeMethodReferenceInspection.isMethodReferenceArgCandidate(((PsiInstanceOfExpression)expression2).getOperand())) {
                return null;
            }
            return new MethodReferenceCandidate(expression2, true, javaSettings.REPLACE_INSTANCEOF_AND_CAST);
        }
        if (expression2 instanceof PsiBinaryExpression) {
            PsiBinaryExpression binOp = (PsiBinaryExpression)expression2;
            PsiExpression comparedWithNull = PsiUtil.skipParenthesizedExprDown((PsiExpression)ExpressionUtils.getValueComparedWithNull(binOp));
            if (LambdaCanBeMethodReferenceInspection.isMethodReferenceArgCandidate(comparedWithNull)) {
                return new MethodReferenceCandidate(expression2, true, javaSettings.REPLACE_NULL_CHECK);
            }
            if (binOp.getOperationTokenType().equals(JavaTokenType.PLUS) && LambdaCanBeMethodReferenceInspection.isMethodReferenceArgCandidate(binOp.getLOperand()) && LambdaCanBeMethodReferenceInspection.isMethodReferenceArgCandidate(binOp.getROperand())) {
                return new MethodReferenceCandidate(expression2, true, javaSettings.REPLACE_SUM);
            }
        } else if (expression2 instanceof PsiTypeCastExpression) {
            if (!LambdaCanBeMethodReferenceInspection.isMethodReferenceArgCandidate(((PsiTypeCastExpression)expression2).getOperand())) {
                return null;
            }
            PsiTypeElement typeElement = ((PsiTypeCastExpression)expression2).getCastType();
            if (typeElement != null) {
                PsiJavaCodeReferenceElement refs = typeElement.getInnermostComponentReferenceElement();
                if (refs != null && refs.getParameterList() != null && refs.getParameterList().getTypeParameterElements().length != 0) {
                    return null;
                }
                PsiType type2 = typeElement.getType();
                if (type2 instanceof PsiPrimitiveType || PsiUtil.resolveClassInType((PsiType)type2) instanceof PsiTypeParameter) {
                    return null;
                }
                return new MethodReferenceCandidate(expression2, true, javaSettings.REPLACE_INSTANCEOF_AND_CAST);
            }
        }
        return null;
    }

    private static boolean isMethodReferenceArgCandidate(PsiExpression arg) {
        return (arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)arg)) instanceof PsiReferenceExpression && ((PsiReferenceExpression)arg).getQualifier() == null;
    }

    public static void replaceAllLambdasWithMethodReferences(PsiElement root) {
        Collection lambdas = PsiTreeUtil.findChildrenOfType((PsiElement)root, PsiLambdaExpression.class);
        if (!lambdas.isEmpty()) {
            for (PsiLambdaExpression lambda2 : lambdas) {
                LambdaCanBeMethodReferenceInspection.replaceLambdaWithMethodReference(lambda2);
            }
        }
    }

    @NotNull
    public static PsiExpression replaceLambdaWithMethodReference(@NotNull PsiLambdaExpression lambda2) {
        MethodReferenceCandidate methodRefCandidate = LambdaCanBeMethodReferenceInspection.extractMethodReferenceCandidateExpression(lambda2.getBody());
        if (methodRefCandidate == null || !methodRefCandidate.mySafeQualifier || !methodRefCandidate.myConformsCodeStyle) {
            return lambda2;
        }
        PsiExpression candidate = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem((PsiVariable[])lambda2.getParameterList().getParameters(), lambda2.getFunctionalInterfaceType(), (PsiElement)lambda2, methodRefCandidate.myExpression);
        return LambdaCanBeMethodReferenceInspection.tryConvertToMethodReference(lambda2, (PsiElement)candidate);
    }

    public static boolean checkQualifier(@Nullable PsiElement qualifier) {
        if (qualifier == null) {
            return true;
        }
        Condition callExpressionCondition = Conditions.instanceOf((Class[])new Class[]{PsiCallExpression.class, PsiArrayAccessExpression.class});
        Condition nonFinalFieldRefCondition = expression2 -> {
            PsiElement element;
            return expression2 instanceof PsiReferenceExpression && !(expression2.getParent() instanceof PsiCallExpression) && (element = ((PsiReferenceExpression)expression2).resolve()) instanceof PsiField && !((PsiField)element).hasModifierProperty("final");
        };
        return ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)qualifier)).filter(Conditions.or((Condition)callExpressionCondition, (Condition)nonFinalFieldRefCondition))).toList().isEmpty();
    }

    @Nullable
    private static PsiMethod getNonAmbiguousReceiver(PsiVariable[] parameters2, @NotNull PsiMethod psiMethod) {
        String methodName = psiMethod.getName();
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        PsiMethod[] psiMethods = containingClass.findMethodsByName(methodName, false);
        if (psiMethods.length == 1) {
            return psiMethod;
        }
        PsiType receiverType2 = parameters2[0].getType();
        for (PsiMethod method : psiMethods) {
            if (!LambdaCanBeMethodReferenceInspection.isPairedNoReceiver(parameters2, receiverType2, method)) continue;
            PsiMethod[] deepestSuperMethods = psiMethod.findDeepestSuperMethods();
            if (deepestSuperMethods.length > 0) {
                for (PsiMethod superMethod : deepestSuperMethods) {
                    PsiMethod validSuperMethod = LambdaCanBeMethodReferenceInspection.getNonAmbiguousReceiver(parameters2, superMethod);
                    if (validSuperMethod == null) continue;
                    return validSuperMethod;
                }
            }
            return null;
        }
        return psiMethod;
    }

    private static boolean isPairedNoReceiver(PsiVariable[] parameters2, PsiType receiverType2, PsiMethod method) {
        PsiParameter[] nonReceiverCandidateParams = method.getParameterList().getParameters();
        return nonReceiverCandidateParams.length == parameters2.length && method.hasModifierProperty("static") && TypeConversionUtil.areTypesConvertible((PsiType)nonReceiverCandidateParams[0].getType(), (PsiType)receiverType2);
    }

    private static boolean isSoleParameter(PsiVariable @NotNull [] parameters2, @Nullable PsiExpression expression2) {
        expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2);
        return parameters2.length == 1 && expression2 instanceof PsiReferenceExpression && parameters2[0] == ((PsiReferenceExpression)expression2).resolve();
    }

    @Nullable
    static String createMethodReferenceText(PsiElement element, PsiType functionalInterfaceType, PsiVariable[] parameters2) {
        PsiTypeElement type2;
        PsiTypeCastExpression castExpression;
        if (element instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)element;
            JavaResolveResult result = methodCall.resolveMethodGenerics();
            PsiMethod psiMethod = (PsiMethod)result.getElement();
            if (psiMethod == null) {
                return null;
            }
            PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
            String qualifierByMethodCall = LambdaCanBeMethodReferenceInspection.getQualifierTextByMethodCall(methodCall, functionalInterfaceType, parameters2, psiMethod, result.getSubstitutor());
            if (qualifierByMethodCall != null) {
                return qualifierByMethodCall + "::" + ((PsiMethodCallExpression)element).getTypeArgumentList().getText() + methodExpression.getReferenceName();
            }
        } else if (element instanceof PsiNewExpression) {
            String qualifierByNew = LambdaCanBeMethodReferenceInspection.getQualifierTextByNewExpression((PsiNewExpression)element);
            if (qualifierByNew != null) {
                return qualifierByNew + ((PsiNewExpression)element).getTypeArgumentList().getText() + "::new";
            }
        } else if (element instanceof PsiInstanceOfExpression) {
            PsiTypeElement type3;
            if (LambdaCanBeMethodReferenceInspection.isSoleParameter(parameters2, ((PsiInstanceOfExpression)element).getOperand()) && (type3 = ((PsiInstanceOfExpression)element).getCheckType()) != null) {
                return type3.getText() + ".class::isInstance";
            }
        } else if (element instanceof PsiBinaryExpression) {
            PsiBinaryExpression binOp = (PsiBinaryExpression)element;
            PsiExpression operand2 = ExpressionUtils.getValueComparedWithNull(binOp);
            if (operand2 != null && LambdaCanBeMethodReferenceInspection.isSoleParameter(parameters2, operand2)) {
                IElementType tokenType = binOp.getOperationTokenType();
                if (JavaTokenType.EQEQ.equals(tokenType)) {
                    return "java.util.Objects::isNull";
                }
                if (JavaTokenType.NE.equals(tokenType)) {
                    return "java.util.Objects::nonNull";
                }
            }
            if (binOp.getOperationTokenType().equals(JavaTokenType.PLUS)) {
                PsiType type4;
                PsiExpression left = binOp.getLOperand();
                PsiExpression right = binOp.getROperand();
                if (parameters2.length == 2 && (ExpressionUtils.isReferenceTo(left, parameters2[0]) && ExpressionUtils.isReferenceTo(right, parameters2[1]) || ExpressionUtils.isReferenceTo(left, parameters2[1]) && ExpressionUtils.isReferenceTo(right, parameters2[0])) && (type4 = binOp.getType()) instanceof PsiPrimitiveType && TypeConversionUtil.isNumericType((PsiType)type4)) {
                    return ((PsiPrimitiveType)type4).getBoxedTypeName() + "::sum";
                }
            }
        } else if (element instanceof PsiTypeCastExpression && LambdaCanBeMethodReferenceInspection.isSoleParameter(parameters2, (castExpression = (PsiTypeCastExpression)element).getOperand()) && (type2 = castExpression.getCastType()) != null) {
            return type2.getText() + ".class::cast";
        }
        return null;
    }

    private static String getQualifierTextByNewExpression(PsiNewExpression element) {
        PsiType deepComponentType;
        JavaResolveResult resolve2;
        PsiElement resolveElement;
        PsiType newExprType = element.getType();
        if (newExprType == null) {
            return null;
        }
        PsiClass containingClass = null;
        PsiJavaCodeReferenceElement classReference2 = element.getClassOrAnonymousClassReference();
        if (classReference2 != null && (resolveElement = (resolve2 = classReference2.advancedResolve(false)).getElement()) instanceof PsiClass) {
            containingClass = (PsiClass)resolveElement;
        }
        String classOrPrimitiveName = null;
        if (containingClass != null) {
            classOrPrimitiveName = LambdaCanBeMethodReferenceInspection.getClassReferenceName(containingClass);
        } else if (newExprType instanceof PsiArrayType && (deepComponentType = newExprType.getDeepComponentType()) instanceof PsiPrimitiveType) {
            classOrPrimitiveName = deepComponentType.getCanonicalText();
        }
        if (classOrPrimitiveName == null) {
            return null;
        }
        return classOrPrimitiveName + StringUtil.repeat((String)"[]", (int)newExprType.getArrayDimensions());
    }

    @Nullable
    private static String getQualifierTextByMethodCall(PsiMethodCallExpression methodCall, PsiType functionalInterfaceType, PsiVariable[] parameters2, PsiMethod psiMethod, PsiSubstitutor substitutor) {
        PsiExpression qualifierExpression2 = methodCall.getMethodExpression().getQualifierExpression();
        PsiClass containingClass = psiMethod.getContainingClass();
        LOG.assertTrue(containingClass != null);
        if (qualifierExpression2 != null) {
            boolean isReceiverType = false;
            if (ExpressionUtils.isReferenceTo(qualifierExpression2, (PsiVariable)ArrayUtil.getFirstElement((Object[])parameters2))) {
                PsiType type2 = PsiMethodReferenceUtil.getFirstParameterType((PsiType)functionalInterfaceType, (PsiElement)qualifierExpression2);
                isReceiverType = PsiMethodReferenceUtil.isReceiverType((PsiType)type2, (PsiClass)containingClass, (PsiSubstitutor)substitutor);
            }
            return isReceiverType ? LambdaCanBeMethodReferenceInspection.composeReceiverQualifierText(parameters2, psiMethod, containingClass, qualifierExpression2) : qualifierExpression2.getText();
        }
        if (psiMethod.hasModifierProperty("static")) {
            return LambdaCanBeMethodReferenceInspection.getClassReferenceName(containingClass);
        }
        PsiClass parentContainingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiClass.class);
        if (parentContainingClass instanceof PsiAnonymousClass) {
            parentContainingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parentContainingClass, PsiClass.class, (boolean)true);
        }
        PsiClass treeContainingClass = parentContainingClass;
        while (treeContainingClass != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)treeContainingClass, (PsiClass)containingClass, (boolean)true)) {
            treeContainingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)treeContainingClass, PsiClass.class, (boolean)true);
        }
        if (treeContainingClass != null && containingClass != parentContainingClass && treeContainingClass != parentContainingClass) {
            String treeContainingClassName = treeContainingClass.getName();
            if (treeContainingClassName == null) {
                return null;
            }
            return treeContainingClassName + ".this";
        }
        return "this";
    }

    @Nullable
    private static String composeReceiverQualifierText(PsiVariable[] parameters2, PsiMethod psiMethod, PsiClass containingClass, @NotNull PsiExpression qualifierExpression2) {
        if (psiMethod.hasModifierProperty("static")) {
            return null;
        }
        PsiMethod nonAmbiguousMethod = LambdaCanBeMethodReferenceInspection.getNonAmbiguousReceiver(parameters2, psiMethod);
        if (nonAmbiguousMethod == null) {
            return null;
        }
        PsiClass nonAmbiguousContainingClass = nonAmbiguousMethod.getContainingClass();
        if (nonAmbiguousContainingClass != null && !containingClass.equals(nonAmbiguousContainingClass)) {
            return LambdaCanBeMethodReferenceInspection.getClassReferenceName(nonAmbiguousContainingClass);
        }
        if (containingClass.isPhysical() && !PsiTypesUtil.isGetClass((PsiMethod)psiMethod) && ExpressionUtils.isReferenceTo(qualifierExpression2, (PsiVariable)ArrayUtil.getFirstElement((Object[])parameters2))) {
            return LambdaCanBeMethodReferenceInspection.getClassReferenceName(containingClass);
        }
        PsiType qualifierExpressionType = qualifierExpression2.getType();
        if (qualifierExpressionType != null && !FunctionalInterfaceParameterizationUtil.isWildcardParameterized(qualifierExpressionType)) {
            try {
                String canonicalText = qualifierExpressionType.getCanonicalText();
                JavaPsiFacade.getElementFactory((Project)containingClass.getProject()).createExpressionFromText(canonicalText + "::foo", (PsiElement)qualifierExpression2);
                return canonicalText;
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        }
        return LambdaCanBeMethodReferenceInspection.getClassReferenceName(containingClass);
    }

    private static String getClassReferenceName(PsiClass containingClass) {
        String qualifiedName = containingClass.getQualifiedName();
        if (qualifiedName != null) {
            return qualifiedName;
        }
        return containingClass.getName();
    }

    private static boolean hasAnnotation(PsiVariable p) {
        if (p.getAnnotations().length > 0) {
            return true;
        }
        PsiTypeElement typeElement = p.getTypeElement();
        return typeElement != null && !typeElement.isInferredType() && PsiTypesUtil.hasTypeAnnotation((PsiType)typeElement.getType());
    }

    @NotNull
    static PsiExpression tryConvertToMethodReference(@NotNull PsiLambdaExpression lambda2, PsiElement body2) {
        Project project = lambda2.getProject();
        PsiType functionalInterfaceType = lambda2.getFunctionalInterfaceType();
        if (functionalInterfaceType == null || !functionalInterfaceType.isValid()) {
            return lambda2;
        }
        PsiType denotableFunctionalInterfaceType = RefactoringChangeUtil.getTypeByExpression((PsiExpression)lambda2);
        if (denotableFunctionalInterfaceType == null) {
            return lambda2;
        }
        String methodRefText = LambdaCanBeMethodReferenceInspection.createMethodReferenceText(body2, functionalInterfaceType, (PsiVariable[])lambda2.getParameterList().getParameters());
        if (methodRefText != null) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiExpression psiExpression = factory.createExpressionFromText(methodRefText, (PsiElement)lambda2);
            SmartTypePointer typePointer = SmartTypePointerManager.getInstance((Project)project).createSmartTypePointer(denotableFunctionalInterfaceType);
            PsiExpression replace = (PsiExpression)new CommentTracker().replaceAndRestoreComments((PsiElement)lambda2, (PsiElement)psiExpression);
            if (!(replace instanceof PsiMethodReferenceExpression)) {
                LOG.error("Generated code is not method reference: " + replace.getClass(), new Attachment[]{new Attachment("replacement.txt", replace.getText()), new Attachment("origtext.txt", methodRefText)});
                return lambda2;
            }
            PsiType functionalTypeAfterReplacement = GenericsUtil.getVariableTypeByExpressionType((PsiType)((PsiMethodReferenceExpression)replace).getFunctionalInterfaceType());
            functionalInterfaceType = typePointer.getType();
            if (!(functionalInterfaceType == null || functionalTypeAfterReplacement != null && functionalTypeAfterReplacement.equals(functionalInterfaceType))) {
                PsiTypeCastExpression cast = (PsiTypeCastExpression)factory.createExpressionFromText("(A)a", (PsiElement)replace);
                PsiTypeElement castType = cast.getCastType();
                LOG.assertTrue(castType != null);
                castType.replace((PsiElement)factory.createTypeElement(functionalInterfaceType));
                PsiExpression castOperand = cast.getOperand();
                LOG.assertTrue(castOperand != null);
                castOperand.replace((PsiElement)replace);
                replace = (PsiExpression)replace.replace((PsiElement)cast);
            }
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)replace);
            return replace;
        }
        return lambda2;
    }

    static class MethodReferenceCandidate {
        final PsiExpression myExpression;
        final boolean mySafeQualifier;
        final boolean myConformsCodeStyle;

        MethodReferenceCandidate(PsiExpression expression2, boolean safeQualifier, boolean conformsCodeStyle) {
            this.myExpression = expression2;
            this.mySafeQualifier = safeQualifier;
            this.myConformsCodeStyle = conformsCodeStyle;
        }
    }

    private static class ReplaceWithMethodRefFix
    implements LocalQuickFix {
        private final String mySuffix;

        ReplaceWithMethodRefFix(String suffix) {
            this.mySuffix = suffix;
        }

        @Nls
        @NotNull
        public String getName() {
            return this.getFamilyName() + this.mySuffix;
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("replace.with.method.ref.fix.family.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiLambdaExpression lambdaExpression;
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiLambdaExpression) {
                MethodReferenceCandidate methodReferenceCandidate = LambdaCanBeMethodReferenceInspection.extractMethodReferenceCandidateExpression(((PsiLambdaExpression)element).getBody());
                if (methodReferenceCandidate == null) {
                    return;
                }
                element = methodReferenceCandidate.myExpression;
            }
            if ((lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class)) == null) {
                return;
            }
            LambdaCanBeMethodReferenceInspection.tryConvertToMethodReference(lambdaExpression, element);
        }
    }
}

