/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EndlessStreamInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Set<String> ALL_CONSUMING_OPERATIONS = ContainerUtil.set((Object[])new String[]{"sorted", "count", "reduce", "max", "min", "sum", "average", "collect", "toArray", "forEach", "summaryStatistics"});
    private static final Set<String> NON_LIMITING_OPERATIONS = ContainerUtil.set((Object[])new String[]{"filter", "map", "distinct", "flatMap", "flatMapToInt", "flatMapToLong", "flatMapToDouble", "flatMapToObj", "onClose", "peek", "skip", "dropWhile", "mapToDouble", "mapToLong", "mapToObj", "mapToInt", "parallel", "boxed", "sequential", "unordered", "asLongStream", "asDoubleStream"});
    private static final CallMatcher INFINITE_SOURCE = CallMatcher.anyOf(CallMatcher.staticCall("java.util.stream.IntStream", "generate").parameterCount(1), CallMatcher.staticCall("java.util.stream.IntStream", "iterate").parameterCount(2), CallMatcher.staticCall("java.util.stream.LongStream", "generate").parameterCount(1), CallMatcher.staticCall("java.util.stream.LongStream", "iterate").parameterCount(2), CallMatcher.staticCall("java.util.stream.DoubleStream", "generate").parameterCount(1), CallMatcher.staticCall("java.util.stream.DoubleStream", "iterate").parameterCount(2), CallMatcher.staticCall("java.util.stream.Stream", "generate").parameterCount(1), CallMatcher.staticCall("java.util.stream.Stream", "iterate").parameterCount(2), CallMatcher.instanceCall("java.util.Random", "ints", "longs", "doubles").parameterCount(2), CallMatcher.instanceCall("java.util.Random", "ints", "longs", "doubles").parameterCount(0));

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                if (!INFINITE_SOURCE.test(call)) {
                    return;
                }
                PsiMethodCallExpression allConsumingCall = StreamApiUtil.findSubsequentCall(call, name2 -> ALL_CONSUMING_OPERATIONS.contains(name2), name2 -> NON_LIMITING_OPERATIONS.contains(name2));
                if (allConsumingCall == null) {
                    return;
                }
                PsiElement nameElement = allConsumingCall.getMethodExpression().getReferenceNameElement();
                if (nameElement == null) {
                    return;
                }
                holder.registerProblem(nameElement, JavaBundle.message((String)"inspection.endless.stream.description", (Object[])new Object[0]), new LocalQuickFix[0]);
            }
        };
    }
}

