/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates.editable;

import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.editable.EditablePostfixTemplateWithMultipleExpressions;
import com.intellij.codeInsight.template.postfix.templates.editable.JavaPostfixTemplateExpressionCondition;
import com.intellij.codeInsight.template.postfix.util.JavaPostfixTemplatesUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaEditablePostfixTemplate
extends EditablePostfixTemplateWithMultipleExpressions<JavaPostfixTemplateExpressionCondition> {
    private static final Condition<PsiElement> PSI_ERROR_FILTER = element -> !PsiTreeUtil.hasErrorElements((PsiElement)element);
    @NotNull
    private final LanguageLevel myMinimumLanguageLevel;

    public JavaEditablePostfixTemplate(@NotNull String templateName, @NotNull String templateText, @NotNull String example, @NotNull Set<JavaPostfixTemplateExpressionCondition> expressionConditions, @NotNull LanguageLevel minimumLanguageLevel, boolean useTopmostExpression, @NotNull PostfixTemplateProvider provider) {
        this(templateName, templateName, JavaEditablePostfixTemplate.createTemplate((String)templateText), example, expressionConditions, minimumLanguageLevel, useTopmostExpression, provider);
    }

    public JavaEditablePostfixTemplate(@NotNull String templateId, @NotNull String templateName, @NotNull String templateText, @NotNull String example, @NotNull Set<JavaPostfixTemplateExpressionCondition> expressionConditions, @NotNull LanguageLevel minimumLanguageLevel, boolean useTopmostExpression, @NotNull PostfixTemplateProvider provider) {
        super(templateId, templateName, JavaEditablePostfixTemplate.createTemplate((String)templateText), example, expressionConditions, useTopmostExpression, provider);
        this.myMinimumLanguageLevel = minimumLanguageLevel;
    }

    public JavaEditablePostfixTemplate(@NotNull String templateId, @NotNull String templateName, @NotNull TemplateImpl liveTemplate, @NotNull String example, @NotNull Set<JavaPostfixTemplateExpressionCondition> expressionConditions, @NotNull LanguageLevel minimumLanguageLevel, boolean useTopmostExpression, @NotNull PostfixTemplateProvider provider) {
        super(templateId, templateName, liveTemplate, example, expressionConditions, useTopmostExpression, provider);
        this.myMinimumLanguageLevel = minimumLanguageLevel;
    }

    @NotNull
    public LanguageLevel getMinimumLanguageLevel() {
        return this.myMinimumLanguageLevel;
    }

    protected List<PsiElement> getExpressions(@NotNull PsiElement context, @NotNull Document document, int offset) {
        ArrayList<PsiExpression> expressions2;
        if (DumbService.getInstance((Project)context.getProject()).isDumb()) {
            return Collections.emptyList();
        }
        if (!PsiUtil.getLanguageLevel((PsiElement)context).isAtLeast(this.myMinimumLanguageLevel)) {
            return Collections.emptyList();
        }
        if (this.myUseTopmostExpression) {
            expressions2 = ContainerUtil.createMaybeSingletonList((Object)JavaPostfixTemplatesUtils.getTopmostExpression(context));
        } else {
            PsiFile file = context.getContainingFile();
            expressions2 = new ArrayList<PsiExpression>(IntroduceVariableBase.collectExpressions(file, document, Math.max(offset - 1, 0), false));
        }
        return ContainerUtil.filter((Collection)expressions2, (Condition)Conditions.and(e -> PSI_ERROR_FILTER.value(e) && e instanceof PsiExpression && e.getTextRange().getEndOffset() == offset, (Condition)this.getExpressionCompositeCondition()));
    }

    @NotNull
    protected PsiElement getTopmostExpression(@NotNull PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof PsiExpressionStatement) {
            return parent;
        }
        return element;
    }

    @NotNull
    protected Function<PsiElement, String> getElementRenderer() {
        return JavaPostfixTemplatesUtils.getRenderer();
    }

    public boolean isBuiltin() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JavaEditablePostfixTemplate template = (JavaEditablePostfixTemplate)((Object)o);
        return this.myMinimumLanguageLevel == template.myMinimumLanguageLevel;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myMinimumLanguageLevel);
    }
}

