/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.codeInsight.template.macro.SuggestVariableNameMacro;
import com.intellij.codeInsight.template.postfix.templates.JavaPostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.editable.JavaEditablePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.editable.JavaPostfixTemplateExpressionCondition;
import com.intellij.codeInsight.template.postfix.util.JavaPostfixTemplatesUtils;
import com.intellij.openapi.util.Condition;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ForIndexedPostfixTemplate
extends JavaEditablePostfixTemplate {
    @Deprecated
    public static final Condition<PsiElement> IS_NUMBER_OR_ARRAY_OR_ITERABLE = element -> JavaPostfixTemplatesUtils.IS_ITERABLE_OR_ARRAY.value(element) || JavaPostfixTemplatesUtils.IS_NUMBER.value(element);

    protected ForIndexedPostfixTemplate(@NotNull String templateName, @NotNull String templateText, @NotNull String example, @NotNull JavaPostfixTemplateProvider provider) {
        super(templateName, templateText, example, ContainerUtil.newHashSet((Object[])new JavaPostfixTemplateExpressionCondition[]{new JavaPostfixTemplateExpressionCondition.JavaPostfixTemplateArrayExpressionCondition(), new JavaPostfixTemplateExpressionCondition.JavaPostfixTemplateNumberExpressionCondition(), new JavaPostfixTemplateExpressionCondition.JavaPostfixTemplateExpressionFqnCondition("java.lang.Iterable")}), LanguageLevel.JDK_1_3, true, provider);
    }

    protected void addTemplateVariables(@NotNull PsiElement element, @NotNull Template template) {
        super.addTemplateVariables(element, template);
        MacroCallNode index = new MacroCallNode((Macro)new SuggestVariableNameMacro());
        template.addVariable("index", (Expression)index, (Expression)index, true);
        PsiExpression expr2 = (PsiExpression)element;
        String bound = this.getExpressionBound(expr2);
        if (bound != null) {
            template.addVariable("bound", (Expression)new TextExpression(bound), false);
            template.addVariable("type", (Expression)new TextExpression(ForIndexedPostfixTemplate.suggestIndexType(expr2)), false);
        }
    }

    @Nullable
    protected String getExpressionBound(@NotNull PsiExpression expr2) {
        PsiType type2 = expr2.getType();
        if (JavaPostfixTemplatesUtils.isNumber(type2)) {
            return expr2.getText();
        }
        if (JavaPostfixTemplatesUtils.isArray(type2)) {
            return expr2.getText() + ".length";
        }
        if (JavaPostfixTemplatesUtils.isIterable(type2)) {
            return expr2.getText() + ".size()";
        }
        return null;
    }

    @NotNull
    private static String suggestIndexType(@NotNull PsiExpression expr2) {
        PsiType type2 = expr2.getType();
        if (JavaPostfixTemplatesUtils.isNumber(type2)) {
            return type2.getCanonicalText();
        }
        return "int";
    }

    @Override
    public boolean isBuiltin() {
        return true;
    }
}

