/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.ExpressionUtil;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.macro.MacroUtil;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiVariable;
import com.intellij.util.ArrayUtilRt;
import java.util.Arrays;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuggestVariableNameMacro
extends Macro {
    public String getName() {
        return "suggestVariableName";
    }

    public String getPresentableName() {
        return JavaBundle.message((String)"macro.suggest.variable.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getDefaultValue() {
        return "a";
    }

    public Result calculateResult(Expression @NotNull [] params, ExpressionContext context) {
        String[] names2 = SuggestVariableNameMacro.getNames(context);
        if (names2 == null || names2.length == 0) {
            return null;
        }
        return new TextResult(names2[0]);
    }

    @Nullable
    public Result calculateQuickResult(Expression @NotNull [] params, ExpressionContext context) {
        return this.calculateResult(params, context);
    }

    public LookupElement[] calculateLookupItems(Expression @NotNull [] params, ExpressionContext context) {
        String[] names2 = SuggestVariableNameMacro.getNames(context);
        if (names2 == null || names2.length < 2) {
            return null;
        }
        LookupElement[] items = new LookupElement[names2.length];
        for (int i = 0; i < names2.length; ++i) {
            items[i] = LookupElementBuilder.create((String)names2[i]);
        }
        return items;
    }

    private static String[] getNames(ExpressionContext context) {
        String[] names2 = ExpressionUtil.getNames(context);
        if (names2 == null || names2.length == 0) {
            return names2;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)context.getProject()).getPsiFile(context.getEditor().getDocument());
        PsiElement e = file.findElementAt(context.getStartOffset());
        PsiVariable[] vars = MacroUtil.getVariablesVisibleAt(e, "");
        LinkedList<String> namesList = new LinkedList<String>(Arrays.asList(names2));
        for (PsiVariable var : vars) {
            if (e.equals(var.getNameIdentifier())) continue;
            namesList.remove(var.getName());
        }
        if (namesList.isEmpty()) {
            String name2 = names2[0];
            int j = 1;
            while (true) {
                block6: {
                    String name1 = name2 + j;
                    for (PsiVariable var : vars) {
                        if (!name1.equals(var.getName()) || var.getNameIdentifier().equals(e)) {
                            continue;
                        }
                        break block6;
                    }
                    return new String[]{name1};
                }
                ++j;
            }
        }
        return ArrayUtilRt.toStringArray(namesList);
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }

    @NotNull
    public LookupFocusDegree getLookupFocusDegree() {
        return LookupFocusDegree.UNFOCUSED;
    }
}

