/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.text.BlockSupport;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;

public class ExpressionUtil {
    private static final Logger LOG = Logger.getInstance(ExpressionUtil.class);

    private ExpressionUtil() {
    }

    public static String @Nullable [] getNames(ExpressionContext context) {
        Project project = context.getProject();
        int offset = context.getStartOffset();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        String[] names2 = null;
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(context.getEditor().getDocument());
        PsiElement element = file.findElementAt(offset);
        if (element instanceof PsiIdentifier) {
            names2 = ExpressionUtil.getNamesForIdentifier(project, (PsiIdentifier)element);
        } else {
            PsiFile fileCopy = (PsiFile)file.copy();
            ApplicationManager.getApplication().runWriteAction(() -> {
                BlockSupport blockSupport = BlockSupport.getInstance((Project)project);
                try {
                    blockSupport.reparseRange(fileCopy, offset, offset, (CharSequence)"xxx");
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            });
            PsiElement identifierCopy = fileCopy.findElementAt(offset);
            if (identifierCopy instanceof PsiIdentifier) {
                names2 = ExpressionUtil.getNamesForIdentifier(project, (PsiIdentifier)identifierCopy);
            }
        }
        return names2;
    }

    private static String @Nullable [] getNamesForIdentifier(Project project, PsiIdentifier identifier) {
        PsiVariable var;
        if (identifier.getParent() instanceof PsiVariable && identifier.equals((var = (PsiVariable)identifier.getParent()).getNameIdentifier())) {
            PsiForeachStatement foreachStatement;
            PsiExpression iteratedValue2;
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            VariableKind variableKind = codeStyleManager.getVariableKind(var);
            PsiExpression initializer = var.getInitializer();
            if (var instanceof PsiParameter && ((PsiParameter)var).getDeclarationScope() instanceof PsiForeachStatement && (iteratedValue2 = (foreachStatement = (PsiForeachStatement)((PsiParameter)var).getDeclarationScope()).getIteratedValue()) != null) {
                try {
                    PsiArrayAccessExpression expr2 = (PsiArrayAccessExpression)JavaPsiFacade.getElementFactory((Project)iteratedValue2.getProject()).createExpressionFromText("a[0]", (PsiElement)var);
                    expr2.getArrayExpression().replace((PsiElement)iteratedValue2);
                    initializer = expr2;
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    // empty catch block
                }
            }
            SuggestedNameInfo suggestedInfo = codeStyleManager.suggestVariableName(variableKind, null, initializer, var.getType());
            return suggestedInfo.names;
        }
        return null;
    }
}

