/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MethodImplementationsSearch
implements QueryExecutor<PsiElement, DefinitionsScopedSearch.SearchParameters> {
    public boolean execute(@NotNull DefinitionsScopedSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiElement> consumer) {
        PsiElement sourceElement = queryParameters.getElement();
        if (sourceElement instanceof PsiMethod) {
            return MethodImplementationsSearch.processImplementations((PsiMethod)sourceElement, consumer, queryParameters.getScope());
        }
        return true;
    }

    public static boolean processImplementations(PsiMethod psiMethod, Processor<? super PsiElement> consumer, SearchScope searchScope) {
        return MethodImplementationsSearch.processOverridingMethods(psiMethod, searchScope, consumer) && FunctionalExpressionSearch.search((PsiMethod)psiMethod, (SearchScope)searchScope).forEach(consumer);
    }

    public static void getOverridingMethods(PsiMethod method, List<? super PsiMethod> list, SearchScope scope) {
        MethodImplementationsSearch.processOverridingMethods(method, scope, (Processor<? super PsiMethod>)new CommonProcessors.CollectProcessor(list));
    }

    private static boolean processOverridingMethods(PsiMethod method, SearchScope scope, Processor<? super PsiMethod> processor2) {
        return OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)scope, (boolean)true).forEach(processor2);
    }
}

