/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.javadoc;

import com.intellij.codeInsight.javadoc.AnnotationDocGenerator;
import com.intellij.codeInsight.javadoc.AnnotationFormat;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NonCodeAnnotationGenerator {
    private final PsiModifierListOwner myOwner;
    private final StringBuilder myOutput;

    NonCodeAnnotationGenerator(@NotNull PsiModifierListOwner owner2, StringBuilder output) {
        this.myOwner = owner2;
        this.myOutput = output;
    }

    void explainAnnotations() {
        MultiMap<PsiModifierListOwner, AnnotationDocGenerator> generators = NonCodeAnnotationGenerator.getSignatureNonCodeAnnotations(this.myOwner);
        if (generators.isEmpty()) {
            return;
        }
        this.myOutput.append("<tr><td valign='top' class='section'><p>");
        this.myOutput.append(NonCodeAnnotationGenerator.getNonCodeHeader(generators.values())).append(":");
        this.myOutput.append("</td><td valign='top'>");
        generators.keySet().forEach(owner2 -> {
            this.myOutput.append("<p>");
            if (generators.size() > 1) {
                this.myOutput.append(NonCodeAnnotationGenerator.getKind(owner2)).append(" <code>").append(((PsiNamedElement)owner2).getName()).append("</code>: ");
            }
            ArrayList annotations = new ArrayList(generators.get(owner2));
            for (int i = 0; i < annotations.size(); ++i) {
                if (i > 0) {
                    this.myOutput.append(" ");
                }
                ((AnnotationDocGenerator)annotations.get(i)).generateAnnotation(this.myOutput, AnnotationFormat.JavaDocComplete);
            }
        });
        this.myOutput.append("</td>");
    }

    @NotNull
    public static MultiMap<PsiModifierListOwner, AnnotationDocGenerator> getSignatureNonCodeAnnotations(PsiModifierListOwner owner2) {
        MultiMap generators = MultiMap.createLinked();
        for (PsiModifierListOwner each : NonCodeAnnotationGenerator.getSignatureOwners(owner2)) {
            List nonCode = ContainerUtil.filter(AnnotationDocGenerator.getAnnotationsToShow(each), a -> a.isExternal() || a.isInferred());
            if (nonCode.isEmpty()) continue;
            generators.putValues((Object)each, (Collection)nonCode);
        }
        return generators;
    }

    @NotNull
    private static List<PsiModifierListOwner> getSignatureOwners(PsiModifierListOwner owner2) {
        ArrayList<PsiModifierListOwner> allOwners = new ArrayList<PsiModifierListOwner>();
        allOwners.add(owner2);
        if (owner2 instanceof PsiMethod) {
            Collections.addAll(allOwners, ((PsiMethod)owner2).getParameterList().getParameters());
        }
        return allOwners;
    }

    @NotNull
    public static String getNonCodeHeader(Collection<? extends AnnotationDocGenerator> values) {
        boolean hasExternal = values.stream().anyMatch(AnnotationDocGenerator::isExternal);
        boolean hasInferred = values.stream().anyMatch(AnnotationDocGenerator::isInferred);
        return (hasExternal && hasInferred ? "External and <i>inferred</i>" : (hasExternal ? "External" : "<i>Inferred</i>")) + " annotations";
    }

    private static String getKind(PsiModifierListOwner owner2) {
        if (owner2 instanceof PsiParameter) {
            return "Parameter";
        }
        if (owner2 instanceof PsiMethod) {
            return ((PsiMethod)owner2).isConstructor() ? "Constructor" : "Method";
        }
        return owner2.getClass().getName();
    }
}

